/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import com.stonecraft.datastore.AggregateQuery;
import com.stonecraft.datastore.AggregateQueryTask;
import com.stonecraft.datastore.AndroidDBConnection;
import com.stonecraft.datastore.AndroidQueryCreator;
import com.stonecraft.datastore.CreateTableTask;
import com.stonecraft.datastore.DatabaseNonQueryTask;
import com.stonecraft.datastore.DatabaseQueryTask;
import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.DatastoreTransaction;
import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.OnAggregateQueryComplete;
import com.stonecraft.datastore.OnConnectionListener;
import com.stonecraft.datastore.OnQueryComplete;
import com.stonecraft.datastore.QueryDeserializer;
import com.stonecraft.datastore.RowCountQuery;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.IRawStatement;
import com.stonecraft.datastore.interaction.Insert;
import com.stonecraft.datastore.interaction.Query;
import com.stonecraft.datastore.interaction.Statement;
import com.stonecraft.datastore.interaction.Update;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.ISchemaCreator;
import com.stonecraft.datastore.interfaces.OnNonQueryComplete;
import com.stonecraft.datastore.interfaces.OnTaskCompleteListener;
import com.stonecraft.datastore.interfaces.Tasker;
import com.stonecraft.datastore.parser.DatabaseParser;
import com.stonecraft.datastore.view.DatabaseTable;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class Datastore
implements OnTaskCompleteListener {
    public static final int DEFAULT_TOKEN = -1;
    public static final String DB_EXTENSION = ".sqlite";
    public static final int FAIL_TYPE_QUERY_FAILED = -1;
    private static volatile Map<String, IDBConnector> myDBConnections;
    private static volatile List<DatabaseTask> myQueuedTasks;
    private static volatile Map<String, Map<Class, QueryDeserializer>> myDeserializers;
    private IDBConnector myActiveDatabase = null;
    private boolean myTasksQueued = true;
    private boolean myBlockingCall = false;
    private boolean myIsAttemptReconnect = true;
    private static volatile CountDownLatch myParsingLatch;
    private static final AtomicInteger myParsingCount;

    private Datastore() {
        if (myDBConnections == null) {
            myDBConnections = new HashMap<String, IDBConnector>();
        }
        if (myQueuedTasks == null) {
            myQueuedTasks = new ArrayList<DatabaseTask>();
        }
    }

    private Datastore(IDBConnector connection) {
        this();
        this.myActiveDatabase = connection;
    }

    public static Datastore getDataStore(String connection) {
        try {
            myParsingLatch.await();
            if (myDBConnections != null && myDBConnections.containsKey(connection)) {
                return new Datastore(myDBConnections.get(connection));
            }
        }
        catch (InterruptedException e) {
            Log.e((String)Datastore.class.getSimpleName(), (String)("The current thread has been interruprted. A datastore object will not be returned [" + e + "]"));
        }
        return null;
    }

    public String getDatabaseName() {
        return this.myActiveDatabase.getName();
    }

    public Calendar getLastTableUpdateTime(String tableName) {
        return this.myActiveDatabase.getTableChangeDate(tableName);
    }

    public boolean isBlockingCall() {
        return this.myBlockingCall;
    }

    public Datastore setBlockingCall(boolean blockingCall) {
        this.myBlockingCall = blockingCall;
        return this;
    }

    public boolean isTasksQueued() {
        return this.myTasksQueued;
    }

    public Datastore setTasksQueued(boolean queuedTasks) {
        this.myTasksQueued = queuedTasks;
        return this;
    }

    public boolean isAttemptReconnect() {
        return this.myIsAttemptReconnect;
    }

    public void setAttemptReconnect(boolean isAttemptReconnect) {
        this.myIsAttemptReconnect = isAttemptReconnect;
    }

    public static synchronized void createConnection(final Context context, InputStream databaseXml, final OnConnectionListener listener) throws DatabaseException {
        myParsingCount.incrementAndGet();
        if (myParsingLatch == null || myParsingLatch.getCount() == 0L) {
            myParsingLatch = new CountDownLatch(1);
        }
        DatabaseParser parser = new DatabaseParser(new DatabaseParser.OnSchemaModelCreated(){

            @Override
            public void OnSchemaModelCreated(DbSchemaModel schema) {
                AndroidDBConnection connector = new AndroidDBConnection(context, schema, listener);
                Datastore.setConnection(connector);
                if (myParsingCount.decrementAndGet() == 0) {
                    myParsingLatch.countDown();
                }
            }
        });
        parser.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new InputStream[]{databaseXml});
        Log.d((String)"createConnection", (String)"Creating connection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setConnection(IDBConnector connection) {
        new Datastore();
        Class<Datastore> clazz = Datastore.class;
        synchronized (Datastore.class) {
            if (myDBConnections.containsKey(connection.getName())) {
                IDBConnector oldConnection = myDBConnections.remove(connection.getName());
                try {
                    if (oldConnection.isOpen()) {
                        oldConnection.close();
                    }
                }
                catch (DatabaseException e) {
                    Log.w((String)Datastore.class.getSimpleName(), (String)("Failed to close old connection to datastore with name " + connection.getName() + " [" + e + "]"));
                }
            }
            if (myDBConnections.containsKey(connection.getName())) return;
            Class<Datastore> clazz2 = Datastore.class;
            synchronized (Datastore.class) {
                if (myDBConnections.containsKey(connection.getName())) return;
                myDBConnections.put(connection.getName(), connection);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public void createSchema(ISchemaCreator schema) throws DatabaseException {
        this.myActiveDatabase.createSchema(schema);
    }

    public static void closeAll() throws DatabaseException {
        if (myDBConnections != null) {
            for (Map.Entry<String, IDBConnector> entry : myDBConnections.entrySet()) {
                IDBConnector conn = entry.getValue();
                if (!conn.isOpen()) continue;
                conn.close();
            }
        }
    }

    public void close() throws DatabaseException {
        if (this.myActiveDatabase != null && this.myActiveDatabase.isOpen()) {
            this.myActiveDatabase.close();
        }
    }

    public static void addQueryDeserializer(String tableName, QueryDeserializer deserializer) {
        Map<Object, Object> deserializerMap;
        Method[] methods = deserializer.getClass().getMethods();
        Class deserializerClass = Object.class;
        for (Method method : methods) {
            Class<?> clazz;
            if (!method.getName().equals("parseData") || (clazz = method.getReturnType()).getComponentType().getName().equals(Object.class.getName())) continue;
            deserializerClass = clazz.getComponentType();
            break;
        }
        if (deserializerClass == null) {
            throw new RuntimeException("The passed in deserializer has not been typed.");
        }
        if (myDeserializers.containsKey(tableName)) {
            deserializerMap = myDeserializers.get(tableName);
            deserializerMap.put(deserializerClass, deserializer);
        } else {
            deserializerMap = new HashMap();
            deserializerMap.put(deserializerClass, deserializer);
            myDeserializers.put(tableName, deserializerMap);
        }
    }

    public void executeQuery(int token, Query stmt, OnQueryComplete listener) {
        Method[] methods = listener.getClass().getMethods();
        Class injectorClass = Object.class;
        for (Method method : methods) {
            Class<?>[] clazzes;
            if (!method.getName().equals("onQueryComplete")) continue;
            for (Class<?> clazz : clazzes = method.getParameterTypes()) {
                if (clazz.getComponentType() == null) continue;
                Class<?> testClass = clazz.getComponentType();
                if (clazz.getComponentType().getName().equals(Object.class.getName())) continue;
                injectorClass = clazz.getComponentType();
            }
        }
        try {
            if (!this.validateDBConnection()) {
                throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
            }
        }
        catch (DatabaseException e) {
            listener.onQueryFailed(token, e);
        }
        int taskId = new AtomicInteger().incrementAndGet();
        DatabaseQueryTask task = new DatabaseQueryTask(taskId, token, this, stmt);
        task.setOnQueryCompleteListener(listener);
        task.setInjectorClass(injectorClass);
        QueryDeserializer queryDeserializer = this.getQueryDeserializer(stmt, injectorClass);
        task.setQueryDeserializer(queryDeserializer);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onQueryFailed(token, e);
        }
    }

    public <T> T[] executeQuery(Query stmt, Class<T> classToInject) throws DatabaseException {
        if (!this.validateDBConnection()) {
            throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
        }
        int taskId = new AtomicInteger().incrementAndGet();
        DatabaseQueryTask task = new DatabaseQueryTask(taskId, -1, this, stmt);
        QueryDeserializer queryDeserializer = this.getQueryDeserializer(stmt, classToInject);
        task.setQueryDeserializer(queryDeserializer);
        return task.startTask(classToInject);
    }

    public void executeAggregateQuery(int token, AggregateQuery stmt, OnAggregateQueryComplete listener) {
        try {
            if (!this.validateDBConnection()) {
                throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
            }
        }
        catch (DatabaseException e) {
            listener.onQueryFailed(token, e);
        }
        int taskId = new AtomicInteger().incrementAndGet();
        AggregateQueryTask task = new AggregateQueryTask(taskId, -1, this, stmt);
        task.setOnQueryCompleteListener(listener);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onQueryFailed(token, e);
        }
    }

    public Object executeAggregateQuery(AggregateQuery stmt) throws DatabaseException {
        if (!this.validateDBConnection()) {
            throw new DatabaseException("Attempt to reopen an already closed database object. Ensure a connection to the database is currently valid and open");
        }
        int taskId = new AtomicInteger().incrementAndGet();
        AggregateQueryTask task = new AggregateQueryTask(taskId, -1, this, stmt);
        return task.run();
    }

    public void executeNonQuery(int token, Statement stmt, OnNonQueryComplete listener) {
        int taskId = new AtomicInteger().incrementAndGet();
        DatastoreTransaction dt = new DatastoreTransaction();
        dt.setConnection(this.myActiveDatabase);
        dt.addStatement(stmt);
        DatabaseNonQueryTask task = new DatabaseNonQueryTask(taskId, token, this, dt);
        task.addOnStmtCompleteListener(listener);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onNonQueryComplete(token, -1);
        }
    }

    public int executeNonQuery(Statement stmt) throws DatabaseException {
        int taskId = new AtomicInteger().incrementAndGet();
        DatastoreTransaction dt = new DatastoreTransaction();
        dt.setConnection(this.myActiveDatabase);
        dt.addStatement(stmt);
        DatabaseNonQueryTask task = new DatabaseNonQueryTask(taskId, -1, this, dt);
        task.startTask();
        return task.getTaskResult();
    }

    public void executeAddOrUpdate(int token, final String whereClause, final Insert insert, final OnNonQueryComplete listener) {
        RowCountQuery query = new RowCountQuery(insert.getTable());
        query.whereClause(whereClause);
        this.executeAggregateQuery(token, query, new OnAggregateQueryComplete(){

            @Override
            public void onQueryComplete(int token, Object result) {
                long rowCount = (Long)result;
                Statement updateOrAddStmt = null;
                if (rowCount <= 0L) {
                    updateOrAddStmt = insert;
                } else {
                    if (insert.getInsertRowClasses() != null) {
                        Update update = new Update(insert.getTable(), insert.getInsertRowClasses());
                        updateOrAddStmt = update;
                    } else {
                        Map<String, Object> values = insert.getValues();
                        if (!values.isEmpty()) {
                            Update update = new Update<Map<String, Object>>(insert.getTable(), values).whereClause(whereClause);
                            updateOrAddStmt = update;
                        }
                    }
                    ((Update)updateOrAddStmt).whereClause(whereClause);
                }
                if (updateOrAddStmt != null) {
                    Datastore.this.executeNonQuery(token, updateOrAddStmt, listener);
                } else {
                    listener.onNonQueryFailed(token, new DatabaseException("No values were in the insert object when a executeAddOrUpdate() was attempted"));
                }
            }

            @Override
            public void onQueryFailed(int token, DatabaseException e) {
                if (listener != null) {
                    listener.onNonQueryFailed(token, e);
                }
            }
        });
    }

    public boolean isConnectionAvail() {
        try {
            return this.myActiveDatabase.isOpen();
        }
        catch (DatabaseException e) {
            Log.e((String)Datastore.class.getSimpleName(), (String)("Failed to check if database is open [" + e + "] false will be returned from isConnectionAvail()"));
            return false;
        }
    }

    public void doesTableExist(int token, String tableName, OnNonQueryComplete listener) {
        int taskId = new AtomicInteger().incrementAndGet();
        DatastoreTransaction dt = new DatastoreTransaction();
        dt.setConnection(this.myActiveDatabase);
        dt.addStatement(new Statement(tableName));
        DatabaseNonQueryTask task = new DatabaseNonQueryTask(taskId, token, this, dt);
        task.addOnStmtCompleteListener(listener);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onNonQueryFailed(token, e);
        }
    }

    public void createTable(int token, DatabaseTable table, OnNonQueryComplete listener) {
        int taskId = new AtomicInteger().incrementAndGet();
        CreateTableTask task = new CreateTableTask(taskId, token, this, table);
        task.addOnStmtCompleteListener(listener);
        try {
            this.executeStmt(task);
        }
        catch (DatabaseException e) {
            listener.onNonQueryFailed(token, e);
        }
    }

    public void executeRawStatement(int token, IRawStatement stmt) throws DatabaseException {
        int taskId = new AtomicInteger().incrementAndGet();
        DatastoreTransaction dt = new DatastoreTransaction();
        dt.setConnection(this.myActiveDatabase);
        dt.addStatement(stmt);
        DatabaseNonQueryTask task = new DatabaseNonQueryTask(taskId, -1, this, dt);
        task.startTask();
    }

    public String getRawQuery(Query query) throws DatabaseException {
        AndroidQueryCreator aqc = new AndroidQueryCreator(this.myActiveDatabase.getDatabaseSchema());
        if (query.getJoins().isEmpty()) {
            throw new UnsupportedOperationException("This method does not support creating a  raw query from a Query object that doesn't contain a join at this time");
        }
        return aqc.getSQLJoinQuery(query);
    }

    public Uri getTableUri(String tableName) {
        return this.myActiveDatabase.getTableUri(tableName);
    }

    IDBConnector getActiveDatabase() {
        return this.myActiveDatabase;
    }

    boolean validateDBConnection() throws DatabaseException {
        if (this.isConnectionAvail()) {
            return true;
        }
        if (this.myIsAttemptReconnect) {
            try {
                this.myActiveDatabase.createConnection();
            }
            catch (DatabaseException e) {
                Log.e((String)Datastore.class.getSimpleName(), (String)("Failed to recreate a connection to the database [" + e + "]"));
                return false;
            }
            return true;
        }
        return false;
    }

    private void executeStmt(DatabaseTask task) throws DatabaseException {
        if (this.isBlockingCall()) {
            task.startTask();
        } else if (this.isTasksQueued()) {
            task.addOnTaskCompleteListener(this);
            this.addTaskToQueue(task);
        } else {
            task.execute(new Void[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addTaskToQueue(DatabaseTask dt) throws DatabaseException {
        List<DatabaseTask> list = myQueuedTasks;
        synchronized (list) {
            myQueuedTasks.add(dt);
            if (myQueuedTasks.size() == 1) {
                dt.execute(new Void[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskComplete(Tasker task) {
        List<DatabaseTask> list = myQueuedTasks;
        synchronized (list) {
            myQueuedTasks.remove(task);
            if (myQueuedTasks.size() > 0) {
                if (myQueuedTasks.get(0).isTaskRunning()) {
                    this.onTaskComplete(myQueuedTasks.get(0));
                } else {
                    myQueuedTasks.get(0).execute(new Void[0]);
                }
            }
        }
    }

    private QueryDeserializer getQueryDeserializer(Query stmt, Class injectorClass) {
        Map<Class, QueryDeserializer> tableDeserializers;
        QueryDeserializer queryDeserializer = null;
        if (myDeserializers.containsKey(stmt.getTable()) && (tableDeserializers = myDeserializers.get(stmt.getTable())).containsKey(injectorClass)) {
            queryDeserializer = tableDeserializers.get(injectorClass);
        }
        return queryDeserializer;
    }

    static {
        myDeserializers = new HashMap<String, Map<Class, QueryDeserializer>>();
        myParsingCount = new AtomicInteger(0);
    }
}

