/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import com.stonecraft.datastore.ContentValueCreator;
import com.stonecraft.datastore.DatabaseHelper;
import com.stonecraft.datastore.DatabaseUtils;
import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.OnConnectionCreated;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.RowCountQuery;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Delete;
import com.stonecraft.datastore.interaction.Insert;
import com.stonecraft.datastore.interaction.Join;
import com.stonecraft.datastore.interaction.Query;
import com.stonecraft.datastore.interaction.Update;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.ISchemaCreator;
import com.stonecraft.datastore.utils.StringUtils;
import com.stonecraft.datastore.view.DatabaseColumn;
import com.stonecraft.datastore.view.DatabaseTable;
import com.stonecraft.datastore.view.DatabaseViewFactory;
import com.stonecraft.datastore.view.SqliteDBViewFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidDBConnection
implements IDBConnector {
    public static final String TABLE_SQLITE_MASTER = "sqlite_master";
    public static final String TABLE_ANDROID_METADATA = "android_metadata";
    public static final String TABLE_SQLITE_SEQUENCE = "sqlite_sequence";
    public static final String COL_SQL = "sql";
    private static final String QUERY_TABLE_EXISTS = "SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = '%s'";
    private static final String STATEMENT_COPY_TABLE = "INSERT INTO %s (%s) SELECT %s FROM %s";
    private static final String STATEMENT_RENAME_TABLE = "ALTER TABLE %s RENAME TO %s";
    private static final String STATEMENT_DROP_TABLE = "DROP TABLE %s";
    private static final String JOIN_CROSS_STRING = " CROSS JOIN ";
    private static final String JOIN_INNER_STRING = " INNER JOIN ";
    private static final String JOIN_LEFT_OUTER_STRING = " LEFT OUTER JOIN ";
    private DatabaseHelper myDBOpenHelper;
    private DbSchemaModel myDbSchema;
    private Context myAppContext;
    private Map<Class, ContentValueCreator> myContentValueCreator;

    public AndroidDBConnection(Context context, DbSchemaModel dbSchema, OnConnectionCreated listener) {
        this.myAppContext = context;
        this.myDbSchema = dbSchema;
        this.myDBOpenHelper = new DatabaseHelper(context, this, this.myDbSchema, listener);
        this.myContentValueCreator = new HashMap<Class, ContentValueCreator>();
    }

    @Override
    public String getName() {
        return this.myDbSchema.getName();
    }

    @Override
    public Context getContext() {
        return this.myAppContext;
    }

    @Override
    public int getVersion() {
        return this.myDbSchema.getVersion();
    }

    @Override
    public void startTransaction() throws DatabaseException {
        this.myDBOpenHelper.getReadableDatabase().beginTransaction();
    }

    @Override
    public void commit() throws DatabaseException {
        this.myDBOpenHelper.getReadableDatabase().setTransactionSuccessful();
        this.myDBOpenHelper.getReadableDatabase().endTransaction();
    }

    @Override
    public void rollBack() throws DatabaseException {
        this.myDBOpenHelper.getReadableDatabase().endTransaction();
    }

    @Override
    public void close() {
        this.myDBOpenHelper.getReadableDatabase().close();
    }

    @Override
    public boolean isOpen() throws DatabaseException {
        return this.myDBOpenHelper.getReadableDatabase().isOpen();
    }

    @Override
    public RSData query(Query query) throws DatabaseException {
        try {
            Cursor cursor = null;
            if (query.getJoins().isEmpty()) {
                StringBuilder limit;
                StringBuilder stringBuilder = limit = query.getLimit() > 0 ? new StringBuilder().append(query.getLimit()) : null;
                if (query.getLimit() > 0 && query.getOffset() > 0) {
                    limit.append(" OFFSET ").append(query.getOffset());
                }
                cursor = this.myDBOpenHelper.getReadableDatabase().query(query.isdistinct(), query.getTable(), query.getColumns(), query.getWhereClause(), this.getArguments(query.getSelectionArgs()), query.getGroupBy(), query.getHaving(), query.getOrderBy(), limit == null ? null : limit.toString());
            } else {
                String queryString = this.getSQLJoinQuery(query);
                String[] args = null;
                List<String> listArgs = query.getSelectionArgs();
                if (listArgs != null && !listArgs.isEmpty()) {
                    args = listArgs.toArray(new String[listArgs.size()]);
                }
                cursor = this.myDBOpenHelper.getReadableDatabase().rawQuery(queryString, args);
            }
            return new QueryRSData(cursor);
        }
        catch (SQLiteException e) {
            throw new DatabaseException("", e);
        }
    }

    @Override
    public long queryNumEntries(RowCountQuery query) {
        if (query.getSelectionArgs() != null && !query.getSelectionArgs().isEmpty()) {
            List<String> args = query.getSelectionArgs();
            return android.database.DatabaseUtils.queryNumEntries((SQLiteDatabase)this.myDBOpenHelper.getReadableDatabase(), (String)query.getTable(), (String)query.getWhereClause(), (String[])args.toArray(new String[args.size()]));
        }
        return android.database.DatabaseUtils.queryNumEntries((SQLiteDatabase)this.myDBOpenHelper.getReadableDatabase(), (String)query.getTable(), (String)query.getWhereClause());
    }

    @Override
    public void insert(Insert insert) throws DatabaseException {
        ContentValues cv;
        if (insert.getInsertRowClasses() != null) {
            ContentValueCreator cvCreator = this.myContentValueCreator.get(insert.getInsertRowClasses().getClass());
            if (cvCreator == null) {
                cvCreator = new ContentValueCreator();
                this.myContentValueCreator.put(insert.getInsertRowClasses().getClass(), cvCreator);
            }
            cv = cvCreator.getContentValues(insert.getInsertRowClasses());
        } else {
            cv = new ContentValueCreator().getContentValues(insert.getValues().entrySet());
        }
        SQLiteDatabase db = this.myDBOpenHelper.getWritableDatabase();
        db.insertOrThrow(insert.getTable(), null, cv);
    }

    @Override
    public int update(Update update) throws DatabaseException {
        ContentValues cv;
        if (update.getUpdateClass() != null) {
            ContentValueCreator cvCreator = this.myContentValueCreator.get(update.getUpdateClass());
            if (cvCreator == null) {
                cvCreator = new ContentValueCreator();
                this.myContentValueCreator.put(update.getUpdateClass().getClass(), cvCreator);
            }
            cv = cvCreator.getContentValues(update.getUpdateClass());
        } else {
            cv = new ContentValueCreator().getContentValues(update.getValues().entrySet());
        }
        int updateCount = this.myDBOpenHelper.getWritableDatabase().update(update.getTable(), cv, update.getWhereClause(), this.getArguments(update.getArguments()));
        DatabaseTable table = this.myDbSchema.getTable(update.getTable());
        if (table != null) {
            this.myAppContext.getContentResolver().notifyChange(table.getUri(), null, false);
        }
        return updateCount;
    }

    @Override
    public int delete(Delete delete) throws DatabaseException {
        int deleteCount = this.myDBOpenHelper.getWritableDatabase().delete(delete.getTable(), delete.getWhereClause(), this.getArguments(delete.getArguments()));
        DatabaseTable table = this.myDbSchema.getTable(delete.getTable());
        if (table != null) {
            this.myAppContext.getContentResolver().notifyChange(table.getUri(), null, false);
        }
        return deleteCount;
    }

    @Override
    public void executeRawStatement(String stmt) throws DatabaseException {
        this.myDBOpenHelper.getReadableDatabase().execSQL(stmt);
    }

    @Override
    public RSData executeRawQuery(String stmt) throws DatabaseException {
        Cursor c = this.myDBOpenHelper.getReadableDatabase().rawQuery(stmt, null);
        return new QueryRSData(c);
    }

    @Override
    public int doesTableExist(String tableName) throws DatabaseException {
        String stmt = String.format(QUERY_TABLE_EXISTS, tableName);
        RSData resultSet = this.executeRawQuery(stmt);
        int tableCount = resultSet.getCount();
        resultSet.close();
        return tableCount;
    }

    @Override
    public void createConnection() throws DatabaseException {
        if (!this.isOpen()) {
            this.myDBOpenHelper.reconnect();
        }
    }

    @Override
    public DbSchemaModel getDatabaseSchema() {
        return this.myDbSchema;
    }

    @Override
    public Uri getTableUri(String tableName) {
        try {
            if (DatabaseUtils.isSystemTable(tableName)) {
                return null;
            }
            return this.myDbSchema.getTable(tableName).getUri();
        }
        catch (NullPointerException e) {
            NullPointerException exception = new NullPointerException("The table " + tableName + " does not exist. Please check the correct name in the database xml");
            exception.setStackTrace(e.getStackTrace());
            return null;
        }
    }

    @Override
    public Calendar getTableChangeDate(String tableName) {
        DatabaseTable table = this.myDbSchema.getTable(tableName);
        if (table != null) {
            return table.getLastTableUpdate();
        }
        return null;
    }

    @Override
    public void sendTableUpdateNotification(String tableName) {
        DatabaseTable table = this.myDbSchema.getTable(tableName);
        if (table != null) {
            table.notifyTableUpdate();
            this.myAppContext.getContentResolver().notifyChange(table.getUri(), null, false);
        }
    }

    @Override
    public void createSchema(ISchemaCreator database) throws DatabaseException {
    }

    @Override
    public DatabaseViewFactory getTableObjectFactory() {
        return new SqliteDBViewFactory();
    }

    @Override
    public void updateTable(DatabaseTable oldTable, DatabaseTable newTable) throws DatabaseException {
        newTable.setTempTable(true);
        this.executeRawStatement(newTable.getCreateTableStmt());
        String columnString = this.getMapedColumnString(oldTable, newTable);
        this.executeRawStatement(String.format(STATEMENT_COPY_TABLE, newTable.getDBName(), columnString, columnString, oldTable.getName()));
        this.executeRawStatement(String.format(STATEMENT_DROP_TABLE, oldTable.getName()));
        this.executeRawStatement(String.format(STATEMENT_RENAME_TABLE, newTable.getDBName(), oldTable.getName()));
    }

    @Override
    public int checkColumnUpdateRules(DatabaseColumn column, DatabaseColumn newSchemaColumn) {
        if (column.equals(newSchemaColumn)) {
            return 0;
        }
        if (this.checkTypeUpgradeRules(column, newSchemaColumn)) {
            return 1;
        }
        if (column.getType() == newSchemaColumn.getType() && column.isPrimarykey() == newSchemaColumn.isPrimarykey()) {
            if (column.isNullable() && !newSchemaColumn.isNullable()) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    private boolean checkTypeUpgradeRules(DatabaseColumn column, DatabaseColumn newSchemaColumn) {
        if (column.getType() != newSchemaColumn.getType()) {
            if (newSchemaColumn.getType() == 12) {
                return true;
            }
            if (!(column.getType() != 4 && column.getType() != 16 && column.getType() != 91 || newSchemaColumn.getType() != 4 && newSchemaColumn.getType() != 16 && newSchemaColumn.getType() != 91)) {
                return true;
            }
            if (column.getType() == newSchemaColumn.getType() && !column.isNullable() && newSchemaColumn.isNullable()) {
                return true;
            }
        }
        return false;
    }

    private String getMapedColumnString(DatabaseTable oldTable, DatabaseTable newTable) {
        ArrayList<String> columns = new ArrayList<String>();
        for (Map.Entry<String, DatabaseColumn> entry : oldTable.getColumns().entrySet()) {
            if (!newTable.getColumns().containsKey(entry.getKey())) continue;
            columns.add(entry.getValue().getName());
        }
        return StringUtils.convertListToDelimitedString(columns, ",");
    }

    private String[] getArguments(List<String> args) {
        if (args == null) {
            return null;
        }
        String[] returnArgs = new String[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            returnArgs[i] = args.get(i);
        }
        return returnArgs;
    }

    private String getSQLJoinQuery(Query query) throws DatabaseException {
        StringBuilder statementBuilder = new StringBuilder();
        statementBuilder.append("SELECT");
        StringBuilder colBuilder = new StringBuilder();
        if (query.getColumns() == null || query.getColumns().length == 0) {
            colBuilder.append(this.getColumnClause(query));
        } else {
            for (String column : query.getColumns()) {
                if (colBuilder.length() > 0) {
                    colBuilder.append(",");
                }
                colBuilder.append(this.getColumnClause(column));
            }
        }
        if (query.isdistinct()) {
            statementBuilder.append(" DISTINCT").append("(");
            statementBuilder.append((CharSequence)colBuilder).append(") ");
        } else {
            statementBuilder.append(" " + colBuilder + " ");
        }
        statementBuilder.append("FROM").append(this.getJoinClause(query.getTable(), query));
        if (!StringUtils.isEmpty(query.getWhereClause())) {
            statementBuilder.append(" WHERE " + query.getWhereClause());
        }
        if (!StringUtils.isEmpty(query.getOrderBy())) {
            statementBuilder.append(" ORDER BY " + query.getOrderBy());
        }
        if (!StringUtils.isEmpty(query.getGroupBy())) {
            statementBuilder.append(" GROUP BY " + query.getGroupBy());
        }
        if (!StringUtils.isEmpty(query.getHaving())) {
            statementBuilder.append(" HAVING " + query.getHaving());
        }
        if (query.getLimit() > 0) {
            statementBuilder.append(" LIMIT " + query.getLimit());
        }
        if (query.getLimit() > 0 && query.getOffset() > 0) {
            statementBuilder.append(" OFFSET " + query.getOffset());
        }
        return statementBuilder.toString();
    }

    private String getJoinClause(String table, Query statement) {
        StringBuilder joinBuilder = new StringBuilder(" ");
        joinBuilder.append(table);
        for (Join join : statement.getJoins()) {
            switch (join.getJoinType()) {
                case 0: {
                    joinBuilder.append(JOIN_CROSS_STRING);
                    break;
                }
                case 1: {
                    joinBuilder.append(JOIN_INNER_STRING);
                    break;
                }
                case 2: {
                    joinBuilder.append(JOIN_LEFT_OUTER_STRING);
                }
            }
            joinBuilder.append(join.getTable());
            if (join.getJoinType() == 0) continue;
            joinBuilder.append(" ").append("ON").append(" ");
            StringBuilder joinExpressionBuilder = new StringBuilder();
            for (Join.JoinExpression expression : join.getJoinExpressions()) {
                if (joinExpressionBuilder.length() > 0) {
                    joinExpressionBuilder.append(" ").append("AND").append(" ");
                }
                joinExpressionBuilder.append((String)expression.getLeftColumn().first).append(".");
                joinExpressionBuilder.append((String)expression.getLeftColumn().second);
                joinExpressionBuilder.append(" = ");
                joinExpressionBuilder.append((String)expression.getRightColumn().first).append(".");
                joinExpressionBuilder.append((String)expression.getRightColumn().second);
            }
            joinBuilder.append((CharSequence)joinExpressionBuilder);
        }
        return joinBuilder.toString();
    }

    public String getColumnClause(Query query) {
        StringBuilder columnClause = new StringBuilder();
        String[] columns = query.getColumns();
        if (columns != null && columns.length > 0) {
            return this.getColumnClause(query.getTable(), columns);
        }
        String mainTable = this.getColumnClause(query.getTable(), null);
        if (!query.getJoins().isEmpty()) {
            for (Join join : query.getJoins()) {
                columnClause.append(", ");
                columnClause.append(this.getColumnClause(join.getTable(), null));
            }
        }
        return mainTable + " " + columnClause.toString();
    }

    public String getColumnClause(String delimitedTableColumnName) throws DatabaseException {
        String[] tableColumnPair = delimitedTableColumnName.split("\\.");
        int count = tableColumnPair.length;
        try {
            return delimitedTableColumnName + " AS " + DatabaseUtils.getDatabaseAsName(tableColumnPair[0], tableColumnPair[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DatabaseException("Column names must be delimited with the table name in a joined query");
        }
    }

    public String getColumnClause(String tableName, String[] columns) {
        DatabaseTable table = this.myDbSchema.getTable(tableName);
        StringBuilder columnClause = new StringBuilder();
        if (columns != null && columns.length > 0) {
            for (String column : columns) {
                columnClause.append((String)column + " AS " + (String)column);
            }
        }
        for (Map.Entry entry : table.getColumns().entrySet()) {
            if (columnClause.length() > 0) {
                columnClause.append(", ");
            }
            String key = tableName + "." + (String)entry.getKey();
            columnClause.append(key + " AS " + DatabaseUtils.getDatabaseAsName(tableName, (String)entry.getKey()));
        }
        return columnClause.toString();
    }

    public static class QueryRSData
    implements RSData {
        private static final int COLUMN_NOT_FOUND = -1;
        private Cursor myCursor;
        private Map<String, Integer> myColumnIndexes;

        QueryRSData(Cursor cursor) {
            this.myCursor = cursor;
            this.myColumnIndexes = new HashMap<String, Integer>();
        }

        @Override
        public boolean hasNext() {
            return this.myCursor.getPosition() < this.myCursor.getCount() - 1;
        }

        @Override
        public boolean isAfterLast() {
            return this.myCursor.getPosition() >= this.myCursor.getCount();
        }

        @Override
        public RSData next() {
            this.myCursor.moveToNext();
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCount() {
            return this.myCursor.getCount();
        }

        @Override
        public String getStringValue(String column) throws DatabaseException {
            int colIndex = this.getCursorIndex(column);
            return this.myCursor.getString(colIndex);
        }

        @Override
        public boolean getBooleanValue(String column) throws DatabaseException {
            int intValue = this.getIntValue(column);
            return intValue != 0;
        }

        @Override
        public int getIntValue(String column) throws DatabaseException {
            int colIndex = this.getCursorIndex(column);
            return this.myCursor.getInt(colIndex);
        }

        @Override
        public int getColumnCount() {
            return this.myCursor.getColumnCount();
        }

        @Override
        public long getLongValue(String column) throws DatabaseException {
            int colIndex = this.getCursorIndex(column);
            return this.myCursor.getLong(colIndex);
        }

        @Override
        public double getDoubleValue(String column) throws DatabaseException {
            int colIndex = this.getCursorIndex(column);
            return this.myCursor.getDouble(colIndex);
        }

        @Override
        public float getFloatValue(String column) throws DatabaseException {
            int colIndex = this.getCursorIndex(column);
            return this.myCursor.getFloat(colIndex);
        }

        @Override
        public Date getDateValue(String column) throws DatabaseException {
            int colIndex = this.getCursorIndex(column);
            long timeInMillis = this.myCursor.getLong(colIndex);
            return new Date(timeInMillis);
        }

        @Override
        public Calendar getCalendarValue(String column) throws DatabaseException {
            Date date = this.getDateValue(column);
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            return null;
        }

        @Override
        public boolean containsNull(String column) throws DatabaseException {
            int colIndex = this.getCursorIndex(column);
            return this.myCursor.isNull(colIndex);
        }

        @Override
        public byte[] getBlobData(String column) throws DatabaseException {
            try {
                int colIndex = this.getCursorIndex(column);
                return this.myCursor.getBlob(colIndex);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("This could be caused by a limitation in the size of data that can be stored in a sqlite database cell.", e);
            }
        }

        @Override
        public void moveToFirst() {
            this.myCursor.moveToFirst();
        }

        @Override
        public void close() {
            this.myCursor.close();
        }

        private int getCursorIndex(String column) throws DatabaseException {
            if (this.myColumnIndexes.containsKey(column)) {
                return this.myColumnIndexes.get(column);
            }
            int colIndex = this.myCursor.getColumnIndex(column);
            if (colIndex == -1) {
                throw new DatabaseException("The column " + column + " is not a valid column in this result set");
            }
            this.myColumnIndexes.put(column, colIndex);
            return colIndex;
        }

        @Override
        public boolean moveToPosition(int postion) {
            return this.myCursor.moveToPosition(postion);
        }

        @Override
        public boolean hasColumn(String columnName) {
            return this.myCursor.getColumnIndex(columnName) >= 0;
        }
    }
}

