/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.support.v4.os.CancellationSignal;
import android.support.v4.os.OperationCanceledException;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class DbDataLoader<T>
extends AsyncTaskLoader<T> {
    private volatile CancellationSignal myCancellationSignal;
    private Map<Uri, Loader.ForceLoadContentObserver> myObservers = new HashMap<Uri, Loader.ForceLoadContentObserver>();
    private T myResult;
    private final String myDbName;
    private final Query myQuery;
    private final Class myLoaderResultType;
    private Calendar myTableUpdateTime;
    private boolean myIsIgnoringUpdates;

    public DbDataLoader(Context context, String dbName, Query query, Class loaderResultType) {
        super(context);
        Datastore ds = Datastore.getDataStore(dbName);
        this.addWatchUri(ds.getTableUri(query.getTable()));
        this.myDbName = dbName;
        this.myQuery = query;
        this.myLoaderResultType = loaderResultType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T loadInBackground() {
        DbDataLoader dbDataLoader = this;
        synchronized (dbDataLoader) {
            if (this.isLoadInBackgroundCanceled()) {
                throw new OperationCanceledException();
            }
            this.myCancellationSignal = new CancellationSignal();
        }
        Datastore ds = Datastore.getDataStore(this.myDbName);
        T[] result = null;
        try {
            result = ds.executeQuery(this.myQuery, this.myLoaderResultType);
        }
        catch (DatabaseException e) {
            throw new RuntimeException("An error occured in the loader while trying to get data from the database", e);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The class type passed into the loader does not match the generic type of the loader. [" + e + "]");
        }
        this.myCancellationSignal = null;
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLoadInBackground() {
        super.cancelLoadInBackground();
        DbDataLoader dbDataLoader = this;
        synchronized (dbDataLoader) {
            if (this.myCancellationSignal != null) {
                this.myCancellationSignal.cancel();
            }
        }
    }

    public void deliverResult(T result) {
        if (this.isReset()) {
            this.myResult = null;
            return;
        }
        this.myResult = result;
        if (this.isStarted()) {
            super.deliverResult(result);
        }
    }

    public void ignoreUpdates() {
        this.myIsIgnoringUpdates = true;
        this.unregisterContentObservers();
    }

    public void receiveUpdates() {
        this.myIsIgnoringUpdates = false;
        if (this.isStarted()) {
            ContentResolver cr = this.getContext().getContentResolver();
            for (Map.Entry<Uri, Loader.ForceLoadContentObserver> entry : this.myObservers.entrySet()) {
                cr.registerContentObserver(entry.getKey(), false, (ContentObserver)entry.getValue());
            }
        }
    }

    public void addWatchUri(@Nullable Uri uri) {
        if (uri != null && !this.myObservers.containsKey(uri)) {
            Loader.ForceLoadContentObserver observer = new Loader.ForceLoadContentObserver((Loader)this);
            this.myObservers.put(uri, observer);
            if (this.isStarted()) {
                ContentResolver cr = this.getContext().getContentResolver();
                cr.registerContentObserver(uri, false, (ContentObserver)observer);
            }
        }
    }

    public void removeWatchUri(Uri uri) {
        if (this.myObservers.containsKey(uri)) {
            if (this.isStarted()) {
                ContentResolver cr = this.getContext().getContentResolver();
                cr.unregisterContentObserver((ContentObserver)this.myObservers.get(uri));
            }
            this.myObservers.remove(uri);
        }
    }

    protected void onStartLoading() {
        if (!this.myIsIgnoringUpdates) {
            this.receiveUpdates();
        }
        Datastore ds = Datastore.getDataStore(this.myDbName);
        Calendar tableUpdateTime = ds.getLastTableUpdateTime(this.myQuery.getTable());
        if (this.takeContentChanged() || this.myResult == null || tableUpdateTime != this.myTableUpdateTime || this.myResult != null && tableUpdateTime != null && tableUpdateTime.compareTo(this.myTableUpdateTime) > 0) {
            this.myTableUpdateTime = tableUpdateTime;
            this.forceLoad();
            return;
        }
        if (this.myResult != null) {
            this.deliverResult(this.myResult);
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
        this.unregisterContentObservers();
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
    }

    private void unregisterContentObservers() {
        ContentResolver cr = this.getContext().getContentResolver();
        for (Loader.ForceLoadContentObserver observer : this.myObservers.values()) {
            cr.unregisterContentObserver((ContentObserver)observer);
        }
    }
}

