/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.content.Context;
import android.database.ContentObserver;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.support.v4.os.CancellationSignal;
import android.support.v4.os.OperationCanceledException;
import android.text.TextUtils;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;

public class DbDataLoader<T>
extends AsyncTaskLoader<T> {
    private CancellationSignal myCancellationSignal;
    private final Loader.ForceLoadContentObserver myObserver = new Loader.ForceLoadContentObserver((Loader)this);
    private T myResult;
    private final String myDbName;
    private final Query myQuery;
    private final Class myLoaderResultType;

    public DbDataLoader(Context context, String dbName, Query query, Class loaderResultType) {
        super(context);
        this.myDbName = dbName;
        this.myQuery = query;
        this.myLoaderResultType = loaderResultType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T loadInBackground() {
        DbDataLoader dbDataLoader = this;
        synchronized (dbDataLoader) {
            if (this.isLoadInBackgroundCanceled()) {
                throw new OperationCanceledException();
            }
            this.myCancellationSignal = new CancellationSignal();
        }
        Datastore ds = Datastore.getDataStore(this.myDbName);
        T[] result = null;
        try {
            result = ds.executeQuery(this.myQuery, this.myLoaderResultType);
        }
        catch (DatabaseException e) {
            throw new RuntimeException("An error occured in the loader while trying to get data from the database", e);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The class type passed into the loader does not match the generic type of the loader. [" + e + "]");
        }
        this.myCancellationSignal = null;
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLoadInBackground() {
        super.cancelLoadInBackground();
        DbDataLoader dbDataLoader = this;
        synchronized (dbDataLoader) {
            if (this.myCancellationSignal != null) {
                this.myCancellationSignal.cancel();
            }
        }
    }

    public void deliverResult(T result) {
        if (this.isReset()) {
            this.myResult = null;
            return;
        }
        this.myResult = result;
        if (this.isStarted()) {
            super.deliverResult(result);
        }
    }

    protected void onStartLoading() {
        Datastore ds = Datastore.getDataStore(this.myDbName);
        if (!TextUtils.isEmpty((CharSequence)ds.getTableUri(this.myQuery.getTable()).toString())) {
            this.getContext().getContentResolver().registerContentObserver(ds.getTableUri(this.myQuery.getTable()), false, (ContentObserver)this.myObserver);
        }
        if (this.myResult != null) {
            this.deliverResult(this.myResult);
        }
        if (this.takeContentChanged() || this.myResult == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
        this.getContext().getContentResolver().unregisterContentObserver((ContentObserver)this.myObserver);
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
    }
}

