/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.Nullable;
import com.stonecraft.datastore.DatabaseUtils;
import com.stonecraft.datastore.DbColumnName;
import com.stonecraft.datastore.DbTableName;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DatabaseObjectInjector {
    private boolean myIsJoinedQuery;
    private Map<String, Field[]> myClassFields;
    private Map<Field, Annotation> myAnnotations;

    public DatabaseObjectInjector(Query query) {
        this.myIsJoinedQuery = query.getJoins().isEmpty();
        this.myClassFields = new HashMap<String, Field[]>();
        this.myAnnotations = new HashMap<Field, Annotation>();
    }

    public <T> T[] inject(RSData data, Class<T> classOfT) throws DatabaseException {
        Object[] returnClasses = (Object[])Array.newInstance(classOfT, data.getCount());
        data.moveToFirst();
        int count = 0;
        while (!data.isAfterLast()) {
            Object injectedRow = null;
            injectedRow = this.getInjectedClass(data, classOfT);
            if (injectedRow != null) {
                returnClasses[count] = injectedRow;
            }
            data.next();
            ++count;
        }
        return returnClasses;
    }

    private <T> T getInjectedClass(RSData data, Class<T> classOfT, @Nullable String tableName) throws DatabaseException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        try {
            Field[] fields = null;
            if (this.myClassFields.containsKey(classOfT.getName())) {
                fields = this.myClassFields.get(classOfT.getName());
            } else {
                fields = classOfT.getDeclaredFields();
                this.myClassFields.put(classOfT.getName(), fields);
            }
            T rowClass = classOfT.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : fields) {
                Annotation annotation = this.getAnnotation(field);
                if (annotation instanceof DbTableName) {
                    field.setAccessible(true);
                    field.set(rowClass, this.getInjectedClass(data, field.getType(), ((DbTableName)annotation).value()));
                    continue;
                }
                if (!(annotation instanceof DbColumnName)) continue;
                DbColumnName InjectAnnotation = (DbColumnName)annotation;
                String column = this.getColumnKey(tableName, InjectAnnotation.value());
                this.injectValue(data, rowClass, field, column);
            }
            return rowClass;
        }
        catch (Throwable e) {
            throw new DatabaseException("Failed to create an instance of the class to be injected with the data for this query", e);
        }
    }

    private Annotation getAnnotation(Field field) {
        if (this.myAnnotations.containsKey(field)) {
            return this.myAnnotations.get(field);
        }
        Annotation annotation = field.getAnnotation(DbTableName.class);
        if (annotation != null) {
            this.myAnnotations.put(field, annotation);
            return annotation;
        }
        annotation = field.getAnnotation(DbColumnName.class);
        this.myAnnotations.put(field, annotation);
        return annotation;
    }

    private <T> T getInjectedClass(RSData data, Class<T> classOfT) throws DatabaseException {
        try {
            return this.getInjectedClass(data, classOfT, null);
        }
        catch (Throwable e) {
            throw new DatabaseException("Failed to create an instance of the class to be injected with the data for this query", e);
        }
    }

    private String getColumnKey(String table, String column) {
        String columnKey = null;
        columnKey = column.contains(DatabaseUtils.getTableColumnSeparator()) ? DatabaseUtils.normaliseTableColumnAsName(column) : (this.myIsJoinedQuery ? column : DatabaseUtils.getDatabaseAsName(table, column));
        return columnKey;
    }

    private <T> void injectValue(RSData data, T rowClass, Field field, String column) throws IllegalAccessException, DatabaseException {
        field.setAccessible(true);
        Class<?> fieldType = field.getType();
        if (data.hasColumn(column)) {
            if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                field.set(rowClass, data.getIntValue(column));
            } else if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                field.set(rowClass, data.getBooleanValue(column));
            } else if (fieldType == Double.TYPE || fieldType == Double.class) {
                field.set(rowClass, data.getDoubleValue(column));
            } else if (fieldType == Float.TYPE || fieldType == Float.class) {
                field.set(rowClass, Float.valueOf(data.getFloatValue(column)));
            } else if (fieldType == String.class) {
                field.set(rowClass, data.getStringValue(column));
            } else if (fieldType == Calendar.class) {
                field.set(rowClass, data.getCalendarValue(column));
            } else if (fieldType == Date.class) {
                field.set(rowClass, data.getDateValue(column));
            } else if (fieldType == Byte[].class) {
                field.set(rowClass, data.getBlobData(column));
            } else if (fieldType == Bitmap.class) {
                byte[] bmpData = data.getBlobData(column);
                Bitmap bmp = BitmapFactory.decodeByteArray((byte[])bmpData, (int)0, (int)bmpData.length);
                field.set(rowClass, bmp);
            }
        }
    }
}

