/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.view;

import com.stonecraft.datastore.exceptions.DatabaseException;

public abstract class DatabaseColumn {
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String NOT_NULL = "NOT NULL";
    public static final String DEFAULT = "DEFAULT";
    public static final String AUTO_INCREMENT = "AUTOINCREMENT";
    private String myName;
    private int myType;
    private boolean myIsPrimarykey;
    private boolean myIsAutoIncrement;
    private boolean myIsNullable;
    private int myLength;
    private String myDefaultValue;

    public DatabaseColumn(String name, int type, int length) {
        this(name, type, length, false);
    }

    public DatabaseColumn(String name, int type, int length, boolean isPrimaryKey) {
        this(name, type, length, isPrimaryKey, false);
    }

    public DatabaseColumn(String name, int type, int length, boolean isPrimaryKey, boolean isNullable) {
        this(name, type, length, isPrimaryKey, isNullable, false);
    }

    public DatabaseColumn(String name, int type, int length, boolean isPrimaryKey, boolean isNullable, boolean isAutoIncrement) {
        this.myName = name;
        this.myType = type;
        this.myIsPrimarykey = isPrimaryKey;
        this.myIsAutoIncrement = isAutoIncrement;
        this.myLength = length;
        this.myIsNullable = isPrimaryKey ? false : isNullable;
    }

    public String getName() {
        return this.myName;
    }

    public int getType() {
        return this.myType;
    }

    public boolean isPrimarykey() {
        return this.myIsPrimarykey;
    }

    public boolean isAutoIncrement() {
        return this.myIsAutoIncrement;
    }

    public boolean isNullable() {
        return this.myIsNullable;
    }

    public int getLength() {
        return this.myLength;
    }

    public void setLength(int length) {
        this.myLength = length;
    }

    public boolean equals(Object o) {
        DatabaseColumn compareCol = (DatabaseColumn)o;
        return this.myName.equals(compareCol.myName) && this.myType == compareCol.myType && this.myLength == compareCol.myLength && this.myIsAutoIncrement == compareCol.myIsAutoIncrement && this.myIsNullable == compareCol.myIsNullable && this.myIsPrimarykey == compareCol.myIsPrimarykey;
    }

    public void setDefaultValue(String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public abstract String getCreateColumnStmt(boolean var1) throws DatabaseException;

    protected abstract String getTypeString() throws DatabaseException;
}

