/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Delete;
import com.stonecraft.datastore.interaction.Insert;
import com.stonecraft.datastore.interaction.Statement;
import com.stonecraft.datastore.interaction.Update;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.OnNonQueryComplete;
import java.util.ArrayList;
import java.util.List;

class DatabaseNonQueryTask
extends DatabaseTask {
    private Statement myStatement;
    private List<OnNonQueryComplete> myStmtListeners;
    private int myResult;

    public DatabaseNonQueryTask(int taskId, int token, IDBConnector conn, Statement stmt) {
        super(taskId, token, conn);
        this.myStatement = stmt;
        this.myStmtListeners = new ArrayList<OnNonQueryComplete>();
        this.myResult = -1;
    }

    @Override
    public void executeTask() throws DatabaseException {
        try {
            if (this.myStatement instanceof Insert) {
                this.myConnection.insert((Insert)this.myStatement);
                this.myResult = 1;
            } else {
                this.myResult = this.myStatement instanceof Update ? this.myConnection.update((Update)this.myStatement) : (this.myStatement instanceof Delete ? this.myConnection.delete((Delete)this.myStatement) : this.myConnection.doesTableExist(this.myStatement.getTable()));
            }
            this.notifyStmtListeners(null);
        }
        catch (DatabaseException e) {
            this.notifyStmtListeners(e);
            throw e;
        }
        finally {
            this.notifyTaskListeners();
        }
    }

    public void addOnStmtCompleteListener(OnNonQueryComplete listener) {
        if (listener != null) {
            this.myStmtListeners.add(listener);
        }
    }

    public int getTaskResult() {
        return this.myResult;
    }

    void notifyStmtListeners(DatabaseException e) {
        for (OnNonQueryComplete listener : this.myStmtListeners) {
            if (e != null) {
                listener.onNonQueryFailed(this.myToken, e);
                continue;
            }
            listener.onNonQueryComplete(this.myToken, this.myResult);
        }
    }
}

