/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.imageviewer.common.gestures.direction;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.stfalcon.imageviewer.common.gestures.direction.SwipeDirection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J(\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0019R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stfalcon/imageviewer/common/gestures/direction/SwipeDirectionDetector;", "", "context", "Landroid/content/Context;", "onDirectionDetected", "Lkotlin/Function1;", "Lcom/stfalcon/imageviewer/common/gestures/direction/SwipeDirection;", "", "(Landroid/content/Context;Lkotlin/jvm/functions/Function1;)V", "isDetected", "", "startX", "", "startY", "touchSlop", "", "getAngle", "", "x1", "y1", "x2", "y2", "getDirection", "getEventDistance", "ev", "Landroid/view/MotionEvent;", "handleTouchEvent", "event", "imageviewer_release"})
public final class SwipeDirectionDetector {
    private final int touchSlop;
    private float startX;
    private float startY;
    private boolean isDetected;
    private final Function1<SwipeDirection, Unit> onDirectionDetected;

    public final void handleTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: {
                this.startX = event.getX();
                this.startY = event.getY();
                break;
            }
            case 1: 
            case 3: {
                if (!this.isDetected) {
                    this.onDirectionDetected.invoke((Object)SwipeDirection.NOT_DETECTED);
                }
                this.startX = this.startY = 0.0f;
                this.isDetected = false;
                break;
            }
            case 2: {
                if (this.isDetected || !(this.getEventDistance(event) > (float)this.touchSlop)) break;
                this.isDetected = true;
                this.onDirectionDetected.invoke((Object)this.getDirection(this.startX, this.startY, event.getX(), event.getY()));
            }
        }
    }

    private final SwipeDirection getDirection(float x1, float y1, float x2, float y2) {
        double angle = this.getAngle(x1, y1, x2, y2);
        return SwipeDirection.Companion.fromAngle(angle);
    }

    private final double getAngle(float x1, float y1, float x2, float y2) {
        double rad = Math.atan2(y1 - y2, x2 - x1) + Math.PI;
        return (rad * (double)180 / Math.PI + (double)180) % (double)360;
    }

    private final float getEventDistance(MotionEvent ev) {
        float dx = ev.getX(0) - this.startX;
        float dy = ev.getY(0) - this.startY;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public SwipeDirectionDetector(@NotNull Context context, @NotNull Function1<? super SwipeDirection, Unit> onDirectionDetected) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(onDirectionDetected, (String)"onDirectionDetected");
        this.onDirectionDetected = onDirectionDetected;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.touchSlop = viewConfiguration.getScaledTouchSlop();
    }
}

