/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.frescoimageviewer;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import com.stfalcon.frescoimageviewer.OnDismissListener;

class SwipeToDismissListener
implements View.OnTouchListener {
    private static final String PROPERTY_TRANSLATION_X = "translationY";
    private final View swipeView;
    private int translationLimit;
    private OnDismissListener dismissListener;
    private OnViewMoveListener moveListener;
    private boolean tracking = false;
    private float startY;

    public SwipeToDismissListener(View swipeView, OnDismissListener dismissListener, OnViewMoveListener moveListener) {
        this.swipeView = swipeView;
        this.dismissListener = dismissListener;
        this.moveListener = moveListener;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.translationLimit = v.getHeight() / 4;
        switch (event.getAction()) {
            case 0: {
                Rect hitRect = new Rect();
                this.swipeView.getHitRect(hitRect);
                if (hitRect.contains((int)event.getX(), (int)event.getY())) {
                    this.tracking = true;
                }
                this.startY = event.getY();
                return true;
            }
            case 1: 
            case 3: {
                if (this.tracking) {
                    this.tracking = false;
                    this.animateSwipeView(v.getHeight());
                }
                return true;
            }
            case 2: {
                if (this.tracking) {
                    float translationY = event.getY() - this.startY;
                    this.swipeView.setTranslationY(translationY);
                    this.callMoveListener(translationY, this.translationLimit);
                }
                return true;
            }
        }
        return false;
    }

    private void animateSwipeView(int parentHeight) {
        float currentPosition = this.swipeView.getTranslationY();
        float animateTo = 0.0f;
        if (currentPosition < (float)(-this.translationLimit)) {
            animateTo = -parentHeight;
        } else if (currentPosition > (float)this.translationLimit) {
            animateTo = parentHeight;
        }
        final boolean isDismissed = animateTo != 0.0f;
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)this.swipeView, (String)PROPERTY_TRANSLATION_X, (float[])new float[]{currentPosition, animateTo});
        animator.setDuration(200L);
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (isDismissed) {
                    SwipeToDismissListener.this.callDismissListener();
                }
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SwipeToDismissListener.this.callMoveListener(((Float)animation.getAnimatedValue()).floatValue(), SwipeToDismissListener.this.translationLimit);
            }
        });
        animator.start();
    }

    private void callDismissListener() {
        if (this.dismissListener != null) {
            this.dismissListener.onDismiss();
        }
    }

    private void callMoveListener(float translationY, int translationLimit) {
        if (this.moveListener != null) {
            this.moveListener.onViewMove(translationY, translationLimit);
        }
    }

    static interface OnViewMoveListener {
        public void onViewMove(float var1, int var2);
    }
}

