/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.chatkit.messages;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;

class RecyclerScrollMoreListener
extends RecyclerView.OnScrollListener {
    private OnLoadMoreListener loadMoreListener;
    private int currentPage = 0;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private RecyclerView.LayoutManager mLayoutManager;

    RecyclerScrollMoreListener(LinearLayoutManager layoutManager, OnLoadMoreListener loadMoreListener) {
        this.mLayoutManager = layoutManager;
        this.loadMoreListener = loadMoreListener;
    }

    private int getLastVisibleItem(int[] lastVisibleItemPositions) {
        int maxSize = 0;
        for (int i = 0; i < lastVisibleItemPositions.length; ++i) {
            if (i == 0) {
                maxSize = lastVisibleItemPositions[i];
                continue;
            }
            if (lastVisibleItemPositions[i] <= maxSize) continue;
            maxSize = lastVisibleItemPositions[i];
        }
        return maxSize;
    }

    public void onScrolled(RecyclerView view, int dx, int dy) {
        if (this.loadMoreListener != null) {
            int lastVisibleItemPosition = 0;
            int totalItemCount = this.mLayoutManager.getItemCount();
            if (this.mLayoutManager instanceof StaggeredGridLayoutManager) {
                int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)this.mLayoutManager).findLastVisibleItemPositions(null);
                lastVisibleItemPosition = this.getLastVisibleItem(lastVisibleItemPositions);
            } else if (this.mLayoutManager instanceof LinearLayoutManager) {
                lastVisibleItemPosition = ((LinearLayoutManager)this.mLayoutManager).findLastVisibleItemPosition();
            } else if (this.mLayoutManager instanceof GridLayoutManager) {
                lastVisibleItemPosition = ((GridLayoutManager)this.mLayoutManager).findLastVisibleItemPosition();
            }
            if (totalItemCount < this.previousTotalItemCount) {
                this.currentPage = 0;
                this.previousTotalItemCount = totalItemCount;
                if (totalItemCount == 0) {
                    this.loading = true;
                }
            }
            if (this.loading && totalItemCount > this.previousTotalItemCount) {
                this.loading = false;
                this.previousTotalItemCount = totalItemCount;
            }
            int visibleThreshold = 5;
            if (!this.loading && lastVisibleItemPosition + visibleThreshold > totalItemCount) {
                ++this.currentPage;
                this.loadMoreListener.onLoadMore(this.loadMoreListener.getMessagesCount(), totalItemCount);
                this.loading = true;
            }
        }
    }

    static interface OnLoadMoreListener {
        public void onLoadMore(int var1, int var2);

        public int getMessagesCount();
    }
}

