/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.chatkit.messages;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import com.stfalcon.chatkit.R;
import com.stfalcon.chatkit.commons.Style;

class MessageInputStyle
extends Style {
    private static final int DEFAULT_MAX_LINES = 5;
    private static final int DEFAULT_DELAY_TYPING_STATUS = 1500;
    private boolean showAttachmentButton;
    private int attachmentButtonBackground;
    private int attachmentButtonDefaultBgColor;
    private int attachmentButtonDefaultBgPressedColor;
    private int attachmentButtonDefaultBgDisabledColor;
    private int attachmentButtonIcon;
    private int attachmentButtonDefaultIconColor;
    private int attachmentButtonDefaultIconPressedColor;
    private int attachmentButtonDefaultIconDisabledColor;
    private int attachmentButtonWidth;
    private int attachmentButtonHeight;
    private int attachmentButtonMargin;
    private int inputButtonBackground;
    private int inputButtonDefaultBgColor;
    private int inputButtonDefaultBgPressedColor;
    private int inputButtonDefaultBgDisabledColor;
    private int inputButtonIcon;
    private int inputButtonDefaultIconColor;
    private int inputButtonDefaultIconPressedColor;
    private int inputButtonDefaultIconDisabledColor;
    private int inputButtonWidth;
    private int inputButtonHeight;
    private int inputButtonMargin;
    private int inputMaxLines;
    private String inputHint;
    private String inputText;
    private int inputTextSize;
    private int inputTextColor;
    private int inputHintColor;
    private Drawable inputBackground;
    private Drawable inputCursorDrawable;
    private int inputDefaultPaddingLeft;
    private int inputDefaultPaddingRight;
    private int inputDefaultPaddingTop;
    private int inputDefaultPaddingBottom;
    private int delayTypingStatus;

    static MessageInputStyle parse(Context context, AttributeSet attrs) {
        MessageInputStyle style = new MessageInputStyle(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MessageInput);
        style.showAttachmentButton = typedArray.getBoolean(R.styleable.MessageInput_showAttachmentButton, false);
        style.attachmentButtonBackground = typedArray.getResourceId(R.styleable.MessageInput_attachmentButtonBackground, -1);
        style.attachmentButtonDefaultBgColor = typedArray.getColor(R.styleable.MessageInput_attachmentButtonDefaultBgColor, style.getColor(R.color.white_four));
        style.attachmentButtonDefaultBgPressedColor = typedArray.getColor(R.styleable.MessageInput_attachmentButtonDefaultBgPressedColor, style.getColor(R.color.white_five));
        style.attachmentButtonDefaultBgDisabledColor = typedArray.getColor(R.styleable.MessageInput_attachmentButtonDefaultBgDisabledColor, style.getColor(R.color.transparent));
        style.attachmentButtonIcon = typedArray.getResourceId(R.styleable.MessageInput_attachmentButtonIcon, -1);
        style.attachmentButtonDefaultIconColor = typedArray.getColor(R.styleable.MessageInput_attachmentButtonDefaultIconColor, style.getColor(R.color.cornflower_blue_two));
        style.attachmentButtonDefaultIconPressedColor = typedArray.getColor(R.styleable.MessageInput_attachmentButtonDefaultIconPressedColor, style.getColor(R.color.cornflower_blue_two_dark));
        style.attachmentButtonDefaultIconDisabledColor = typedArray.getColor(R.styleable.MessageInput_attachmentButtonDefaultIconDisabledColor, style.getColor(R.color.cornflower_blue_light_40));
        style.attachmentButtonWidth = typedArray.getDimensionPixelSize(R.styleable.MessageInput_attachmentButtonWidth, style.getDimension(R.dimen.input_button_width));
        style.attachmentButtonHeight = typedArray.getDimensionPixelSize(R.styleable.MessageInput_attachmentButtonHeight, style.getDimension(R.dimen.input_button_height));
        style.attachmentButtonMargin = typedArray.getDimensionPixelSize(R.styleable.MessageInput_attachmentButtonMargin, style.getDimension(R.dimen.input_button_margin));
        style.inputButtonBackground = typedArray.getResourceId(R.styleable.MessageInput_inputButtonBackground, -1);
        style.inputButtonDefaultBgColor = typedArray.getColor(R.styleable.MessageInput_inputButtonDefaultBgColor, style.getColor(R.color.cornflower_blue_two));
        style.inputButtonDefaultBgPressedColor = typedArray.getColor(R.styleable.MessageInput_inputButtonDefaultBgPressedColor, style.getColor(R.color.cornflower_blue_two_dark));
        style.inputButtonDefaultBgDisabledColor = typedArray.getColor(R.styleable.MessageInput_inputButtonDefaultBgDisabledColor, style.getColor(R.color.white_four));
        style.inputButtonIcon = typedArray.getResourceId(R.styleable.MessageInput_inputButtonIcon, -1);
        style.inputButtonDefaultIconColor = typedArray.getColor(R.styleable.MessageInput_inputButtonDefaultIconColor, style.getColor(R.color.white));
        style.inputButtonDefaultIconPressedColor = typedArray.getColor(R.styleable.MessageInput_inputButtonDefaultIconPressedColor, style.getColor(R.color.white));
        style.inputButtonDefaultIconDisabledColor = typedArray.getColor(R.styleable.MessageInput_inputButtonDefaultIconDisabledColor, style.getColor(R.color.warm_grey));
        style.inputButtonWidth = typedArray.getDimensionPixelSize(R.styleable.MessageInput_inputButtonWidth, style.getDimension(R.dimen.input_button_width));
        style.inputButtonHeight = typedArray.getDimensionPixelSize(R.styleable.MessageInput_inputButtonHeight, style.getDimension(R.dimen.input_button_height));
        style.inputButtonMargin = typedArray.getDimensionPixelSize(R.styleable.MessageInput_inputButtonMargin, style.getDimension(R.dimen.input_button_margin));
        style.inputMaxLines = typedArray.getInt(R.styleable.MessageInput_inputMaxLines, 5);
        style.inputHint = typedArray.getString(R.styleable.MessageInput_inputHint);
        style.inputText = typedArray.getString(R.styleable.MessageInput_inputText);
        style.inputTextSize = typedArray.getDimensionPixelSize(R.styleable.MessageInput_inputTextSize, style.getDimension(R.dimen.input_text_size));
        style.inputTextColor = typedArray.getColor(R.styleable.MessageInput_inputTextColor, style.getColor(R.color.dark_grey_two));
        style.inputHintColor = typedArray.getColor(R.styleable.MessageInput_inputHintColor, style.getColor(R.color.warm_grey_three));
        style.inputBackground = typedArray.getDrawable(R.styleable.MessageInput_inputBackground);
        style.inputCursorDrawable = typedArray.getDrawable(R.styleable.MessageInput_inputCursorDrawable);
        style.delayTypingStatus = typedArray.getInt(R.styleable.MessageInput_delayTypingStatus, 1500);
        typedArray.recycle();
        style.inputDefaultPaddingLeft = style.getDimension(R.dimen.input_padding_left);
        style.inputDefaultPaddingRight = style.getDimension(R.dimen.input_padding_right);
        style.inputDefaultPaddingTop = style.getDimension(R.dimen.input_padding_top);
        style.inputDefaultPaddingBottom = style.getDimension(R.dimen.input_padding_bottom);
        return style;
    }

    private MessageInputStyle(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private Drawable getSelector(@ColorInt int normalColor, @ColorInt int pressedColor, @ColorInt int disabledColor, @DrawableRes int shape) {
        Drawable drawable2 = DrawableCompat.wrap((Drawable)this.getVectorDrawable(shape)).mutate();
        DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)new ColorStateList((int[][])new int[][]{{16842910, -16842919}, {16842910, 16842919}, {-16842910}}, new int[]{normalColor, pressedColor, disabledColor}));
        return drawable2;
    }

    protected boolean showAttachmentButton() {
        return this.showAttachmentButton;
    }

    protected Drawable getAttachmentButtonBackground() {
        if (this.attachmentButtonBackground == -1) {
            return this.getSelector(this.attachmentButtonDefaultBgColor, this.attachmentButtonDefaultBgPressedColor, this.attachmentButtonDefaultBgDisabledColor, R.drawable.mask);
        }
        return this.getDrawable(this.attachmentButtonBackground);
    }

    protected Drawable getAttachmentButtonIcon() {
        if (this.attachmentButtonIcon == -1) {
            return this.getSelector(this.attachmentButtonDefaultIconColor, this.attachmentButtonDefaultIconPressedColor, this.attachmentButtonDefaultIconDisabledColor, R.drawable.ic_add_attachment);
        }
        return this.getDrawable(this.attachmentButtonIcon);
    }

    protected int getAttachmentButtonWidth() {
        return this.attachmentButtonWidth;
    }

    protected int getAttachmentButtonHeight() {
        return this.attachmentButtonHeight;
    }

    protected int getAttachmentButtonMargin() {
        return this.attachmentButtonMargin;
    }

    protected Drawable getInputButtonBackground() {
        if (this.inputButtonBackground == -1) {
            return this.getSelector(this.inputButtonDefaultBgColor, this.inputButtonDefaultBgPressedColor, this.inputButtonDefaultBgDisabledColor, R.drawable.mask);
        }
        return this.getDrawable(this.inputButtonBackground);
    }

    protected Drawable getInputButtonIcon() {
        if (this.inputButtonIcon == -1) {
            return this.getSelector(this.inputButtonDefaultIconColor, this.inputButtonDefaultIconPressedColor, this.inputButtonDefaultIconDisabledColor, R.drawable.ic_send);
        }
        return this.getDrawable(this.inputButtonIcon);
    }

    protected int getInputButtonMargin() {
        return this.inputButtonMargin;
    }

    protected int getInputButtonWidth() {
        return this.inputButtonWidth;
    }

    protected int getInputButtonHeight() {
        return this.inputButtonHeight;
    }

    protected int getInputMaxLines() {
        return this.inputMaxLines;
    }

    protected String getInputHint() {
        return this.inputHint;
    }

    protected String getInputText() {
        return this.inputText;
    }

    protected int getInputTextSize() {
        return this.inputTextSize;
    }

    protected int getInputTextColor() {
        return this.inputTextColor;
    }

    protected int getInputHintColor() {
        return this.inputHintColor;
    }

    protected Drawable getInputBackground() {
        return this.inputBackground;
    }

    protected Drawable getInputCursorDrawable() {
        return this.inputCursorDrawable;
    }

    protected int getInputDefaultPaddingLeft() {
        return this.inputDefaultPaddingLeft;
    }

    protected int getInputDefaultPaddingRight() {
        return this.inputDefaultPaddingRight;
    }

    protected int getInputDefaultPaddingTop() {
        return this.inputDefaultPaddingTop;
    }

    protected int getInputDefaultPaddingBottom() {
        return this.inputDefaultPaddingBottom;
    }

    int getDelayTypingStatus() {
        return this.delayTypingStatus;
    }
}

