/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.chatkit.messages;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.stfalcon.chatkit.R;
import com.stfalcon.chatkit.commons.ImageLoader;
import com.stfalcon.chatkit.commons.ViewHolder;
import com.stfalcon.chatkit.commons.models.IMessage;
import com.stfalcon.chatkit.messages.MessageHolders;
import com.stfalcon.chatkit.messages.MessagesListStyle;
import com.stfalcon.chatkit.messages.RecyclerScrollMoreListener;
import com.stfalcon.chatkit.utils.DateFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class MessagesListAdapter<MESSAGE extends IMessage>
extends RecyclerView.Adapter<ViewHolder>
implements RecyclerScrollMoreListener.OnLoadMoreListener {
    private MessageHolders holders;
    private String senderId;
    private List<Wrapper> items;
    private int selectedItemsCount;
    private SelectionListener selectionListener;
    protected static boolean isSelectionModeEnabled;
    private OnLoadMoreListener loadMoreListener;
    private OnMessageClickListener<MESSAGE> onMessageClickListener;
    private OnMessageViewClickListener<MESSAGE> onMessageViewClickListener;
    private OnMessageLongClickListener<MESSAGE> onMessageLongClickListener;
    private OnMessageViewLongClickListener<MESSAGE> onMessageViewLongClickListener;
    private ImageLoader imageLoader;
    private RecyclerView.LayoutManager layoutManager;
    private MessagesListStyle messagesListStyle;
    private DateFormatter.Formatter dateHeadersFormatter;
    private SparseArray<OnMessageViewClickListener> viewClickListenersArray = new SparseArray();

    public MessagesListAdapter(String senderId, ImageLoader imageLoader) {
        this(senderId, new MessageHolders(), imageLoader);
    }

    public MessagesListAdapter(String senderId, MessageHolders holders, ImageLoader imageLoader) {
        this.senderId = senderId;
        this.holders = holders;
        this.imageLoader = imageLoader;
        this.items = new ArrayList<Wrapper>();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.holders.getHolder(parent, viewType, this.messagesListStyle);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        Wrapper wrapper = this.items.get(position);
        this.holders.bind(holder, wrapper.item, wrapper.isSelected, this.imageLoader, this.getMessageClickListener(wrapper), this.getMessageLongClickListener(wrapper), this.dateHeadersFormatter, this.viewClickListenersArray);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int position) {
        return this.holders.getViewType(this.items.get((int)position).item, this.senderId);
    }

    @Override
    public void onLoadMore(int page, int total) {
        if (this.loadMoreListener != null) {
            this.loadMoreListener.onLoadMore(page, total);
        }
    }

    public void addToStart(MESSAGE message, boolean scroll) {
        boolean isNewMessageToday;
        boolean bl = isNewMessageToday = !this.isPreviousSameDate(0, message.getCreatedAt());
        if (isNewMessageToday) {
            this.items.add(0, new Wrapper<Date>(message.getCreatedAt()));
        }
        Wrapper<MESSAGE> element = new Wrapper<MESSAGE>(message);
        this.items.add(0, element);
        this.notifyItemRangeInserted(0, isNewMessageToday ? 2 : 1);
        if (this.layoutManager != null && scroll) {
            this.layoutManager.scrollToPosition(0);
        }
    }

    public void addToEnd(List<MESSAGE> messages, boolean reverse) {
        if (messages.isEmpty()) {
            return;
        }
        if (reverse) {
            Collections.reverse(messages);
        }
        if (!this.items.isEmpty()) {
            int lastItemPosition = this.items.size() - 1;
            Date lastItem = (Date)this.items.get((int)lastItemPosition).item;
            if (DateFormatter.isSameDay(((IMessage)messages.get(0)).getCreatedAt(), lastItem)) {
                this.items.remove(lastItemPosition);
                this.notifyItemRemoved(lastItemPosition);
            }
        }
        int oldSize = this.items.size();
        this.generateDateHeaders(messages);
        this.notifyItemRangeInserted(oldSize, this.items.size() - oldSize);
    }

    public void update(MESSAGE message) {
        this.update(message.getId(), message);
    }

    public void update(String oldId, MESSAGE newMessage) {
        int position = this.getMessagePositionById(oldId);
        if (position >= 0) {
            Wrapper<MESSAGE> element = new Wrapper<MESSAGE>(newMessage);
            this.items.set(position, element);
            this.notifyItemChanged(position);
        }
    }

    public void delete(MESSAGE message) {
        this.deleteById(message.getId());
    }

    public void delete(List<MESSAGE> messages) {
        for (IMessage message : messages) {
            int index = this.getMessagePositionById(message.getId());
            this.items.remove(index);
            this.notifyItemRemoved(index);
        }
        this.recountDateHeaders();
    }

    public void deleteById(String id2) {
        int index = this.getMessagePositionById(id2);
        if (index >= 0) {
            this.items.remove(index);
            this.notifyItemRemoved(index);
            this.recountDateHeaders();
        }
    }

    public void deleteByIds(String[] ids) {
        for (String id2 : ids) {
            int index = this.getMessagePositionById(id2);
            this.items.remove(index);
            this.notifyItemRemoved(index);
        }
        this.recountDateHeaders();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void clear() {
        this.items.clear();
    }

    public void enableSelectionMode(SelectionListener selectionListener) {
        if (selectionListener == null) {
            throw new IllegalArgumentException("SelectionListener must not be null. Use `disableSelectionMode()` if you want tp disable selection mode");
        }
        this.selectionListener = selectionListener;
    }

    public void disableSelectionMode() {
        this.selectionListener = null;
        this.unselectAllItems();
    }

    public ArrayList<MESSAGE> getSelectedMessages() {
        ArrayList<IMessage> selectedMessages = new ArrayList<IMessage>();
        for (Wrapper wrapper : this.items) {
            if (!(wrapper.item instanceof IMessage) || !wrapper.isSelected) continue;
            selectedMessages.add((IMessage)wrapper.item);
        }
        return selectedMessages;
    }

    public String getSelectedMessagesText(Formatter<MESSAGE> formatter, boolean reverse) {
        String copiedText = this.getSelectedText(formatter, reverse);
        this.unselectAllItems();
        return copiedText;
    }

    public String copySelectedMessagesText(Context context, Formatter<MESSAGE> formatter, boolean reverse) {
        String copiedText = this.getSelectedText(formatter, reverse);
        this.copyToClipboard(context, copiedText);
        this.unselectAllItems();
        return copiedText;
    }

    public void unselectAllItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            Wrapper wrapper = this.items.get(i);
            if (!wrapper.isSelected) continue;
            wrapper.isSelected = false;
            this.notifyItemChanged(i);
        }
        isSelectionModeEnabled = false;
        this.selectedItemsCount = 0;
        this.notifySelectionChanged();
    }

    public void deleteSelectedMessages() {
        ArrayList<MESSAGE> selectedMessages = this.getSelectedMessages();
        this.delete((List<MESSAGE>)selectedMessages);
        this.unselectAllItems();
    }

    public void setOnMessageClickListener(OnMessageClickListener<MESSAGE> onMessageClickListener) {
        this.onMessageClickListener = onMessageClickListener;
    }

    public void setOnMessageViewClickListener(OnMessageViewClickListener<MESSAGE> onMessageViewClickListener) {
        this.onMessageViewClickListener = onMessageViewClickListener;
    }

    public void registerViewClickListener(int viewId, OnMessageViewClickListener<MESSAGE> onMessageViewClickListener) {
        this.viewClickListenersArray.append(viewId, onMessageViewClickListener);
    }

    public void setOnMessageLongClickListener(OnMessageLongClickListener<MESSAGE> onMessageLongClickListener) {
        this.onMessageLongClickListener = onMessageLongClickListener;
    }

    public void setOnMessageViewLongClickListener(OnMessageViewLongClickListener<MESSAGE> onMessageViewLongClickListener) {
        this.onMessageViewLongClickListener = onMessageViewLongClickListener;
    }

    public void setLoadMoreListener(OnLoadMoreListener loadMoreListener) {
        this.loadMoreListener = loadMoreListener;
    }

    public void setDateHeadersFormatter(DateFormatter.Formatter dateHeadersFormatter) {
        this.dateHeadersFormatter = dateHeadersFormatter;
    }

    private void recountDateHeaders() {
        ArrayList<Integer> indicesToDelete = new ArrayList<Integer>();
        for (int i = 0; i < this.items.size(); ++i) {
            Wrapper wrapper = this.items.get(i);
            if (!(wrapper.item instanceof Date)) continue;
            if (i == 0) {
                indicesToDelete.add(i);
                continue;
            }
            if (!(this.items.get((int)(i - 1)).item instanceof Date)) continue;
            indicesToDelete.add(i);
        }
        Collections.reverse(indicesToDelete);
        Iterator iterator = indicesToDelete.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.items.remove(i);
            this.notifyItemRemoved(i);
        }
    }

    private void generateDateHeaders(List<MESSAGE> messages) {
        for (int i = 0; i < messages.size(); ++i) {
            IMessage message = (IMessage)messages.get(i);
            this.items.add(new Wrapper<IMessage>(message));
            if (messages.size() > i + 1) {
                IMessage nextMessage = (IMessage)messages.get(i + 1);
                if (DateFormatter.isSameDay(message.getCreatedAt(), nextMessage.getCreatedAt())) continue;
                this.items.add(new Wrapper<Date>(message.getCreatedAt()));
                continue;
            }
            this.items.add(new Wrapper<Date>(message.getCreatedAt()));
        }
    }

    private int getMessagePositionById(String id2) {
        for (int i = 0; i < this.items.size(); ++i) {
            IMessage message;
            Wrapper wrapper = this.items.get(i);
            if (!(wrapper.item instanceof IMessage) || !(message = (IMessage)wrapper.item).getId().contentEquals(id2)) continue;
            return i;
        }
        return -1;
    }

    private boolean isPreviousSameDate(int position, Date dateToCompare) {
        if (this.items.size() <= position) {
            return false;
        }
        if (this.items.get((int)position).item instanceof IMessage) {
            Date previousPositionDate = ((IMessage)this.items.get((int)position).item).getCreatedAt();
            return DateFormatter.isSameDay(dateToCompare, previousPositionDate);
        }
        return false;
    }

    private boolean isPreviousSameAuthor(String id2, int position) {
        int prevPosition = position + 1;
        if (this.items.size() <= prevPosition) {
            return false;
        }
        return this.items.get((int)prevPosition).item instanceof IMessage && ((IMessage)this.items.get((int)prevPosition).item).getUser().getId().contentEquals(id2);
    }

    private void incrementSelectedItemsCount() {
        ++this.selectedItemsCount;
        this.notifySelectionChanged();
    }

    private void decrementSelectedItemsCount() {
        --this.selectedItemsCount;
        isSelectionModeEnabled = this.selectedItemsCount > 0;
        this.notifySelectionChanged();
    }

    private void notifySelectionChanged() {
        if (this.selectionListener != null) {
            this.selectionListener.onSelectionChanged(this.selectedItemsCount);
        }
    }

    private void notifyMessageClicked(MESSAGE message) {
        if (this.onMessageClickListener != null) {
            this.onMessageClickListener.onMessageClick(message);
        }
    }

    private void notifyMessageViewClicked(View view, MESSAGE message) {
        if (this.onMessageViewClickListener != null) {
            this.onMessageViewClickListener.onMessageViewClick(view, message);
        }
    }

    private void notifyMessageLongClicked(MESSAGE message) {
        if (this.onMessageLongClickListener != null) {
            this.onMessageLongClickListener.onMessageLongClick(message);
        }
    }

    private void notifyMessageViewLongClicked(View view, MESSAGE message) {
        if (this.onMessageViewLongClickListener != null) {
            this.onMessageViewLongClickListener.onMessageViewLongClick(view, message);
        }
    }

    private View.OnClickListener getMessageClickListener(final Wrapper<MESSAGE> wrapper) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (MessagesListAdapter.this.selectionListener != null && isSelectionModeEnabled) {
                    boolean bl = wrapper.isSelected = !wrapper.isSelected;
                    if (wrapper.isSelected) {
                        MessagesListAdapter.this.incrementSelectedItemsCount();
                    } else {
                        MessagesListAdapter.this.decrementSelectedItemsCount();
                    }
                    IMessage message = (IMessage)wrapper.item;
                    MessagesListAdapter.this.notifyItemChanged(MessagesListAdapter.this.getMessagePositionById(message.getId()));
                } else {
                    MessagesListAdapter.this.notifyMessageClicked((IMessage)wrapper.item);
                    MessagesListAdapter.this.notifyMessageViewClicked(view, (IMessage)wrapper.item);
                }
            }
        };
    }

    private View.OnLongClickListener getMessageLongClickListener(final Wrapper<MESSAGE> wrapper) {
        return new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (MessagesListAdapter.this.selectionListener == null) {
                    MessagesListAdapter.this.notifyMessageLongClicked((IMessage)wrapper.item);
                    MessagesListAdapter.this.notifyMessageViewLongClicked(view, (IMessage)wrapper.item);
                    return true;
                }
                isSelectionModeEnabled = true;
                view.performClick();
                return true;
            }
        };
    }

    private String getSelectedText(Formatter<MESSAGE> formatter, boolean reverse) {
        StringBuilder builder = new StringBuilder();
        ArrayList<MESSAGE> selectedMessages = this.getSelectedMessages();
        if (reverse) {
            Collections.reverse(selectedMessages);
        }
        for (IMessage message : selectedMessages) {
            builder.append(formatter == null ? message.toString() : formatter.format(message));
            builder.append("\n\n");
        }
        builder.replace(builder.length() - 2, builder.length(), "");
        return builder.toString();
    }

    private void copyToClipboard(Context context, String copiedText) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)copiedText, (CharSequence)copiedText);
        clipboard.setPrimaryClip(clip);
    }

    void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    void setStyle(MessagesListStyle style) {
        this.messagesListStyle = style;
    }

    @Deprecated
    public static class OutcomingMessageViewHolder<MESSAGE extends IMessage>
    extends MessageHolders.OutcomingTextMessageViewHolder<MESSAGE> {
        public OutcomingMessageViewHolder(View itemView) {
            super(itemView);
        }
    }

    @Deprecated
    public static class IncomingMessageViewHolder<MESSAGE extends IMessage>
    extends MessageHolders.IncomingTextMessageViewHolder<MESSAGE>
    implements MessageHolders.DefaultMessageViewHolder {
        public IncomingMessageViewHolder(View itemView) {
            super(itemView);
        }
    }

    @Deprecated
    public static class DefaultDateHeaderViewHolder
    extends ViewHolder<Date>
    implements MessageHolders.DefaultMessageViewHolder {
        protected TextView text;
        protected String dateFormat;
        protected DateFormatter.Formatter dateHeadersFormatter;

        public DefaultDateHeaderViewHolder(View itemView) {
            super(itemView);
            this.text = (TextView)itemView.findViewById(R.id.messageText);
        }

        @Override
        public void onBind(Date date) {
            if (this.text != null) {
                String formattedDate = null;
                if (this.dateHeadersFormatter != null) {
                    formattedDate = this.dateHeadersFormatter.format(date);
                }
                this.text.setText((CharSequence)(formattedDate == null ? DateFormatter.format(date, this.dateFormat) : formattedDate));
            }
        }

        @Override
        public void applyStyle(MessagesListStyle style) {
            if (this.text != null) {
                this.text.setTextColor(style.getDateHeaderTextColor());
                this.text.setTextSize(0, (float)style.getDateHeaderTextSize());
                this.text.setTypeface(this.text.getTypeface(), style.getDateHeaderTextStyle());
                this.text.setPadding(style.getDateHeaderPadding(), style.getDateHeaderPadding(), style.getDateHeaderPadding(), style.getDateHeaderPadding());
            }
            this.dateFormat = style.getDateHeaderFormat();
            this.dateFormat = this.dateFormat == null ? DateFormatter.Template.STRING_DAY_MONTH_YEAR.get() : this.dateFormat;
        }
    }

    @Deprecated
    public static abstract class BaseMessageViewHolder<MESSAGE extends IMessage>
    extends MessageHolders.BaseMessageViewHolder<MESSAGE> {
        private boolean isSelected;
        protected ImageLoader imageLoader;

        public BaseMessageViewHolder(View itemView) {
            super(itemView);
        }

        @Override
        public boolean isSelected() {
            return this.isSelected;
        }

        @Override
        public boolean isSelectionModeEnabled() {
            return isSelectionModeEnabled;
        }

        @Override
        public ImageLoader getImageLoader() {
            return this.imageLoader;
        }

        @Override
        protected void configureLinksBehavior(TextView text) {
            text.setLinksClickable(false);
            text.setMovementMethod((MovementMethod)new LinkMovementMethod(){

                public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
                    boolean result = false;
                    if (!isSelectionModeEnabled) {
                        result = super.onTouchEvent(widget, buffer, event);
                    }
                    BaseMessageViewHolder.this.itemView.onTouchEvent(event);
                    return result;
                }
            });
        }
    }

    @Deprecated
    public static class HoldersConfig
    extends MessageHolders {
        @Deprecated
        public void setIncoming(Class<? extends MessageHolders.BaseMessageViewHolder<? extends IMessage>> holder, @LayoutRes int layout2) {
            super.setIncomingTextConfig(holder, layout2);
        }

        @Deprecated
        public void setIncomingHolder(Class<? extends MessageHolders.BaseMessageViewHolder<? extends IMessage>> holder) {
            super.setIncomingTextHolder(holder);
        }

        @Deprecated
        public void setIncomingLayout(@LayoutRes int layout2) {
            super.setIncomingTextLayout(layout2);
        }

        @Deprecated
        public void setOutcoming(Class<? extends MessageHolders.BaseMessageViewHolder<? extends IMessage>> holder, @LayoutRes int layout2) {
            super.setOutcomingTextConfig(holder, layout2);
        }

        @Deprecated
        public void setOutcomingHolder(Class<? extends MessageHolders.BaseMessageViewHolder<? extends IMessage>> holder) {
            super.setOutcomingTextHolder(holder);
        }

        @Deprecated
        public void setOutcomingLayout(@LayoutRes int layout2) {
            this.setOutcomingTextLayout(layout2);
        }

        @Deprecated
        public void setDateHeader(Class<? extends ViewHolder<Date>> holder, @LayoutRes int layout2) {
            super.setDateHeaderConfig(holder, layout2);
        }
    }

    public static interface Formatter<MESSAGE> {
        public String format(MESSAGE var1);
    }

    public static interface OnMessageViewLongClickListener<MESSAGE extends IMessage> {
        public void onMessageViewLongClick(View var1, MESSAGE var2);
    }

    public static interface OnMessageLongClickListener<MESSAGE extends IMessage> {
        public void onMessageLongClick(MESSAGE var1);
    }

    public static interface OnMessageViewClickListener<MESSAGE extends IMessage> {
        public void onMessageViewClick(View var1, MESSAGE var2);
    }

    public static interface OnMessageClickListener<MESSAGE extends IMessage> {
        public void onMessageClick(MESSAGE var1);
    }

    public static interface SelectionListener {
        public void onSelectionChanged(int var1);
    }

    public static interface OnLoadMoreListener {
        public void onLoadMore(int var1, int var2);
    }

    private class Wrapper<DATA> {
        protected DATA item;
        protected boolean isSelected;

        Wrapper(DATA item) {
            this.item = item;
        }
    }
}

