/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.chatkit.messages;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.stfalcon.chatkit.R;
import com.stfalcon.chatkit.commons.ImageLoader;
import com.stfalcon.chatkit.commons.ViewHolder;
import com.stfalcon.chatkit.commons.models.IMessage;
import com.stfalcon.chatkit.messages.MessagesListStyle;
import com.stfalcon.chatkit.messages.RecyclerScrollMoreListener;
import com.stfalcon.chatkit.utils.DateFormatter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class MessagesListAdapter<MESSAGE extends IMessage>
extends RecyclerView.Adapter<ViewHolder>
implements RecyclerScrollMoreListener.OnLoadMoreListener {
    private static final int VIEW_TYPE_INCOMING_MESSAGE = 0;
    private static final int VIEW_TYPE_OUTCOMING_MESSAGE = 1;
    private static final int VIEW_TYPE_DATE_HEADER = 2;
    private HoldersConfig holders;
    private String senderId;
    private List<Wrapper> items;
    private int selectedItemsCount;
    private boolean isSelectMode;
    private SelectionListener selectionListener;
    private OnLoadMoreListener loadMoreListener;
    private OnMessageClickListener<MESSAGE> onMessageClickListener;
    private OnMessageLongClickListener<MESSAGE> onMessageLongClickListener;
    private ImageLoader imageLoader;
    private RecyclerView.LayoutManager layoutManager;
    private MessagesListStyle messagesListStyle;

    public MessagesListAdapter(String senderId, ImageLoader imageLoader) {
        this(senderId, new HoldersConfig(), imageLoader);
    }

    public MessagesListAdapter(String senderId, HoldersConfig holders, ImageLoader imageLoader) {
        this.senderId = senderId;
        this.holders = holders;
        this.imageLoader = imageLoader;
        this.items = new ArrayList<Wrapper>();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                return this.getHolder(parent, this.holders.incomingLayout, this.holders.incomingHolder);
            }
            case 1: {
                return this.getHolder(parent, this.holders.outcomingLayout, this.holders.outcomingHolder);
            }
            case 2: {
                return this.getHolder(parent, this.holders.dateHeaderLayout, this.holders.dateHeaderHolder);
            }
        }
        return null;
    }

    private <HOLDER extends ViewHolder> ViewHolder getHolder(ViewGroup parent, @LayoutRes int layout2, Class<HOLDER> holderClass) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(layout2, parent, false);
        try {
            Constructor<HOLDER> constructor = holderClass.getDeclaredConstructor(View.class);
            constructor.setAccessible(true);
            ViewHolder holder = (ViewHolder)((Object)constructor.newInstance(v));
            if (holder instanceof DefaultMessageViewHolder) {
                ((DefaultMessageViewHolder)((Object)holder)).applyStyle(this.messagesListStyle);
            }
            return holder;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        Wrapper wrapper = this.items.get(position);
        if (wrapper.item instanceof IMessage) {
            ((BaseMessageViewHolder)holder).isSelected = wrapper.isSelected;
            ((BaseMessageViewHolder)holder).imageLoader = this.imageLoader;
            holder.itemView.setOnLongClickListener(this.getMessageLongClickListener(wrapper));
            holder.itemView.setOnClickListener(this.getMessageClickListener(wrapper));
        }
        holder.onBind(wrapper.item);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int position) {
        Wrapper wrapper = this.items.get(position);
        if (wrapper.item instanceof IMessage) {
            IMessage message = (IMessage)wrapper.item;
            if (message.getUser().getId().contentEquals(this.senderId)) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    @Override
    public void onLoadMore(int page, int total) {
        if (this.loadMoreListener != null) {
            this.loadMoreListener.onLoadMore(page, total);
        }
    }

    public void addToStart(MESSAGE message, boolean scroll) {
        boolean isNewMessageToday;
        boolean bl = isNewMessageToday = !this.isPreviousSameDate(0, message.getCreatedAt());
        if (isNewMessageToday) {
            this.items.add(0, new Wrapper<Date>(message.getCreatedAt()));
        }
        Wrapper<MESSAGE> element = new Wrapper<MESSAGE>(message);
        this.items.add(0, element);
        this.notifyItemRangeInserted(0, isNewMessageToday ? 2 : 1);
        if (this.layoutManager != null && scroll) {
            this.layoutManager.scrollToPosition(0);
        }
    }

    public void addToEnd(List<MESSAGE> messages, boolean reverse) {
        if (reverse) {
            Collections.reverse(messages);
        }
        if (!this.items.isEmpty()) {
            int lastItemPosition = this.items.size() - 1;
            Date lastItem = (Date)this.items.get(lastItemPosition).item;
            if (DateFormatter.isSameDay(((IMessage)messages.get(0)).getCreatedAt(), lastItem)) {
                this.items.remove(lastItemPosition);
                this.notifyItemRemoved(lastItemPosition);
            }
        }
        int oldSize = this.items.size();
        this.generateDateHeaders(messages);
        this.notifyItemRangeInserted(oldSize, this.items.size() - oldSize);
    }

    public void update(MESSAGE message) {
        this.update(message.getId(), message);
    }

    public void update(String oldId, MESSAGE newMessage) {
        int position = this.getMessagePositionById(oldId);
        if (position >= 0) {
            Wrapper<MESSAGE> element = new Wrapper<MESSAGE>(newMessage);
            this.items.set(position, element);
            this.notifyItemChanged(position);
        }
    }

    public void delete(MESSAGE message) {
        this.deleteById(message.getId());
    }

    public void delete(List<MESSAGE> messages) {
        for (IMessage message : messages) {
            int index = this.getMessagePositionById(message.getId());
            this.items.remove(index);
            this.notifyItemRemoved(index);
        }
        this.recountDateHeaders();
    }

    public void deleteById(String id2) {
        int index = this.getMessagePositionById(id2);
        if (index >= 0) {
            this.items.remove(index);
            this.notifyItemRemoved(index);
            this.recountDateHeaders();
        }
    }

    public void deleteByIds(String[] ids) {
        for (String id2 : ids) {
            int index = this.getMessagePositionById(id2);
            this.items.remove(index);
            this.notifyItemRemoved(index);
        }
        this.recountDateHeaders();
    }

    public void clear() {
        this.items.clear();
    }

    public void enableSelectionMode(SelectionListener selectionListener) {
        if (selectionListener == null) {
            throw new IllegalArgumentException("SelectionListener must not be null. Use `disableSelectionMode()` if you want tp disable selection mode");
        }
        this.selectionListener = selectionListener;
    }

    public void disableSelectionMode() {
        this.selectionListener = null;
        this.unselectAllItems();
    }

    public ArrayList<MESSAGE> getSelectedMessages() {
        ArrayList<IMessage> selectedMessages = new ArrayList<IMessage>();
        for (Wrapper wrapper : this.items) {
            if (!(wrapper.item instanceof IMessage) || !wrapper.isSelected) continue;
            selectedMessages.add((IMessage)wrapper.item);
        }
        return selectedMessages;
    }

    public void unselectAllItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            Wrapper wrapper = this.items.get(i);
            if (!wrapper.isSelected) continue;
            wrapper.isSelected = false;
            this.notifyItemChanged(i);
        }
        this.isSelectMode = false;
        this.selectedItemsCount = 0;
        this.notifySelectionChanged();
    }

    public void deleteSelectedMessages() {
        ArrayList<MESSAGE> selectedMessages = this.getSelectedMessages();
        this.delete((List<MESSAGE>)selectedMessages);
        this.unselectAllItems();
    }

    public void setOnMessageClickListener(OnMessageClickListener<MESSAGE> onMessageClickListener) {
        this.onMessageClickListener = onMessageClickListener;
    }

    public void setOnMessageLongClickListener(OnMessageLongClickListener<MESSAGE> onMessageLongClickListener) {
        this.onMessageLongClickListener = onMessageLongClickListener;
    }

    public void setLoadMoreListener(OnLoadMoreListener loadMoreListener) {
        this.loadMoreListener = loadMoreListener;
    }

    private void recountDateHeaders() {
        ArrayList<Integer> indicesToDelete = new ArrayList<Integer>();
        for (int i = 0; i < this.items.size(); ++i) {
            Wrapper wrapper = this.items.get(i);
            if (!(wrapper.item instanceof Date)) continue;
            if (i == 0) {
                indicesToDelete.add(i);
                continue;
            }
            if (!(this.items.get(i - 1).item instanceof Date)) continue;
            indicesToDelete.add(i);
        }
        Collections.reverse(indicesToDelete);
        Iterator iterator = indicesToDelete.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.items.remove(i);
            this.notifyItemRemoved(i);
        }
    }

    private void generateDateHeaders(List<MESSAGE> messages) {
        for (int i = 0; i < messages.size(); ++i) {
            IMessage message = (IMessage)messages.get(i);
            this.items.add(new Wrapper<IMessage>(message));
            if (messages.size() > i + 1) {
                IMessage nextMessage = (IMessage)messages.get(i + 1);
                if (DateFormatter.isSameDay(message.getCreatedAt(), nextMessage.getCreatedAt())) continue;
                this.items.add(new Wrapper<Date>(message.getCreatedAt()));
                continue;
            }
            this.items.add(new Wrapper<Date>(message.getCreatedAt()));
        }
    }

    private int getMessagePositionById(String id2) {
        for (int i = 0; i < this.items.size(); ++i) {
            IMessage message;
            Wrapper wrapper = this.items.get(i);
            if (!(wrapper.item instanceof IMessage) || !(message = (IMessage)wrapper.item).getId().contentEquals(id2)) continue;
            return i;
        }
        return -1;
    }

    private boolean isPreviousSameDate(int position, Date dateToCompare) {
        if (this.items.size() <= position) {
            return false;
        }
        if (this.items.get(position).item instanceof IMessage) {
            Date previousPositionDate = ((IMessage)this.items.get(position).item).getCreatedAt();
            return DateFormatter.isSameDay(dateToCompare, previousPositionDate);
        }
        return false;
    }

    private boolean isPreviousSameAuthor(String id2, int position) {
        int prevPosition = position + 1;
        if (this.items.size() <= prevPosition) {
            return false;
        }
        if (this.items.get(prevPosition).item instanceof IMessage) {
            return ((IMessage)this.items.get(prevPosition).item).getUser().getId().contentEquals(id2);
        }
        return false;
    }

    private void incrementSelectedItemsCount() {
        ++this.selectedItemsCount;
        this.notifySelectionChanged();
    }

    private void decrementSelectedItemsCount() {
        --this.selectedItemsCount;
        this.isSelectMode = this.selectedItemsCount > 0;
        this.notifySelectionChanged();
    }

    private void notifySelectionChanged() {
        if (this.selectionListener != null) {
            this.selectionListener.onSelectionChanged(this.selectedItemsCount);
        }
    }

    private void notifyMessageClicked(MESSAGE message) {
        if (this.onMessageClickListener != null) {
            this.onMessageClickListener.onMessageClick(message);
        }
    }

    private void notifyMessageLongClicked(MESSAGE message) {
        if (this.onMessageLongClickListener != null) {
            this.onMessageLongClickListener.onMessageLongClick(message);
        }
    }

    private View.OnClickListener getMessageClickListener(final Wrapper<MESSAGE> wrapper) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (MessagesListAdapter.this.selectionListener != null && MessagesListAdapter.this.isSelectMode) {
                    boolean bl = wrapper.isSelected = !wrapper.isSelected;
                    if (wrapper.isSelected) {
                        MessagesListAdapter.this.incrementSelectedItemsCount();
                    } else {
                        MessagesListAdapter.this.decrementSelectedItemsCount();
                    }
                    IMessage message = (IMessage)wrapper.item;
                    MessagesListAdapter.this.notifyItemChanged(MessagesListAdapter.this.getMessagePositionById(message.getId()));
                } else {
                    MessagesListAdapter.this.notifyMessageClicked((IMessage)wrapper.item);
                }
            }
        };
    }

    private View.OnLongClickListener getMessageLongClickListener(final Wrapper<MESSAGE> wrapper) {
        return new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (MessagesListAdapter.this.selectionListener == null) {
                    MessagesListAdapter.this.notifyMessageLongClicked((IMessage)wrapper.item);
                    return true;
                }
                MessagesListAdapter.this.isSelectMode = true;
                view.callOnClick();
                return true;
            }
        };
    }

    void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    void setStyle(MessagesListStyle style) {
        this.messagesListStyle = style;
    }

    public static class DefaultDateHeaderViewHolder
    extends ViewHolder<Date>
    implements DefaultMessageViewHolder {
        protected TextView text;
        protected String dateFormat;

        public DefaultDateHeaderViewHolder(View itemView) {
            super(itemView);
            this.text = (TextView)itemView.findViewById(R.id.messageText);
        }

        @Override
        public void onBind(Date date) {
            this.text.setText((CharSequence)DateFormatter.format(date, this.dateFormat));
        }

        @Override
        public void applyStyle(MessagesListStyle style) {
            this.text.setTextSize(0, (float)style.getDateHeaderTextSize());
            this.text.setTextColor(style.getDateHeaderTextColor());
            this.text.setPadding(style.getDateHeaderPadding(), style.getDateHeaderPadding(), style.getDateHeaderPadding(), style.getDateHeaderPadding());
            this.dateFormat = style.getDateHeaderFormat();
            this.dateFormat = this.dateFormat == null ? DateFormatter.Template.STRING_MONTH.get() : this.dateFormat;
        }
    }

    private static class DefaultOutcomingMessageViewHolder
    extends OutcomingMessageViewHolder<IMessage> {
        public DefaultOutcomingMessageViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static class OutcomingMessageViewHolder<MESSAGE extends IMessage>
    extends BaseMessageViewHolder<MESSAGE>
    implements DefaultMessageViewHolder {
        protected ViewGroup bubble;
        protected TextView text;
        protected TextView time;
        protected ImageView userAvatar;

        public OutcomingMessageViewHolder(View itemView) {
            super(itemView);
            this.bubble = (ViewGroup)itemView.findViewById(R.id.bubble);
            this.text = (TextView)itemView.findViewById(R.id.messageText);
            this.time = (TextView)itemView.findViewById(R.id.messageTime);
            this.userAvatar = (ImageView)itemView.findViewById(R.id.messageUserAvatar);
        }

        @Override
        public void onBind(MESSAGE message) {
            this.bubble.setSelected(this.isSelected());
            this.text.setText((CharSequence)message.getText());
            this.time.setText((CharSequence)DateFormatter.format(message.getCreatedAt(), DateFormatter.Template.TIME));
            if (this.userAvatar != null) {
                boolean isAvatarExists = message.getUser().getAvatar() != null && !message.getUser().getAvatar().isEmpty();
                this.userAvatar.setVisibility(isAvatarExists ? 0 : 8);
                if (isAvatarExists && this.imageLoader != null) {
                    this.imageLoader.loadImage(this.userAvatar, message.getUser().getAvatar());
                }
            }
        }

        @Override
        public void applyStyle(MessagesListStyle style) {
            this.bubble.setPadding(style.getOutcomingDefaultBubblePaddingLeft(), style.getOutcomingDefaultBubblePaddingTop(), style.getOutcomingDefaultBubblePaddingRight(), style.getOutcomingDefaultBubblePaddingBottom());
            this.bubble.setBackground(style.getOutcomingBubbleDrawable());
            this.text.setTextColor(style.getOutcomingTextColor());
            this.text.setTextSize(0, (float)style.getOutcomingTextSize());
            this.time.setTextColor(style.getOutcomingTimeTextColor());
            this.time.setTextSize(0, (float)style.getOutcomingTimeTextSize());
        }
    }

    private static class DefaultIncomingMessageViewHolder
    extends IncomingMessageViewHolder<IMessage> {
        public DefaultIncomingMessageViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static class IncomingMessageViewHolder<MESSAGE extends IMessage>
    extends BaseMessageViewHolder<MESSAGE>
    implements DefaultMessageViewHolder {
        protected ViewGroup bubble;
        protected TextView text;
        protected TextView time;
        protected ImageView userAvatar;

        public IncomingMessageViewHolder(View itemView) {
            super(itemView);
            this.bubble = (ViewGroup)itemView.findViewById(R.id.bubble);
            this.text = (TextView)itemView.findViewById(R.id.messageText);
            this.time = (TextView)itemView.findViewById(R.id.messageTime);
            this.userAvatar = (ImageView)itemView.findViewById(R.id.messageUserAvatar);
        }

        @Override
        public void onBind(MESSAGE message) {
            this.bubble.setSelected(this.isSelected());
            this.text.setText((CharSequence)message.getText());
            this.time.setText((CharSequence)DateFormatter.format(message.getCreatedAt(), DateFormatter.Template.TIME));
            boolean isAvatarExists = this.imageLoader != null && message.getUser().getAvatar() != null && !message.getUser().getAvatar().isEmpty();
            this.userAvatar.setVisibility(isAvatarExists ? 0 : 8);
            if (isAvatarExists) {
                this.imageLoader.loadImage(this.userAvatar, message.getUser().getAvatar());
            }
        }

        @Override
        public void applyStyle(MessagesListStyle style) {
            this.bubble.setPadding(style.getIncomingDefaultBubblePaddingLeft(), style.getIncomingDefaultBubblePaddingTop(), style.getIncomingDefaultBubblePaddingRight(), style.getIncomingDefaultBubblePaddingBottom());
            this.bubble.setBackground(style.getIncomingBubbleDrawable());
            this.text.setTextColor(style.getIncomingTextColor());
            this.text.setTextSize(0, (float)style.getIncomingTextSize());
            this.userAvatar.getLayoutParams().width = style.getIncomingAvatarWidth();
            this.userAvatar.getLayoutParams().height = style.getIncomingAvatarHeight();
            this.time.setTextColor(style.getIncomingTimeTextColor());
            this.time.setTextSize(0, (float)style.getIncomingTimeTextSize());
        }
    }

    static interface DefaultMessageViewHolder {
        public void applyStyle(MessagesListStyle var1);
    }

    public static abstract class BaseMessageViewHolder<MESSAGE extends IMessage>
    extends ViewHolder<MESSAGE> {
        private boolean isSelected;
        protected ImageLoader imageLoader;

        public BaseMessageViewHolder(View itemView) {
            super(itemView);
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public ImageLoader getImageLoader() {
            return this.imageLoader;
        }
    }

    public static class HoldersConfig {
        private Class<? extends BaseMessageViewHolder<? extends IMessage>> incomingHolder = DefaultIncomingMessageViewHolder.class;
        private int incomingLayout = R.layout.item_incoming_message;
        private Class<? extends BaseMessageViewHolder<? extends IMessage>> outcomingHolder = DefaultOutcomingMessageViewHolder.class;
        private int outcomingLayout = R.layout.item_outcoming_message;
        private Class<? extends ViewHolder<Date>> dateHeaderHolder = DefaultDateHeaderViewHolder.class;
        private int dateHeaderLayout = R.layout.item_date_header;

        public void setIncoming(Class<? extends BaseMessageViewHolder<? extends IMessage>> holder, @LayoutRes int layout2) {
            this.incomingHolder = holder;
            this.incomingLayout = layout2;
        }

        public void setIncomingHolder(Class<? extends BaseMessageViewHolder<? extends IMessage>> holder) {
            this.incomingHolder = holder;
        }

        public void setIncomingLayout(@LayoutRes int layout2) {
            this.incomingLayout = layout2;
        }

        public void setOutcoming(Class<? extends BaseMessageViewHolder<? extends IMessage>> holder, @LayoutRes int layout2) {
            this.outcomingHolder = holder;
            this.outcomingLayout = layout2;
        }

        public void setOutcomingHolder(Class<? extends BaseMessageViewHolder<? extends IMessage>> holder) {
            this.outcomingHolder = holder;
        }

        public void setOutcomingLayout(@LayoutRes int layout2) {
            this.outcomingLayout = layout2;
        }

        public void setDateHeader(Class<? extends ViewHolder<Date>> holder, @LayoutRes int layout2) {
            this.dateHeaderHolder = holder;
            this.dateHeaderLayout = layout2;
        }

        public void setDateHeaderHolder(Class<? extends ViewHolder<Date>> holder) {
            this.dateHeaderHolder = holder;
        }

        public void setDateHeaderLayout(@LayoutRes int layout2) {
            this.dateHeaderLayout = layout2;
        }
    }

    public static interface OnMessageLongClickListener<MESSAGE extends IMessage> {
        public void onMessageLongClick(MESSAGE var1);
    }

    public static interface OnMessageClickListener<MESSAGE extends IMessage> {
        public void onMessageClick(MESSAGE var1);
    }

    public static interface SelectionListener {
        public void onSelectionChanged(int var1);
    }

    public static interface OnLoadMoreListener {
        public void onLoadMore(int var1, int var2);
    }

    private class Wrapper<DATA> {
        private DATA item;
        boolean isSelected;

        Wrapper(DATA item) {
            this.item = item;
        }
    }
}

