/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.smsverifycatcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.telephony.SmsMessage;
import android.util.Log;
import com.stfalcon.smsverifycatcher.OnSmsCatchListener;

class SmsReceiver
extends BroadcastReceiver {
    private OnSmsCatchListener<String> callback;
    private String phoneNumberFilter;
    private String filter;

    SmsReceiver() {
    }

    public void setCallback(OnSmsCatchListener<String> callback) {
        this.callback = callback;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        try {
            if (bundle != null) {
                Object[] pdusObj = (Object[])bundle.get("pdus");
                for (int i = 0; i < pdusObj.length; ++i) {
                    SmsMessage currentMessage = this.getIncomingMessage(pdusObj[i], bundle);
                    String phoneNumber = currentMessage.getDisplayOriginatingAddress();
                    if (this.phoneNumberFilter != null && !phoneNumber.equals(this.phoneNumberFilter)) {
                        return;
                    }
                    String message = currentMessage.getDisplayMessageBody();
                    if (this.filter != null && !message.matches(this.filter)) {
                        return;
                    }
                    if (this.callback == null) continue;
                    this.callback.onSmsCatch(message);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"SmsReceiver", (String)("Exception smsReceiver" + e));
        }
    }

    private SmsMessage getIncomingMessage(Object aObject, Bundle bundle) {
        SmsMessage currentSMS;
        if (Build.VERSION.SDK_INT >= 23) {
            String format = bundle.getString("format");
            currentSMS = SmsMessage.createFromPdu((byte[])((byte[])aObject), (String)format);
        } else {
            currentSMS = SmsMessage.createFromPdu((byte[])((byte[])aObject));
        }
        return currentSMS;
    }

    public void setPhoneNumberFilter(String phoneNumberFilter) {
        this.phoneNumberFilter = phoneNumberFilter;
    }

    public void setFilter(String regularExpression) {
        this.filter = regularExpression;
    }
}

