/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.packetlib.tcp;

import com.github.steveice10.packetlib.Session;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetInput;
import com.github.steveice10.packetlib.tcp.io.ByteBufNetOutput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;

public class TcpPacketSizer
extends ByteToMessageCodec<ByteBuf> {
    private final Session session;
    private final int size;

    public TcpPacketSizer(Session session, int size) {
        this.session = session;
        this.size = size;
    }

    public void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        int length = in.readableBytes();
        out.ensureWritable(this.session.getPacketProtocol().getPacketHeader().getLengthSize(length) + length);
        this.session.getPacketProtocol().getPacketHeader().writeLength(new ByteBufNetOutput(out), length);
        out.writeBytes(in);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        buf.markReaderIndex();
        byte[] lengthBytes = new byte[this.size];
        for (int index = 0; index < lengthBytes.length; ++index) {
            if (!buf.isReadable()) {
                buf.resetReaderIndex();
                return;
            }
            lengthBytes[index] = buf.readByte();
            if ((!this.session.getPacketProtocol().getPacketHeader().isLengthVariable() || lengthBytes[index] < 0) && index != this.size - 1) continue;
            int length = this.session.getPacketProtocol().getPacketHeader().readLength(new ByteBufNetInput(Unpooled.wrappedBuffer((byte[])lengthBytes)), buf.readableBytes());
            if (buf.readableBytes() < length) {
                buf.resetReaderIndex();
                return;
            }
            out.add(buf.readBytes(length));
            return;
        }
        throw new CorruptedFrameException("Length is too long.");
    }
}

