/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.viewmodel;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import com.stepstone.stepper.R;

public class StepViewModel {
    public static final int NULL_DRAWABLE = -1;
    @Nullable
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mEndButtonLabel;
    @Nullable
    private final CharSequence mBackButtonLabel;
    @DrawableRes
    private final int mNextButtonEndDrawableResId;
    @DrawableRes
    private final int mBackButtonStartDrawableResId;
    private final boolean mEndButtonVisible;
    private final boolean mBackButtonVisible;

    private StepViewModel(@Nullable CharSequence title, @Nullable CharSequence endButtonLabel, @Nullable CharSequence backButtonLabel, @DrawableRes int nextButtonEndDrawableResId, @DrawableRes int backButtonStartDrawableResId, boolean endButtonVisible, boolean backButtonVisible) {
        this.mTitle = title;
        this.mEndButtonLabel = endButtonLabel;
        this.mBackButtonLabel = backButtonLabel;
        this.mNextButtonEndDrawableResId = nextButtonEndDrawableResId;
        this.mBackButtonStartDrawableResId = backButtonStartDrawableResId;
        this.mEndButtonVisible = endButtonVisible;
        this.mBackButtonVisible = backButtonVisible;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getEndButtonLabel() {
        return this.mEndButtonLabel;
    }

    @Nullable
    public CharSequence getBackButtonLabel() {
        return this.mBackButtonLabel;
    }

    @DrawableRes
    public int getNextButtonEndDrawableResId() {
        return this.mNextButtonEndDrawableResId;
    }

    @DrawableRes
    public int getBackButtonStartDrawableResId() {
        return this.mBackButtonStartDrawableResId;
    }

    public boolean isEndButtonVisible() {
        return this.mEndButtonVisible;
    }

    public boolean isBackButtonVisible() {
        return this.mBackButtonVisible;
    }

    public static class Builder {
        @NonNull
        private final Context mContext;
        @Nullable
        private CharSequence mTitle;
        @Nullable
        private CharSequence mEndButtonLabel;
        @Nullable
        private CharSequence mBackButtonLabel;
        @DrawableRes
        private int mNextButtonEndDrawableResId = R.drawable.ms_ic_chevron_end;
        @DrawableRes
        private int mBackButtonStartDrawableResId = R.drawable.ms_ic_chevron_start;
        private boolean mEndButtonVisible = true;
        private boolean mBackButtonVisible = true;

        public Builder(@NonNull Context context) {
            this.mContext = context;
        }

        public Builder setTitle(@StringRes int titleId) {
            this.mTitle = this.mContext.getString(titleId);
            return this;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setEndButtonLabel(@Nullable CharSequence endButtonLabel) {
            this.mEndButtonLabel = endButtonLabel;
            return this;
        }

        public Builder setEndButtonLabel(@StringRes int endButtonLabelId) {
            this.mEndButtonLabel = this.mContext.getString(endButtonLabelId);
            return this;
        }

        public Builder setBackButtonLabel(@StringRes int backButtonLabelId) {
            this.mBackButtonLabel = this.mContext.getString(backButtonLabelId);
            return this;
        }

        public Builder setBackButtonLabel(@Nullable CharSequence backButtonLabel) {
            this.mBackButtonLabel = backButtonLabel;
            return this;
        }

        public Builder setNextButtonEndDrawableResId(@DrawableRes int nextButtonEndDrawableResId) {
            this.mNextButtonEndDrawableResId = nextButtonEndDrawableResId;
            return this;
        }

        public Builder setBackButtonStartDrawableResId(@DrawableRes int backButtonStartDrawableResId) {
            this.mBackButtonStartDrawableResId = backButtonStartDrawableResId;
            return this;
        }

        public Builder setEndButtonVisible(boolean endButtonVisible) {
            this.mEndButtonVisible = endButtonVisible;
            return this;
        }

        public Builder setBackButtonVisible(boolean backButtonVisible) {
            this.mBackButtonVisible = backButtonVisible;
            return this;
        }

        public StepViewModel create() {
            return new StepViewModel(this.mTitle, this.mEndButtonLabel, this.mBackButtonLabel, this.mNextButtonEndDrawableResId, this.mBackButtonStartDrawableResId, this.mEndButtonVisible, this.mBackButtonVisible);
        }
    }
}

