/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.type;

import android.support.annotation.RestrictTo;
import android.util.Log;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.internal.type.AbstractStepperType;
import com.stepstone.stepper.internal.type.DotsStepperType;
import com.stepstone.stepper.internal.type.ProgressBarStepperType;
import com.stepstone.stepper.internal.type.TabsStepperType;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class StepperTypeFactory {
    private static final String TAG = StepperTypeFactory.class.getSimpleName();

    public static AbstractStepperType createType(int stepType, StepperLayout stepperLayout) {
        switch (stepType) {
            case 1: {
                return new DotsStepperType(stepperLayout);
            }
            case 2: {
                return new ProgressBarStepperType(stepperLayout);
            }
            case 3: {
                return new TabsStepperType(stepperLayout);
            }
        }
        Log.e((String)TAG, (String)("Unsupported type: " + stepType));
        throw new IllegalArgumentException("Unsupported type: " + stepType);
    }
}

