/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.type;

import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.adapter.StepAdapter;
import com.stepstone.stepper.internal.type.AbstractStepperType;
import com.stepstone.stepper.internal.widget.ColorableProgressBar;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ProgressBarStepperType
extends AbstractStepperType {
    private final ColorableProgressBar mProgressBar;

    public ProgressBarStepperType(StepperLayout stepperLayout) {
        super(stepperLayout);
        this.mProgressBar = (ColorableProgressBar)stepperLayout.findViewById(R.id.ms_stepProgressBar);
        this.mProgressBar.setProgressColor(this.getSelectedColor());
        this.mProgressBar.setProgressBackgroundColor(this.getUnselectedColor());
        if (stepperLayout.isInEditMode()) {
            this.mProgressBar.setVisibility(0);
            this.mProgressBar.setProgressCompat(1, false);
            this.mProgressBar.setMax(3);
        }
    }

    @Override
    public void onStepSelected(int newStepPosition, boolean userTriggeredChange) {
        this.mProgressBar.setProgressCompat(newStepPosition + 1, userTriggeredChange);
    }

    @Override
    public void onNewAdapter(@NonNull StepAdapter stepAdapter) {
        super.onNewAdapter(stepAdapter);
        int stepCount = stepAdapter.getCount();
        this.mProgressBar.setMax(stepAdapter.getCount());
        this.mProgressBar.setVisibility(stepCount > 1 ? 0 : 8);
    }
}

