/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.feedback;

import android.animation.TimeInterpolator;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.internal.feedback.StepperFeedbackType;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class TabsStepperFeedbackType
implements StepperFeedbackType {
    private final float mProgressMessageTranslationWhenHidden;
    private boolean mTabNavigationEnabled;
    private TextView mProgressMessageTextView;
    private View mTabs;
    private StepperLayout mStepperLayout;

    public TabsStepperFeedbackType(@NonNull StepperLayout stepperLayout) {
        this.mProgressMessageTranslationWhenHidden = stepperLayout.getResources().getDimension(R.dimen.ms_progress_message_translation_when_hidden);
        this.mProgressMessageTextView = (TextView)stepperLayout.findViewById(R.id.ms_stepTabsProgressMessage);
        this.mTabs = stepperLayout.findViewById(R.id.ms_stepTabsScrollView);
        this.mStepperLayout = stepperLayout;
        this.mProgressMessageTextView.setVisibility(0);
    }

    @Override
    public void showProgress(@NonNull String progressMessage) {
        this.mTabNavigationEnabled = this.mStepperLayout.isTabNavigationEnabled();
        this.setTabNavigationEnabled(false);
        this.mProgressMessageTextView.setText((CharSequence)progressMessage);
        this.mProgressMessageTextView.animate().setStartDelay(200L).alpha(1.0f).translationY(0.0f).setDuration(200L);
        this.mTabs.animate().alpha(0.0f).setStartDelay(0L).setInterpolator((TimeInterpolator)new LinearInterpolator()).setDuration(200L);
    }

    @Override
    public void hideProgress() {
        this.setTabNavigationEnabled(this.mTabNavigationEnabled);
        this.mProgressMessageTextView.animate().setStartDelay(0L).alpha(0.0f).translationY(this.mProgressMessageTranslationWhenHidden).setDuration(200L);
        this.mTabs.animate().alpha(1.0f).setStartDelay(200L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(200L);
    }

    private void setTabNavigationEnabled(boolean tabNavigationEnabled) {
        this.mStepperLayout.setTabNavigationEnabled(tabNavigationEnabled);
    }
}

