/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.util;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.Log;
import android.widget.TextView;

public class TintUtil {
    private static final String TAG = TintUtil.class.getSimpleName();

    public static void tintTextView(@NonNull TextView textview, ColorStateList tintColor) {
        textview.setTextColor(tintColor);
        if (Build.VERSION.SDK_INT >= 17) {
            Drawable[] drawables = textview.getCompoundDrawablesRelative();
            textview.setCompoundDrawablesRelative(TintUtil.tintDrawable(drawables[0], tintColor), TintUtil.tintDrawable(drawables[1], tintColor), TintUtil.tintDrawable(drawables[2], tintColor), TintUtil.tintDrawable(drawables[3], tintColor));
        } else {
            Drawable[] drawables = textview.getCompoundDrawables();
            textview.setCompoundDrawables(TintUtil.tintDrawable(drawables[0], tintColor), TintUtil.tintDrawable(drawables[1], tintColor), TintUtil.tintDrawable(drawables[2], tintColor), TintUtil.tintDrawable(drawables[3], tintColor));
        }
    }

    public static Drawable tintDrawable(@Nullable Drawable drawable2, @ColorInt int color2) {
        if (drawable2 != null) {
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
        return drawable2;
    }

    public static Drawable tintDrawable(@Nullable Drawable drawable2, ColorStateList color2) {
        if (drawable2 != null) {
            drawable2 = DrawableCompat.unwrap((Drawable)drawable2);
            Rect bounds = drawable2.getBounds();
            drawable2 = DrawableCompat.wrap((Drawable)drawable2);
            if (bounds.right == 0 || bounds.bottom == 0) {
                if (drawable2.getIntrinsicHeight() != -1 && drawable2.getIntrinsicWidth() != -1) {
                    bounds.right = drawable2.getIntrinsicWidth();
                    bounds.bottom = drawable2.getIntrinsicHeight();
                } else {
                    Log.w((String)TAG, (String)"Cannot tint drawable because its bounds cannot be determined!");
                    return DrawableCompat.unwrap((Drawable)drawable2);
                }
            }
            DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)color2);
            drawable2.setBounds(bounds);
        }
        return drawable2;
    }
}

