/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.type;

import android.support.annotation.NonNull;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.adapter.StepAdapter;
import com.stepstone.stepper.internal.ColorableProgressBar;
import com.stepstone.stepper.type.AbstractStepperType;

public class ProgressBarStepperType
extends AbstractStepperType {
    private final ColorableProgressBar mProgressBar;

    public ProgressBarStepperType(StepperLayout stepperLayout) {
        super(stepperLayout);
        this.mProgressBar = (ColorableProgressBar)stepperLayout.findViewById(R.id.ms_stepProgressBar);
        this.mProgressBar.setVisibility(0);
        this.mProgressBar.setProgressColor(this.getSelectedColor());
        this.mProgressBar.setProgressBackgroundColor(this.getUnselectedColor());
    }

    @Override
    public void onStepSelected(int newStepPosition) {
        this.mProgressBar.setProgress(newStepPosition + 1);
    }

    @Override
    public void onNewAdapter(@NonNull StepAdapter stepAdapter) {
        int stepCount = stepAdapter.getCount();
        this.mProgressBar.setMax(stepAdapter.getCount());
        this.mProgressBar.setVisibility(stepCount > 1 ? 0 : 8);
    }
}

