/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import com.stepstone.stepper.R;
import com.stepstone.stepper.internal.StepTab;
import java.util.List;

public class TabsContainer
extends FrameLayout {
    @ColorInt
    private int mUnselectedColor;
    @ColorInt
    private int mSelectedColor;
    @ColorInt
    private int mErrorColor;
    private int mDividerWidth = -1;
    private int mContainerLateralPadding;
    private HorizontalScrollView mTabsScrollView;
    private LinearLayout mTabsInnerContainer;
    private TabItemListener mListener = TabItemListener.NULL;
    private List<CharSequence> mStepTitles;
    private boolean mShowErrorStateOnBack;

    public TabsContainer(Context context) {
        this(context, null);
    }

    public TabsContainer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TabsContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.ms_tabs_container, (ViewGroup)this, true);
        this.mSelectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_selectedColor);
        this.mUnselectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_unselectedColor);
        this.mErrorColor = ContextCompat.getColor((Context)context, (int)R.color.ms_errorColor);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TabsContainer, defStyleAttr, 0);
            if (a.hasValue(R.styleable.TabsContainer_ms_activeTabColor)) {
                this.mSelectedColor = a.getColor(R.styleable.TabsContainer_ms_activeTabColor, this.mSelectedColor);
            }
            if (a.hasValue(R.styleable.TabsContainer_ms_inactiveTabColor)) {
                this.mUnselectedColor = a.getColor(R.styleable.TabsContainer_ms_inactiveTabColor, this.mUnselectedColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_errorColor)) {
                this.mErrorColor = a.getColor(R.styleable.StepperLayout_ms_errorColor, this.mErrorColor);
            }
            a.recycle();
        }
        this.mContainerLateralPadding = context.getResources().getDimensionPixelOffset(R.dimen.ms_tabs_container_lateral_padding);
        this.mTabsInnerContainer = (LinearLayout)this.findViewById(R.id.ms_stepTabsInnerContainer);
        this.mTabsScrollView = (HorizontalScrollView)this.findViewById(R.id.ms_stepTabsScrollView);
    }

    public void setUnselectedColor(@ColorInt int unselectedColor) {
        this.mUnselectedColor = unselectedColor;
    }

    public void setSelectedColor(@ColorInt int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    public void setErrorColor(@ColorInt int mErrorColor) {
        this.mErrorColor = mErrorColor;
    }

    public void setDividerWidth(int dividerWidth) {
        this.mDividerWidth = dividerWidth;
    }

    public void setListener(@NonNull TabItemListener listener) {
        this.mListener = listener;
    }

    public void setSteps(List<CharSequence> stepTitles) {
        this.mStepTitles = stepTitles;
        this.mTabsInnerContainer.removeAllViews();
        for (int i = 0; i < stepTitles.size(); ++i) {
            View tab = this.createStepTab(i, stepTitles.get(i));
            this.mTabsInnerContainer.addView(tab, tab.getLayoutParams());
        }
    }

    public void setCurrentStep(int newStepPosition) {
        int size = this.mStepTitles.size();
        for (int i = 0; i < size; ++i) {
            StepTab childTab = (StepTab)this.mTabsInnerContainer.getChildAt(i);
            boolean done = i < newStepPosition;
            boolean current = i == newStepPosition;
            childTab.updateState(done, this.mShowErrorStateOnBack, current);
            if (!current) continue;
            this.mTabsScrollView.smoothScrollTo(childTab.getLeft() - this.mContainerLateralPadding, 0);
        }
    }

    public void setShowErrorStateOnBack(boolean mShowErrorStateOnBack) {
        this.mShowErrorStateOnBack = mShowErrorStateOnBack;
    }

    public void setErrorStep(int stepPosition, boolean hasError) {
        if (this.mStepTitles.size() < stepPosition) {
            return;
        }
        StepTab childTab = (StepTab)this.mTabsInnerContainer.getChildAt(stepPosition);
        childTab.updateErrorState(this.mStepTitles.size() - 1 == stepPosition, hasError);
    }

    private View createStepTab(final int position, @Nullable CharSequence title) {
        StepTab view = (StepTab)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ms_step_tab_container, (ViewGroup)this.mTabsInnerContainer, false);
        view.setStepNumber(String.valueOf(position + 1));
        view.toggleDividerVisibility(!this.isLastPosition(position));
        view.setStepTitle(title);
        view.setSelectedColor(this.mSelectedColor);
        view.setUnselectedColor(this.mUnselectedColor);
        view.setErrorColor(this.mErrorColor);
        view.setDividerWidth(this.mDividerWidth);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabsContainer.this.mListener.onTabClicked(position);
            }
        });
        return view;
    }

    private boolean isLastPosition(int position) {
        return position == this.mStepTitles.size() - 1;
    }

    public static interface TabItemListener {
        public static final TabItemListener NULL = new TabItemListener(){

            @Override
            public void onTabClicked(int position) {
            }
        };

        @UiThread
        public void onTabClicked(int var1);
    }
}

