/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.stepstone.stepper.R;
import com.stepstone.stepper.util.TintUtil;

public class StepTab
extends RelativeLayout {
    private static final float INACTIVE_STEP_TITLE_ALPHA = 0.54f;
    private static final int OPAQUE_ALPHA = 1;
    @ColorInt
    private int mUnselectedColor;
    @ColorInt
    private int mSelectedColor;
    @ColorInt
    private int mErrorColor;
    @ColorInt
    private int mTitleColor;
    private final TextView mStepNumber;
    private final View mStepDivider;
    private final TextView mStepTitle;
    private final ImageView mStepDoneIndicator;
    private final ImageView mStepErrorIndicator;
    private int mDividerWidth = -1;
    private boolean mHasError;
    private Typeface mNormalTypeface;
    private Typeface mBoldTypeface;

    public StepTab(Context context) {
        this(context, null);
    }

    public StepTab(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StepTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ms_step_tab, (ViewGroup)this, true);
        this.mSelectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_selectedColor);
        this.mUnselectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_unselectedColor);
        this.mErrorColor = ContextCompat.getColor((Context)context, (int)R.color.ms_errorColor);
        this.mStepNumber = (TextView)this.findViewById(R.id.ms_stepNumber);
        this.mStepDoneIndicator = (ImageView)this.findViewById(R.id.ms_stepDoneIndicator);
        this.mStepErrorIndicator = (ImageView)this.findViewById(R.id.ms_stepErrorIndicator);
        this.mStepDivider = this.findViewById(R.id.ms_stepDivider);
        this.mStepTitle = (TextView)this.findViewById(R.id.ms_stepTitle);
        this.mTitleColor = this.mStepTitle.getCurrentTextColor();
        Typeface typeface = this.mStepTitle.getTypeface();
        this.mNormalTypeface = Typeface.create((Typeface)typeface, (int)0);
        this.mBoldTypeface = Typeface.create((Typeface)typeface, (int)1);
    }

    public void toggleDividerVisibility(boolean show) {
        this.mStepDivider.setVisibility(show ? 0 : 8);
    }

    public void updateState(boolean done, boolean showErrorOnBack, boolean current) {
        if (this.mHasError && showErrorOnBack) {
            return;
        }
        this.mStepDoneIndicator.setVisibility(done ? 0 : 8);
        this.mStepNumber.setVisibility(!done ? 0 : 8);
        this.mStepErrorIndicator.setVisibility(8);
        this.colorViewBackground((View)(done ? this.mStepDoneIndicator : this.mStepNumber), done || current);
        this.mHasError = false;
        this.mStepTitle.setTextColor(this.mTitleColor);
        this.mStepTitle.setTypeface(current ? this.mBoldTypeface : this.mNormalTypeface);
        this.mStepTitle.setAlpha(done || current ? 1.0f : 0.54f);
    }

    public void updateErrorState(boolean isLastStep, boolean hasError) {
        if (hasError) {
            this.mStepDoneIndicator.setVisibility(8);
            this.mStepNumber.setVisibility(8);
            this.mStepErrorIndicator.setVisibility(0);
            this.mStepErrorIndicator.setColorFilter(this.mErrorColor);
            this.mStepTitle.setTextColor(this.mErrorColor);
        } else if (isLastStep) {
            this.mStepDoneIndicator.setVisibility(0);
            this.mStepErrorIndicator.setVisibility(8);
            this.colorViewBackground((View)this.mStepDoneIndicator, true);
            this.mStepTitle.setTextColor(this.mTitleColor);
        }
        this.mHasError = hasError;
    }

    public void setStepTitle(CharSequence title) {
        this.mStepTitle.setText(title);
    }

    public void setStepNumber(CharSequence number) {
        this.mStepNumber.setText(number);
    }

    public void setUnselectedColor(int unselectedColor) {
        this.mUnselectedColor = unselectedColor;
    }

    public void setSelectedColor(int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    public void setErrorColor(int errorColor) {
        this.mErrorColor = errorColor;
    }

    private void colorViewBackground(View view, boolean selected) {
        Drawable d = view.getBackground();
        TintUtil.tintDrawable(d, selected ? this.mSelectedColor : this.mUnselectedColor);
    }

    public void setDividerWidth(int dividerWidth) {
        this.mDividerWidth = dividerWidth;
        this.mStepDivider.getLayoutParams().width = this.mDividerWidth != -1 ? dividerWidth : this.getResources().getDimensionPixelOffset(R.dimen.ms_step_tab_divider_length);
    }
}

