/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.view.ContextThemeWrapper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.stepstone.stepper.BlockingStep;
import com.stepstone.stepper.R;
import com.stepstone.stepper.Step;
import com.stepstone.stepper.VerificationError;
import com.stepstone.stepper.adapter.StepAdapter;
import com.stepstone.stepper.internal.ColorableProgressBar;
import com.stepstone.stepper.internal.DottedProgressBar;
import com.stepstone.stepper.internal.RightNavigationButton;
import com.stepstone.stepper.internal.TabsContainer;
import com.stepstone.stepper.type.AbstractStepperType;
import com.stepstone.stepper.type.StepperTypeFactory;
import com.stepstone.stepper.util.AnimationUtil;
import com.stepstone.stepper.util.TintUtil;
import com.stepstone.stepper.viewmodel.StepViewModel;

public class StepperLayout
extends LinearLayout
implements TabsContainer.TabItemListener {
    public static final int DEFAULT_TAB_DIVIDER_WIDTH = -1;
    private ViewPager mPager;
    private Button mBackNavigationButton;
    private RightNavigationButton mNextNavigationButton;
    private RightNavigationButton mCompleteNavigationButton;
    private ViewGroup mStepNavigation;
    private DottedProgressBar mDottedProgressBar;
    private ColorableProgressBar mProgressBar;
    private TabsContainer mTabsContainer;
    private ColorStateList mBackButtonColor;
    private ColorStateList mNextButtonColor;
    private ColorStateList mCompleteButtonColor;
    @ColorInt
    private int mUnselectedColor;
    @ColorInt
    private int mSelectedColor;
    @ColorInt
    private int mErrorColor;
    @DrawableRes
    private int mBottomNavigationBackground;
    @DrawableRes
    private int mBackButtonBackground;
    @DrawableRes
    private int mNextButtonBackground;
    @DrawableRes
    private int mCompleteButtonBackground;
    private int mTabStepDividerWidth = -1;
    private String mBackButtonText;
    private String mNextButtonText;
    private String mCompleteButtonText;
    private boolean mShowBackButtonOnFirstStep;
    private int mTypeIdentifier = 2;
    private StepAdapter mStepAdapter;
    private AbstractStepperType mStepperType;
    private int mCurrentStepPosition;
    private boolean mShowErrorState;
    private boolean mShowErrorStateOnBack;
    @StyleRes
    private int mStepperLayoutTheme;
    @NonNull
    private StepperListener mListener = StepperListener.NULL;
    private View.OnClickListener mOnBackClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            StepperLayout.this.onPrevious();
        }
    };
    private View.OnClickListener mOnNextClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            StepperLayout.this.onNext();
        }
    };
    private View.OnClickListener mOnCompleteClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            StepperLayout.this.onComplete();
        }
    };

    public StepperLayout(Context context) {
        this(context, null);
    }

    public StepperLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, this.isInEditMode() ? 0 : R.attr.ms_stepperStyle);
    }

    public StepperLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    public void setListener(@NonNull StepperListener listener) {
        this.mListener = listener;
    }

    public void setAdapter(@NonNull StepAdapter stepAdapter) {
        this.mStepAdapter = stepAdapter;
        this.mPager.setAdapter(stepAdapter.getPagerAdapter());
        this.mStepperType.onNewAdapter(stepAdapter);
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                StepperLayout.this.onUpdate(StepperLayout.this.mCurrentStepPosition, false);
            }
        });
    }

    public void setAdapter(@NonNull StepAdapter stepAdapter, @IntRange(from=0L) int currentStepPosition) {
        this.mCurrentStepPosition = currentStepPosition;
        this.setAdapter(stepAdapter);
    }

    public void setPageTransformer(@Nullable ViewPager.PageTransformer pageTransformer) {
        this.mPager.setPageTransformer(false, pageTransformer);
    }

    public int getSelectedColor() {
        return this.mSelectedColor;
    }

    public int getUnselectedColor() {
        return this.mUnselectedColor;
    }

    public int getErrorColor() {
        return this.mErrorColor;
    }

    public int getTabStepDividerWidth() {
        return this.mTabStepDividerWidth;
    }

    @Override
    @UiThread
    public void onTabClicked(int position) {
        if (position > this.mCurrentStepPosition) {
            this.onNext();
        } else if (position < this.mCurrentStepPosition) {
            this.setCurrentStepPosition(position);
        }
    }

    public void proceed() {
        if (this.isLastPosition(this.mCurrentStepPosition)) {
            this.onComplete();
        } else {
            this.onNext();
        }
    }

    public void setCurrentStepPosition(int currentStepPosition) {
        this.mCurrentStepPosition = currentStepPosition;
        this.onUpdate(currentStepPosition, true);
    }

    public int getCurrentStepPosition() {
        return this.mCurrentStepPosition;
    }

    public void setNextButtonVerificationFailed(boolean verificationFailed) {
        this.mNextNavigationButton.setVerificationFailed(verificationFailed);
    }

    public void setCompleteButtonVerificationFailed(boolean verificationFailed) {
        this.mCompleteNavigationButton.setVerificationFailed(verificationFailed);
    }

    public void setShowErrorStateOnBack(boolean mShowErrorStateOnBack) {
        this.mShowErrorStateOnBack = mShowErrorStateOnBack;
    }

    public void setShowErrorState(boolean mShowErrorState) {
        this.mShowErrorState = mShowErrorState;
    }

    public void setOffscreenPageLimit(int limit) {
        this.mPager.setOffscreenPageLimit(limit);
    }

    private void init(AttributeSet attrs, @AttrRes int defStyleAttr) {
        this.initDefaultValues();
        this.extractValuesFromAttributes(attrs, defStyleAttr);
        Context context = this.getContext();
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(context, context.getTheme());
        contextThemeWrapper.setTheme(this.mStepperLayoutTheme);
        LayoutInflater.from((Context)contextThemeWrapper).inflate(R.layout.ms_stepper_layout, (ViewGroup)this, true);
        this.bindViews();
        this.mPager.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        this.initNavigation();
        this.mDottedProgressBar.setVisibility(8);
        this.mProgressBar.setVisibility(8);
        this.mTabsContainer.setVisibility(8);
        this.mStepperType = StepperTypeFactory.createType(this.mTypeIdentifier, this);
    }

    private void initNavigation() {
        if (this.mBottomNavigationBackground != 0) {
            this.mStepNavigation.setBackgroundResource(this.mBottomNavigationBackground);
        }
        this.mBackNavigationButton.setText((CharSequence)this.mBackButtonText);
        this.mNextNavigationButton.setText(this.mNextButtonText);
        this.mCompleteNavigationButton.setText(this.mCompleteButtonText);
        this.setBackgroundIfPresent(this.mBackButtonBackground, (View)this.mBackNavigationButton);
        this.setBackgroundIfPresent(this.mNextButtonBackground, (View)this.mNextNavigationButton);
        this.setBackgroundIfPresent(this.mCompleteButtonBackground, (View)this.mCompleteNavigationButton);
        this.mBackNavigationButton.setOnClickListener(this.mOnBackClickListener);
        this.mNextNavigationButton.setOnClickListener(this.mOnNextClickListener);
        this.mCompleteNavigationButton.setOnClickListener(this.mOnCompleteClickListener);
    }

    private void setCompoundDrawablesForNavigationButtons(@DrawableRes int backDrawableResId, @DrawableRes int nextDrawableResId) {
        Drawable chevronEndDrawable;
        Drawable chevronStartDrawable = backDrawableResId != -1 ? ResourcesCompat.getDrawable((Resources)this.getContext().getResources(), (int)backDrawableResId, null) : null;
        Drawable drawable2 = chevronEndDrawable = nextDrawableResId != -1 ? ResourcesCompat.getDrawable((Resources)this.getContext().getResources(), (int)nextDrawableResId, null) : null;
        if (Build.VERSION.SDK_INT >= 17) {
            this.mBackNavigationButton.setCompoundDrawablesRelativeWithIntrinsicBounds(chevronStartDrawable, null, null, null);
        } else {
            this.mBackNavigationButton.setCompoundDrawablesWithIntrinsicBounds(chevronStartDrawable, null, null, null);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.mNextNavigationButton.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, chevronEndDrawable, null);
        } else {
            this.mNextNavigationButton.setCompoundDrawablesWithIntrinsicBounds(null, null, chevronEndDrawable, null);
        }
        TintUtil.tintTextView((TextView)this.mBackNavigationButton, this.mBackButtonColor);
        TintUtil.tintTextView((TextView)this.mNextNavigationButton, this.mNextButtonColor);
        TintUtil.tintTextView((TextView)this.mCompleteNavigationButton, this.mCompleteButtonColor);
    }

    private void setBackgroundIfPresent(@DrawableRes int backgroundRes, View view) {
        if (backgroundRes != 0) {
            view.setBackgroundResource(backgroundRes);
        }
    }

    private void bindViews() {
        this.mPager = (ViewPager)this.findViewById(R.id.ms_stepPager);
        this.mBackNavigationButton = (Button)this.findViewById(R.id.ms_stepPrevButton);
        this.mNextNavigationButton = (RightNavigationButton)this.findViewById(R.id.ms_stepNextButton);
        this.mCompleteNavigationButton = (RightNavigationButton)this.findViewById(R.id.ms_stepCompleteButton);
        this.mStepNavigation = (ViewGroup)this.findViewById(R.id.ms_bottomNavigation);
        this.mDottedProgressBar = (DottedProgressBar)this.findViewById(R.id.ms_stepDottedProgressBar);
        this.mProgressBar = (ColorableProgressBar)this.findViewById(R.id.ms_stepProgressBar);
        this.mTabsContainer = (TabsContainer)this.findViewById(R.id.ms_stepTabsContainer);
    }

    private void extractValuesFromAttributes(AttributeSet attrs, @AttrRes int defStyleAttr) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.StepperLayout, defStyleAttr, 0);
            if (a.hasValue(R.styleable.StepperLayout_ms_backButtonColor)) {
                this.mBackButtonColor = a.getColorStateList(R.styleable.StepperLayout_ms_backButtonColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_nextButtonColor)) {
                this.mNextButtonColor = a.getColorStateList(R.styleable.StepperLayout_ms_nextButtonColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_completeButtonColor)) {
                this.mCompleteButtonColor = a.getColorStateList(R.styleable.StepperLayout_ms_completeButtonColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_activeStepColor)) {
                this.mSelectedColor = a.getColor(R.styleable.StepperLayout_ms_activeStepColor, this.mSelectedColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_inactiveStepColor)) {
                this.mUnselectedColor = a.getColor(R.styleable.StepperLayout_ms_inactiveStepColor, this.mUnselectedColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_errorColor)) {
                this.mErrorColor = a.getColor(R.styleable.StepperLayout_ms_errorColor, this.mErrorColor);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_bottomNavigationBackground)) {
                this.mBottomNavigationBackground = a.getResourceId(R.styleable.StepperLayout_ms_bottomNavigationBackground, 0);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_backButtonBackground)) {
                this.mBackButtonBackground = a.getResourceId(R.styleable.StepperLayout_ms_backButtonBackground, 0);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_nextButtonBackground)) {
                this.mNextButtonBackground = a.getResourceId(R.styleable.StepperLayout_ms_nextButtonBackground, 0);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_completeButtonBackground)) {
                this.mCompleteButtonBackground = a.getResourceId(R.styleable.StepperLayout_ms_completeButtonBackground, 0);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_backButtonText)) {
                this.mBackButtonText = a.getString(R.styleable.StepperLayout_ms_backButtonText);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_nextButtonText)) {
                this.mNextButtonText = a.getString(R.styleable.StepperLayout_ms_nextButtonText);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_completeButtonText)) {
                this.mCompleteButtonText = a.getString(R.styleable.StepperLayout_ms_completeButtonText);
            }
            if (a.hasValue(R.styleable.StepperLayout_ms_tabStepDividerWidth)) {
                this.mTabStepDividerWidth = a.getDimensionPixelOffset(R.styleable.StepperLayout_ms_tabStepDividerWidth, -1);
            }
            this.mShowBackButtonOnFirstStep = a.getBoolean(R.styleable.StepperLayout_ms_showBackButtonOnFirstStep, false);
            this.mShowErrorState = a.getBoolean(R.styleable.StepperLayout_ms_showErrorState, false);
            if (a.hasValue(R.styleable.StepperLayout_ms_stepperType)) {
                this.mTypeIdentifier = a.getInt(R.styleable.StepperLayout_ms_stepperType, -1);
            }
            this.mShowErrorStateOnBack = a.getBoolean(R.styleable.StepperLayout_ms_showErrorStateOnBack, false);
            this.mStepperLayoutTheme = a.getResourceId(R.styleable.StepperLayout_ms_stepperLayoutTheme, R.style.MSDefaultStepperLayoutTheme);
            a.recycle();
        }
    }

    private void initDefaultValues() {
        this.mNextButtonColor = this.mCompleteButtonColor = ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.ms_bottomNavigationButtonTextColor);
        this.mBackButtonColor = this.mCompleteButtonColor;
        this.mSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.ms_selectedColor);
        this.mUnselectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.ms_unselectedColor);
        this.mErrorColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.ms_errorColor);
        this.mBackButtonText = this.getContext().getString(R.string.ms_back);
        this.mNextButtonText = this.getContext().getString(R.string.ms_next);
        this.mCompleteButtonText = this.getContext().getString(R.string.ms_complete);
    }

    private boolean isLastPosition(int position) {
        return position == this.mStepAdapter.getCount() - 1;
    }

    private Step findCurrentStep() {
        return this.mStepAdapter.findStep(this.mPager, this.mCurrentStepPosition);
    }

    private void onPrevious() {
        Step step = this.findCurrentStep();
        OnBackClickedCallback onBackClickedCallback = new OnBackClickedCallback();
        if (step instanceof BlockingStep) {
            ((BlockingStep)step).onBackClicked(onBackClickedCallback);
        } else {
            onBackClickedCallback.goToPrevStep();
        }
    }

    @UiThread
    private void onNext() {
        Step step = this.findCurrentStep();
        if (this.verifyCurrentStep(step)) {
            return;
        }
        if (this.mShowErrorState) {
            this.mStepperType.setErrorStep(this.mCurrentStepPosition, false);
        }
        OnNextClickedCallback onNextClickedCallback = new OnNextClickedCallback();
        if (step instanceof BlockingStep) {
            ((BlockingStep)step).onNextClicked(onNextClickedCallback);
        } else {
            onNextClickedCallback.goToNextStep();
        }
    }

    private boolean verifyCurrentStep(Step step) {
        VerificationError verificationError = step.verifyStep();
        if (verificationError != null) {
            this.onError(verificationError);
            return true;
        }
        return false;
    }

    private void onError(@NonNull VerificationError verificationError) {
        Step step = this.findCurrentStep();
        if (step != null) {
            step.onError(verificationError);
            if (this.mShowErrorState) {
                this.mStepperType.setErrorStep(this.mCurrentStepPosition, true);
            }
        }
        this.mListener.onError(verificationError);
    }

    private void onComplete() {
        Step step = this.findCurrentStep();
        if (this.verifyCurrentStep(step)) {
            return;
        }
        this.mStepperType.setErrorStep(this.mCurrentStepPosition, false);
        this.mListener.onCompleted((View)this.mCompleteNavigationButton);
    }

    private void onUpdate(int newStepPosition, boolean animate) {
        this.mPager.setCurrentItem(newStepPosition);
        boolean isLast = this.isLastPosition(newStepPosition);
        boolean isFirst = newStepPosition == 0;
        AnimationUtil.fadeViewVisibility((View)this.mNextNavigationButton, isLast ? 8 : 0, animate);
        AnimationUtil.fadeViewVisibility((View)this.mCompleteNavigationButton, !isLast ? 8 : 0, animate);
        AnimationUtil.fadeViewVisibility((View)this.mBackNavigationButton, isFirst && !this.mShowBackButtonOnFirstStep ? 8 : 0, animate);
        StepViewModel viewModel = this.mStepAdapter.getViewModel(newStepPosition);
        this.updateBackButton(viewModel);
        if (!isLast) {
            this.updateNextButton(viewModel);
        }
        this.setCompoundDrawablesForNavigationButtons(viewModel.getBackButtonStartDrawableResId(), viewModel.getNextButtonEndDrawableResId());
        this.mStepperType.showErrorStateOnBack(this.mShowErrorStateOnBack);
        this.mStepperType.onStepSelected(newStepPosition);
        this.mListener.onStepSelected(newStepPosition);
        Step step = this.mStepAdapter.findStep(this.mPager, newStepPosition);
        if (step != null) {
            step.onSelected();
        }
    }

    private void updateNextButton(@NonNull StepViewModel viewModel) {
        CharSequence nextButtonTextForStep = viewModel.getNextButtonLabel();
        if (nextButtonTextForStep == null) {
            this.mNextNavigationButton.setText(this.mNextButtonText);
        } else {
            this.mNextNavigationButton.setText(nextButtonTextForStep);
        }
    }

    private void updateBackButton(@NonNull StepViewModel viewModel) {
        CharSequence backButtonTextForStep = viewModel.getBackButtonLabel();
        if (backButtonTextForStep == null) {
            this.mBackNavigationButton.setText((CharSequence)this.mBackButtonText);
        } else {
            this.mBackNavigationButton.setText(backButtonTextForStep);
        }
    }

    public final class OnBackClickedCallback {
        @UiThread
        public final void goToPrevStep() {
            if (StepperLayout.this.mCurrentStepPosition <= 0) {
                if (StepperLayout.this.mShowBackButtonOnFirstStep) {
                    StepperLayout.this.mListener.onReturn();
                }
                return;
            }
            StepperLayout.this.mCurrentStepPosition--;
            StepperLayout.this.onUpdate(StepperLayout.this.mCurrentStepPosition, true);
        }
    }

    public final class OnNextClickedCallback {
        @UiThread
        public final void goToNextStep() {
            int totalStepCount = StepperLayout.this.mStepAdapter.getCount();
            if (StepperLayout.this.mCurrentStepPosition >= totalStepCount - 1) {
                return;
            }
            StepperLayout.this.mCurrentStepPosition++;
            StepperLayout.this.onUpdate(StepperLayout.this.mCurrentStepPosition, true);
        }
    }

    public static interface StepperListener {
        public static final StepperListener NULL = new StepperListener(){

            @Override
            public void onCompleted(View completeButton) {
            }

            @Override
            public void onError(VerificationError verificationError) {
            }

            @Override
            public void onStepSelected(int newStepPosition) {
            }

            @Override
            public void onReturn() {
            }
        };

        public void onCompleted(View var1);

        public void onError(VerificationError var1);

        public void onStepSelected(int var1);

        public void onReturn();
    }
}

