/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.widget;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.RestrictTo;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Property;
import android.view.animation.DecelerateInterpolator;
import android.widget.ProgressBar;
import com.stepstone.stepper.R;
import com.stepstone.stepper.internal.util.TintUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ColorableProgressBar
extends ProgressBar {
    private static final DecelerateInterpolator PROGRESS_ANIM_INTERPOLATOR = new DecelerateInterpolator();
    private static final int PROGRESS_ANIM_DURATION = 200;
    private static final int PROGRESS_RANGE_MULTIPLIER = 100;
    @ColorInt
    private int mProgressColor;
    @ColorInt
    private int mProgressBackgroundColor;
    private static final Property<ProgressBar, Integer> PROGRESS_PROPERTY = new Property<ProgressBar, Integer>(Integer.class, "progress"){

        public void set(ProgressBar object, Integer value) {
            object.setProgress(value.intValue());
        }

        public Integer get(ProgressBar object) {
            return object.getProgress();
        }
    };

    public ColorableProgressBar(Context context) {
        this(context, null);
    }

    public ColorableProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColorableProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mProgressColor = ContextCompat.getColor((Context)context, (int)R.color.ms_selectedColor);
        this.mProgressBackgroundColor = ContextCompat.getColor((Context)context, (int)R.color.ms_unselectedColor);
        super.setProgressDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.ms_colorable_progress_bar));
        this.updateProgressDrawable();
    }

    public void setProgressDrawable(Drawable d) {
    }

    public void setProgressDrawableTiled(Drawable d) {
    }

    public synchronized void setMax(int max) {
        super.setMax(max * 100);
    }

    public void setProgressColor(@ColorInt int progressColor) {
        this.mProgressColor = progressColor;
        this.updateProgressDrawable();
    }

    public void setProgressBackgroundColor(@ColorInt int backgroundColor) {
        this.mProgressBackgroundColor = backgroundColor;
        this.updateProgressDrawable();
    }

    public void setProgressCompat(int progress, boolean animate) {
        if (animate) {
            ObjectAnimator animator = ObjectAnimator.ofInt((Object)((Object)this), PROGRESS_PROPERTY, (int[])new int[]{this.getProgress(), progress * 100});
            animator.setDuration(200L);
            animator.setInterpolator((TimeInterpolator)PROGRESS_ANIM_INTERPOLATOR);
            animator.start();
        } else {
            this.setProgress(progress * 100);
        }
    }

    private void updateProgressDrawable() {
        LayerDrawable progressBarDrawable = (LayerDrawable)this.getProgressDrawable();
        Drawable backgroundDrawable = progressBarDrawable.findDrawableByLayerId(0x1020000);
        Drawable progressDrawable = progressBarDrawable.findDrawableByLayerId(16908301);
        TintUtil.tintDrawable(backgroundDrawable, this.mProgressBackgroundColor);
        TintUtil.tintDrawable(progressDrawable, this.mProgressColor);
    }
}

