/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.feedback;

import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.view.View;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.internal.feedback.StepperFeedbackType;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ContentFadeStepperFeedbackType
implements StepperFeedbackType {
    @NonNull
    private final View mPager;
    @FloatRange(from=0.0, to=1.0)
    private final float mFadeOutAlpha;

    public ContentFadeStepperFeedbackType(@NonNull StepperLayout stepperLayout) {
        this.mPager = stepperLayout.findViewById(R.id.ms_stepPager);
        this.mFadeOutAlpha = stepperLayout.getContentFadeAlpha();
    }

    @Override
    public void showProgress(@NonNull String progressMessage) {
        this.mPager.animate().alpha(this.mFadeOutAlpha).setDuration(200L);
    }

    @Override
    public void hideProgress() {
        this.mPager.animate().alpha(1.0f).setDuration(200L);
    }
}

