/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.CallSuper;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.graphics.drawable.AnimatedVectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.transition.TransitionManager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.stepstone.stepper.R;
import com.stepstone.stepper.VerificationError;
import com.stepstone.stepper.internal.util.ObjectsCompat;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class StepTab
extends RelativeLayout {
    private static final float ALPHA_TRANSPARENT = 0.0f;
    private static final float ALPHA_INACTIVE_STEP_TITLE = 0.54f;
    private static final float ALPHA_ACTIVE_STEP_TITLE = 0.87f;
    private static final float ALPHA_OPAQUE = 1.0f;
    private static final float HALF_SIZE_SCALE = 0.5f;
    private static final float FULL_SIZE_SCALE = 1.0f;
    @VisibleForTesting
    final TextView mStepNumberTextView;
    @VisibleForTesting
    final View mStepDivider;
    @VisibleForTesting
    final TextView mStepTitleTextView;
    @VisibleForTesting
    final TextView mStepSubtitleTextView;
    @VisibleForTesting
    final ImageView mStepDoneIndicator;
    @VisibleForTesting
    final ImageView mStepIconBackground;
    @VisibleForTesting
    CharSequence mSubtitle;
    @VisibleForTesting
    AbstractState mCurrentState = new InactiveNumberState();
    @ColorInt
    private int mUnselectedColor;
    @ColorInt
    private int mSelectedColor;
    @ColorInt
    private int mErrorColor;
    @ColorInt
    private int mTitleColor;
    @ColorInt
    private int mSubtitleColor;
    private Typeface mNormalTypeface;
    private Typeface mBoldTypeface;
    private AccelerateInterpolator mAccelerateInterpolator = new AccelerateInterpolator();

    public StepTab(Context context) {
        this(context, null);
    }

    public StepTab(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StepTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ms_step_tab, (ViewGroup)this, true);
        this.mSelectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_selectedColor);
        this.mUnselectedColor = ContextCompat.getColor((Context)context, (int)R.color.ms_unselectedColor);
        this.mErrorColor = ContextCompat.getColor((Context)context, (int)R.color.ms_errorColor);
        this.mStepNumberTextView = (TextView)this.findViewById(R.id.ms_stepNumber);
        this.mStepDoneIndicator = (ImageView)this.findViewById(R.id.ms_stepDoneIndicator);
        this.mStepIconBackground = (ImageView)this.findViewById(R.id.ms_stepIconBackground);
        this.mStepDivider = this.findViewById(R.id.ms_stepDivider);
        this.mStepTitleTextView = (TextView)this.findViewById(R.id.ms_stepTitle);
        this.mStepSubtitleTextView = (TextView)this.findViewById(R.id.ms_stepSubtitle);
        this.mTitleColor = this.mStepTitleTextView.getCurrentTextColor();
        this.mSubtitleColor = this.mStepSubtitleTextView.getCurrentTextColor();
        Typeface typeface = this.mStepTitleTextView.getTypeface();
        this.mNormalTypeface = Typeface.create((Typeface)typeface, (int)0);
        this.mBoldTypeface = Typeface.create((Typeface)typeface, (int)1);
        Drawable avd = this.createCircleToWarningDrawable();
        this.mStepIconBackground.setImageDrawable(avd);
    }

    public void toggleDividerVisibility(boolean show) {
        this.mStepDivider.setVisibility(show ? 0 : 8);
    }

    public void updateState(@Nullable VerificationError error, boolean done, boolean current, boolean showErrorMessageEnabled) {
        this.mStepTitleTextView.setTypeface(current ? this.mBoldTypeface : this.mNormalTypeface);
        if (error != null) {
            this.mCurrentState.changeToWarning(showErrorMessageEnabled ? error.getErrorMessage() : null);
        } else if (done) {
            this.mCurrentState.changeToDone();
        } else if (current) {
            this.mCurrentState.changeToActiveNumber();
        } else {
            this.mCurrentState.changeToInactiveNumber();
        }
    }

    public void setStepTitle(CharSequence title) {
        this.mStepTitleTextView.setText(title);
    }

    public void setStepSubtitle(CharSequence subtitle) {
        this.mSubtitle = subtitle;
        this.updateSubtitle(subtitle);
    }

    public void setStepNumber(CharSequence number) {
        this.mStepNumberTextView.setText(number);
    }

    public void setUnselectedColor(int unselectedColor) {
        this.mUnselectedColor = unselectedColor;
    }

    public void setSelectedColor(int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    public void setErrorColor(int errorColor) {
        this.mErrorColor = errorColor;
    }

    public void setDividerWidth(int dividerWidth) {
        this.mStepDivider.getLayoutParams().width = dividerWidth != -1 ? dividerWidth : this.getResources().getDimensionPixelOffset(R.dimen.ms_step_tab_divider_length);
    }

    private Drawable createCircleToWarningDrawable() {
        return this.createAnimatedVectorDrawable(R.drawable.ms_animated_vector_circle_to_warning_24dp);
    }

    private Drawable createWarningToCircleDrawable() {
        return this.createAnimatedVectorDrawable(R.drawable.ms_animated_vector_warning_to_circle_24dp);
    }

    public Drawable createAnimatedVectorDrawable(@DrawableRes int animatedVectorDrawableResId) {
        return AnimatedVectorDrawableCompat.create((Context)this.getContext(), (int)animatedVectorDrawableResId);
    }

    private void updateSubtitle(@Nullable CharSequence newSubtitle) {
        if (ObjectsCompat.equals(newSubtitle, this.mStepSubtitleTextView.getText())) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSubtitle) && TextUtils.isEmpty((CharSequence)newSubtitle)) {
            newSubtitle = this.mSubtitle;
        }
        this.mStepSubtitleTextView.setText(newSubtitle);
        this.mStepSubtitleTextView.setVisibility(!TextUtils.isEmpty((CharSequence)newSubtitle) ? 0 : 8);
        if (Build.VERSION.SDK_INT > 19) {
            TransitionManager.beginDelayedTransition((ViewGroup)this);
        }
    }

    @VisibleForTesting
    class WarningState
    extends AbstractState {
        WarningState() {
        }

        @Override
        protected void changeToDone() {
            this.animateViewIn((View)StepTab.this.mStepDoneIndicator);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mSelectedColor, PorterDuff.Mode.SRC_IN);
            StepTab.this.mStepTitleTextView.setTextColor(StepTab.this.mTitleColor);
            StepTab.this.mStepSubtitleTextView.setTextColor(StepTab.this.mSubtitleColor);
            super.changeToDone();
        }

        @Override
        protected void changeToInactiveNumber() {
            this.animateViewIn((View)StepTab.this.mStepNumberTextView);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mUnselectedColor, PorterDuff.Mode.SRC_IN);
            StepTab.this.mStepTitleTextView.setTextColor(StepTab.this.mTitleColor);
            StepTab.this.mStepTitleTextView.setAlpha(0.54f);
            StepTab.this.mStepSubtitleTextView.setTextColor(StepTab.this.mSubtitleColor);
            super.changeToInactiveNumber();
        }

        @Override
        protected void changeToActiveNumber() {
            this.animateViewIn((View)StepTab.this.mStepNumberTextView);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mSelectedColor, PorterDuff.Mode.SRC_IN);
            StepTab.this.mStepTitleTextView.setTextColor(StepTab.this.mTitleColor);
            StepTab.this.mStepSubtitleTextView.setTextColor(StepTab.this.mSubtitleColor);
            super.changeToActiveNumber();
        }

        private void animateViewIn(View view) {
            Drawable avd = StepTab.this.createWarningToCircleDrawable();
            StepTab.this.mStepIconBackground.setImageDrawable(avd);
            ((Animatable)avd).start();
            view.setVisibility(0);
            view.setAlpha(0.0f);
            view.setScaleX(0.5f);
            view.setScaleY(0.5f);
            view.animate().setInterpolator((TimeInterpolator)StepTab.this.mAccelerateInterpolator).alpha(1.0f).scaleX(1.0f).scaleY(1.0f);
        }
    }

    @VisibleForTesting
    class DoneState
    extends AbstractState {
        DoneState() {
        }

        @Override
        protected void changeToInactiveNumber() {
            StepTab.this.mStepDoneIndicator.setVisibility(8);
            StepTab.this.mStepNumberTextView.setVisibility(0);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mUnselectedColor, PorterDuff.Mode.SRC_IN);
            StepTab.this.mStepTitleTextView.setAlpha(0.54f);
            super.changeToInactiveNumber();
        }

        @Override
        protected void changeToActiveNumber() {
            StepTab.this.mStepDoneIndicator.setVisibility(8);
            StepTab.this.mStepNumberTextView.setVisibility(0);
            super.changeToActiveNumber();
        }

        @Override
        protected void changeToWarning(@Nullable CharSequence errorMessage) {
            Drawable avd = StepTab.this.createCircleToWarningDrawable();
            StepTab.this.mStepIconBackground.setImageDrawable(avd);
            ((Animatable)avd).start();
            super.changeToWarning(errorMessage);
        }
    }

    @VisibleForTesting
    class ActiveNumberState
    extends AbstractNumberState {
        ActiveNumberState() {
        }

        @Override
        protected void changeToInactiveNumber() {
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mUnselectedColor, PorterDuff.Mode.SRC_IN);
            StepTab.this.mStepTitleTextView.setAlpha(0.54f);
            super.changeToInactiveNumber();
        }
    }

    @VisibleForTesting
    class InactiveNumberState
    extends AbstractNumberState {
        InactiveNumberState() {
        }

        @Override
        protected void changeToInactiveNumber() {
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mUnselectedColor, PorterDuff.Mode.SRC_IN);
            StepTab.this.mStepTitleTextView.setTextColor(StepTab.this.mTitleColor);
            StepTab.this.mStepTitleTextView.setAlpha(0.54f);
            StepTab.this.mStepSubtitleTextView.setTextColor(StepTab.this.mSubtitleColor);
            super.changeToInactiveNumber();
        }

        @Override
        protected void changeToActiveNumber() {
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mSelectedColor, PorterDuff.Mode.SRC_IN);
            StepTab.this.mStepTitleTextView.setAlpha(0.87f);
            super.changeToActiveNumber();
        }

        @Override
        protected void changeToDone() {
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mSelectedColor);
            StepTab.this.mStepTitleTextView.setAlpha(0.87f);
            super.changeToDone();
        }
    }

    @VisibleForTesting
    abstract class AbstractNumberState
    extends AbstractState {
        AbstractNumberState() {
        }

        @Override
        @CallSuper
        protected void changeToWarning(@Nullable CharSequence errorMessage) {
            Drawable avd = StepTab.this.createCircleToWarningDrawable();
            StepTab.this.mStepIconBackground.setImageDrawable(avd);
            ((Animatable)avd).start();
            super.changeToWarning(errorMessage);
        }

        @Override
        @CallSuper
        protected void changeToDone() {
            StepTab.this.mStepDoneIndicator.setVisibility(0);
            StepTab.this.mStepNumberTextView.setVisibility(8);
            super.changeToDone();
        }
    }

    @VisibleForTesting
    abstract class AbstractState {
        AbstractState() {
        }

        @CallSuper
        protected void changeToInactiveNumber() {
            StepTab.this.updateSubtitle(StepTab.this.mSubtitle);
            StepTab.this.mCurrentState = new InactiveNumberState();
        }

        @CallSuper
        protected void changeToActiveNumber() {
            StepTab.this.updateSubtitle(StepTab.this.mSubtitle);
            StepTab.this.mCurrentState = new ActiveNumberState();
        }

        @CallSuper
        protected void changeToDone() {
            StepTab.this.updateSubtitle(StepTab.this.mSubtitle);
            StepTab.this.mCurrentState = new DoneState();
        }

        @CallSuper
        protected void changeToWarning(@Nullable CharSequence errorMessage) {
            StepTab.this.mStepDoneIndicator.setVisibility(8);
            StepTab.this.mStepNumberTextView.setVisibility(8);
            StepTab.this.mStepIconBackground.setColorFilter(StepTab.this.mErrorColor, PorterDuff.Mode.SRC_IN);
            StepTab.this.mStepTitleTextView.setTextColor(StepTab.this.mErrorColor);
            StepTab.this.mStepSubtitleTextView.setTextColor(StepTab.this.mErrorColor);
            StepTab.this.updateSubtitle(errorMessage);
            StepTab.this.mCurrentState = new WarningState();
        }
    }
}

