/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.util;

import android.animation.Animator;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.view.View;
import android.view.ViewPropertyAnimator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class AnimationUtil {
    public static final float ALPHA_OPAQUE = 1.0f;
    public static final float ALPHA_INVISIBLE = 0.0f;
    public static final float ALPHA_HALF = 0.5f;
    private static final int DEFAULT_DURATION = 300;

    private AnimationUtil() {
        throw new AssertionError((Object)"Please do not instantiate this class");
    }

    public static void fadeViewVisibility(final @NonNull View view, final int visibility, boolean animate) {
        ViewPropertyAnimator animator = view.animate();
        animator.cancel();
        animator.alpha(visibility == 0 ? 1.0f : 0.0f).setDuration(animate ? 300L : 0L).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(@NonNull Animator animation) {
                if (visibility == 0) {
                    view.setVisibility(visibility);
                }
            }

            public void onAnimationEnd(@NonNull Animator animation) {
                if (visibility == 4 || visibility == 8) {
                    view.setVisibility(visibility);
                }
            }

            public void onAnimationCancel(@NonNull Animator animation) {
                if (visibility == 4 || visibility == 8) {
                    view.setVisibility(visibility);
                }
            }

            public void onAnimationRepeat(@NonNull Animator animation) {
            }
        }).start();
    }
}

