/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.internal.feedback;

import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.view.View;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.internal.feedback.StepperFeedbackType;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ContentOverlayStepperFeedbackType
implements StepperFeedbackType {
    @NonNull
    private final View mOverlayView;

    public ContentOverlayStepperFeedbackType(@NonNull StepperLayout stepperLayout) {
        this.mOverlayView = stepperLayout.findViewById(R.id.ms_stepPagerOverlay);
        this.mOverlayView.setVisibility(0);
        this.mOverlayView.setAlpha(0.0f);
        int contentOverlayBackground = stepperLayout.getContentOverlayBackground();
        if (contentOverlayBackground != 0) {
            this.mOverlayView.setBackgroundResource(contentOverlayBackground);
        }
    }

    @Override
    public void showProgress(@NonNull String progressMessage) {
        this.mOverlayView.animate().alpha(1.0f).setDuration(200L);
    }

    @Override
    public void hideProgress() {
        this.mOverlayView.animate().alpha(0.0f).setDuration(200L);
    }
}

