/*
 * Decompiled with CFR 0.152.
 */
package com.stepstone.stepper.test;

import android.support.annotation.IntRange;
import android.support.test.espresso.Espresso;
import android.support.test.espresso.IdlingResource;
import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.matcher.ViewMatchers;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import com.stepstone.stepper.R;
import com.stepstone.stepper.StepperLayout;
import com.stepstone.stepper.internal.widget.StepTab;
import com.stepstone.stepper.test.idling.CustomViewPagerListener;
import org.hamcrest.Matcher;

public class StepperNavigationActions {
    public static ViewAction clickNext() {
        return new AbstractStepperNavigationAction(){

            public String getDescription() {
                return "Click on the Next button";
            }

            @Override
            protected void performAction(StepperLayout stepperLayout) {
                View nextButton = stepperLayout.findViewById(R.id.ms_stepNextButton);
                nextButton.performClick();
            }
        };
    }

    public static ViewAction clickBack() {
        return new AbstractStepperNavigationAction(){

            public String getDescription() {
                return "Click on the Back button";
            }

            @Override
            protected void performAction(StepperLayout stepperLayout) {
                View backButton = stepperLayout.findViewById(R.id.ms_stepPrevButton);
                backButton.performClick();
            }
        };
    }

    public static ViewAction clickComplete() {
        return new AbstractStepperNavigationAction(){

            public String getDescription() {
                return "Click on the Complete button";
            }

            @Override
            protected void performAction(StepperLayout stepperLayout) {
                View completeButton = stepperLayout.findViewById(R.id.ms_stepCompleteButton);
                completeButton.performClick();
            }
        };
    }

    public static ViewAction clickTabAtPosition(final @IntRange(from=0L) int tabPosition) {
        return new AbstractStepperNavigationAction(){

            public String getDescription() {
                return "Click on tab at position: " + tabPosition;
            }

            @Override
            protected void performAction(StepperLayout stepperLayout) {
                ViewGroup tabsContainer = (ViewGroup)stepperLayout.findViewById(R.id.ms_stepTabsInnerContainer);
                int childCount = tabsContainer.getChildCount();
                if (childCount == 0) {
                    throw new IllegalArgumentException("No tabs found!");
                }
                if (tabPosition < 0 || tabPosition >= childCount) {
                    throw new IllegalArgumentException("Invalid tab position: " + tabPosition);
                }
                StepTab stepTab = (StepTab)tabsContainer.getChildAt(tabPosition);
                stepTab.performClick();
            }
        };
    }

    private static abstract class AbstractStepperNavigationAction
    implements ViewAction {
        private AbstractStepperNavigationAction() {
        }

        public final Matcher<View> getConstraints() {
            return ViewMatchers.isDisplayed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void perform(UiController uiController, View view) {
            StepperLayout stepperLayout = (StepperLayout)view;
            ViewPager viewPager = (ViewPager)stepperLayout.findViewById(R.id.ms_stepPager);
            CustomViewPagerListener customListener = new CustomViewPagerListener();
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)customListener);
            try {
                Espresso.registerIdlingResources((IdlingResource[])new IdlingResource[]{customListener});
                uiController.loopMainThreadUntilIdle();
                this.performAction(stepperLayout);
                uiController.loopMainThreadUntilIdle();
                customListener.mNeedsIdle = true;
                uiController.loopMainThreadUntilIdle();
                customListener.mNeedsIdle = false;
            }
            catch (Throwable throwable) {
                Espresso.unregisterIdlingResources((IdlingResource[])new IdlingResource[]{customListener});
                viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)customListener);
                throw throwable;
            }
            Espresso.unregisterIdlingResources((IdlingResource[])new IdlingResource[]{customListener});
            viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)customListener);
        }

        protected abstract void performAction(StepperLayout var1);
    }
}

