/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenvinouze.shapetextdrawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import com.github.stephenvinouze.shapetextdrawable.ShapeForm;
import com.github.stephenvinouze.shapetextdrawable.ShapeTextDrawable$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bi\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0005H\u0016J\u0012\u0010'\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/github/stephenvinouze/shapetextdrawable/ShapeTextDrawable;", "Landroid/graphics/drawable/ShapeDrawable;", "shapeForm", "Lcom/github/stephenvinouze/shapetextdrawable/ShapeForm;", "color", "", "radius", "", "text", "", "textColor", "textBold", "", "textFont", "Landroid/graphics/Typeface;", "textSize", "borderColor", "borderThickness", "(Lcom/github/stephenvinouze/shapetextdrawable/ShapeForm;IFLjava/lang/String;IZLandroid/graphics/Typeface;III)V", "borderPaint", "Landroid/graphics/Paint;", "getBorderThickness", "()I", "getRadius", "()F", "getText", "()Ljava/lang/String;", "textPaint", "getTextSize", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawBorder", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "setAlpha", "alpha", "setColorFilter", "cf", "Landroid/graphics/ColorFilter;", "shapetextdrawable-compileReleaseKotlin"})
public final class ShapeTextDrawable
extends ShapeDrawable {
    @NotNull
    private final String text;
    private final int textSize;
    private final int borderThickness;
    private final float radius;
    private final Paint textPaint;
    private final Paint borderPaint;

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final int getTextSize() {
        return this.textSize;
    }

    public final int getBorderThickness() {
        return this.borderThickness;
    }

    public final float getRadius() {
        return this.radius;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.draw(canvas);
        Rect r = this.getBounds();
        if (this.borderThickness > 0) {
            this.drawBorder(canvas);
        }
        int count = canvas.save();
        canvas.translate((float)r.left, (float)r.top);
        int fontSize = this.textSize < 0 ? Math.min(r.width(), r.height()) / 2 : this.textSize;
        this.textPaint.setTextSize((float)fontSize);
        canvas.drawText(this.text, (float)(r.width() / 2), (float)(r.height() / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / (float)2, this.textPaint);
        canvas.restoreToCount(count);
    }

    private final void drawBorder(Canvas canvas) {
        RectF rect = new RectF(this.getBounds());
        rect.inset((float)(this.borderThickness / 2), (float)(this.borderThickness / 2));
        if (this.getShape() instanceof OvalShape) {
            canvas.drawOval(rect, this.borderPaint);
        } else if (this.getShape() instanceof RoundRectShape) {
            canvas.drawRoundRect(rect, this.radius, this.radius, this.borderPaint);
        } else {
            canvas.drawRect(rect, this.borderPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter cf) {
        this.textPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return -1;
    }

    public int getIntrinsicHeight() {
        return -1;
    }

    public ShapeTextDrawable(@NotNull ShapeForm shapeForm, int color, float radius, @NotNull String text, int textColor, boolean textBold, @NotNull Typeface textFont, int textSize, int borderColor, int borderThickness) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)shapeForm), (String)"shapeForm");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)textFont, (String)"textFont");
        this.text = text;
        this.textSize = textSize;
        this.borderThickness = borderThickness;
        this.radius = radius;
        this.getPaint().setColor(color);
        this.textPaint = new Paint(1);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setColor(textColor);
        this.textPaint.setFakeBoldText(textBold);
        this.textPaint.setTypeface(textFont);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setStrokeWidth((float)borderThickness);
        this.borderPaint = new Paint(1);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setColor(borderColor);
        this.borderPaint.setStrokeWidth((float)borderThickness);
        switch (ShapeTextDrawable$WhenMappings.$EnumSwitchMapping$0[shapeForm.ordinal()]) {
            case 1: {
                this.setShape((Shape)new OvalShape());
                break;
            }
            case 2: {
                if (radius > 0.0f) {
                    float[] radii = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
                    this.setShape((Shape)new RoundRectShape(radii, (RectF)null, (float[])null));
                    break;
                }
                this.setShape((Shape)new RectShape());
            }
        }
    }

    public /* synthetic */ ShapeTextDrawable(ShapeForm shapeForm, int n, float f, String string, int n2, boolean bl, Typeface typeface, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 2) != 0) {
            n = -7829368;
        }
        if ((n6 & 4) != 0) {
            f = 0.0f;
        }
        if ((n6 & 8) != 0) {
            string = "";
        }
        if ((n6 & 0x10) != 0) {
            n2 = -1;
        }
        if ((n6 & 0x20) != 0) {
            bl = false;
        }
        if ((n6 & 0x40) != 0) {
            Typeface typeface2 = Typeface.create((String)"sans-serif-light", (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeface2, (String)"Typeface.create(\"sans-se\u2026-light\", Typeface.NORMAL)");
            typeface = typeface2;
        }
        if ((n6 & 0x80) != 0) {
            n3 = -1;
        }
        if ((n6 & 0x100) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x200) != 0) {
            n5 = 0;
        }
        this(shapeForm, n, f, string, n2, bl, typeface, n3, n4, n5);
    }
}

