/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.udflib;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDFImageBuilderFile
implements Comparable<UDFImageBuilderFile> {
    private String identifier = null;
    private File sourceFile = null;
    private ArrayList<UDFImageBuilderFile> childs = new ArrayList();
    private FileType fileType;
    private Calendar AccessTime;
    private Calendar AttributeTime;
    private Calendar CreationTime;
    private Calendar ModificationTime;
    private int FileLinkCount = 1;
    private UDFImageBuilderFile parent;

    public UDFImageBuilderFile(File sourceFile) throws Exception {
        this.identifier = sourceFile.getName();
        this.sourceFile = sourceFile;
        this.AccessTime = Calendar.getInstance();
        this.AttributeTime = Calendar.getInstance();
        this.AttributeTime.setTimeInMillis(sourceFile.lastModified());
        this.CreationTime = Calendar.getInstance();
        this.CreationTime.setTimeInMillis(sourceFile.lastModified());
        this.ModificationTime = Calendar.getInstance();
        this.ModificationTime.setTimeInMillis(sourceFile.lastModified());
        if (sourceFile.isDirectory()) {
            this.fileType = FileType.Directory;
            File[] childFiles = sourceFile.listFiles();
            for (int i = 0; i < childFiles.length; ++i) {
                this.addChild(childFiles[i]);
            }
        } else {
            this.fileType = FileType.File;
        }
    }

    public UDFImageBuilderFile(String directoryIdentifier) {
        this.AccessTime = Calendar.getInstance();
        this.AttributeTime = Calendar.getInstance();
        this.CreationTime = Calendar.getInstance();
        this.ModificationTime = Calendar.getInstance();
        this.identifier = directoryIdentifier;
        this.fileType = FileType.Directory;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void addChild(UDFImageBuilderFile childUDFImageBuilderFile) throws Exception {
        if (this.fileType != FileType.Directory) {
            throw new Exception("error: trying to add child file to non-directory file");
        }
        if (this.getChild(childUDFImageBuilderFile.identifier) != null) {
            throw new Exception("error: trying to add child file with an already existing identifer");
        }
        if (childUDFImageBuilderFile.getFileType() == FileType.Directory) {
            ++this.FileLinkCount;
        }
        childUDFImageBuilderFile.setParent(this);
        this.childs.add(childUDFImageBuilderFile);
    }

    public void addChild(File childFile) throws Exception {
        if (this.fileType != FileType.Directory) {
            throw new Exception("error: trying to add child file to non-directory file");
        }
        if (this.getChild(childFile.getName()) != null) {
            throw new Exception("error: trying to add child file with an already existing identifer");
        }
        UDFImageBuilderFile childUDFImageBuilderFile = new UDFImageBuilderFile(childFile);
        if (childUDFImageBuilderFile.getFileType() == FileType.Directory) {
            ++this.FileLinkCount;
        }
        childUDFImageBuilderFile.setParent(this);
        this.childs.add(childUDFImageBuilderFile);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getFileLinkCount() {
        return this.FileLinkCount;
    }

    @Override
    public int compareTo(UDFImageBuilderFile myUDFImageBuilderFile) {
        return this.identifier.compareTo(myUDFImageBuilderFile.identifier);
    }

    public void removeChild(String identifier) {
        for (int i = 0; i < this.childs.size(); ++i) {
            UDFImageBuilderFile myUDFImageBuilderFile = this.childs.get(i);
            if (myUDFImageBuilderFile.identifier != identifier) continue;
            this.childs.remove(i);
            break;
        }
    }

    public UDFImageBuilderFile getChild(String identifier) {
        for (int i = 0; i < this.childs.size(); ++i) {
            UDFImageBuilderFile myUDFImageBuilderFile = this.childs.get(i);
            if (myUDFImageBuilderFile.identifier != identifier) continue;
            return myUDFImageBuilderFile;
        }
        return null;
    }

    public UDFImageBuilderFile[] getChilds() {
        Collections.sort(this.childs);
        return this.childs.toArray(new UDFImageBuilderFile[this.childs.size()]);
    }

    public Calendar getModificationTime() {
        return this.ModificationTime;
    }

    public Calendar getAccessTime() {
        return this.AccessTime;
    }

    public Calendar getCreationTime() {
        return this.CreationTime;
    }

    public Calendar getAttributeTime() {
        return this.AttributeTime;
    }

    public long getFileLength() {
        if (this.sourceFile != null) {
            return this.sourceFile.length();
        }
        return 0L;
    }

    public void readFileData(byte[] buffer) throws IOException {
        if (this.sourceFile != null) {
            RandomAccessFile sourceRandomAccessFile = new RandomAccessFile(this.sourceFile, "r");
            sourceRandomAccessFile.read(buffer);
            sourceRandomAccessFile.close();
        }
    }

    public long getDirectoryCount() {
        long directoryCount = 0L;
        if (this.fileType == FileType.Directory) {
            ++directoryCount;
            for (int i = 0; i < this.childs.size(); ++i) {
                UDFImageBuilderFile childUDFImageBuilderFile = this.childs.get(i);
                if (childUDFImageBuilderFile.getFileType() != FileType.Directory) continue;
                directoryCount += childUDFImageBuilderFile.getDirectoryCount();
            }
        }
        return directoryCount;
    }

    public long getFileCount() {
        long fileCount = 0L;
        if (this.fileType == FileType.Directory) {
            for (int i = 0; i < this.childs.size(); ++i) {
                UDFImageBuilderFile childUDFImageBuilderFile = this.childs.get(i);
                if (childUDFImageBuilderFile.getFileType() == FileType.Directory) {
                    fileCount += childUDFImageBuilderFile.getFileCount();
                    continue;
                }
                if (childUDFImageBuilderFile.getFileType() != FileType.File) continue;
                ++fileCount;
            }
        } else if (this.fileType == FileType.File) {
            fileCount = 1L;
        }
        return fileCount;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public UDFImageBuilderFile getParent() {
        return this.parent;
    }

    public void setParent(UDFImageBuilderFile parent) {
        this.parent = parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        File,
        Directory;

    }
}

