/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.udflib.handler;

import com.github.stephenc.javaisotools.sabre.ContentHandler;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StructureHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteArrayDataReference;
import com.github.stephenc.javaisotools.sabre.impl.ChainingStreamHandler;

public class PaddingHandler
extends ChainingStreamHandler {
    private int blockSize = 2048;
    private long currentPosition = 0L;

    public PaddingHandler(StructureHandler myStructureHandler, ContentHandler myContentHandler) {
        super(myStructureHandler, myContentHandler);
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void data(DataReference myDataReference) throws HandlerException {
        this.currentPosition += myDataReference.getLength();
        super.data(myDataReference);
    }

    public void endElement() throws HandlerException {
        if (this.currentPosition % (long)this.blockSize != 0L) {
            int paddingLength = this.blockSize - (int)(this.currentPosition % (long)this.blockSize);
            super.data(new ByteArrayDataReference(new byte[paddingLength]));
            this.currentPosition += (long)paddingLength;
        }
        super.endElement();
    }
}

