/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.github.stephenc.javaisotools.loopfs.util.LittleEndian;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntryIterator
implements Iterator<Iso9660FileEntry> {
    private final Iso9660FileSystem fileSystem;
    private final List<Iso9660FileEntry> queue;

    public EntryIterator(Iso9660FileSystem fileSystem, Iso9660FileEntry rootEntry) {
        this.fileSystem = fileSystem;
        this.queue = new LinkedList<Iso9660FileEntry>();
        if (rootEntry != null) {
            this.queue.add(rootEntry);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public Iso9660FileEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Iso9660FileEntry entry = this.queue.remove(0);
        if (entry.isDirectory()) {
            byte[] content;
            try {
                content = this.fileSystem.getBytes(entry);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            int offset = 0;
            boolean paddingMode = false;
            while (offset < content.length) {
                if (LittleEndian.getUInt8((byte[])content, (int)offset) <= 0) {
                    paddingMode = true;
                    offset += 2;
                    continue;
                }
                Iso9660FileEntry child = new Iso9660FileEntry(this.fileSystem, entry.getPath(), content, offset + 1);
                if (paddingMode && child.getSize() < 0L) continue;
                offset += child.getEntryLength();
                if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                this.queue.add(child);
            }
        }
        return entry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

