/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660.impl;

import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.LayoutHelper;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Constants;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660ShortDateDataReference;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothShortDataReference;
import com.github.stephenc.javaisotools.iso9660.sabre.impl.BothWordDataReference;
import com.github.stephenc.javaisotools.sabre.DataReference;
import com.github.stephenc.javaisotools.sabre.Fixup;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import com.github.stephenc.javaisotools.sabre.impl.ByteDataReference;
import java.util.Date;
import java.util.HashMap;

public class ISO9660DirectoryRecord {
    private StreamHandler streamHandler;
    private int volSeqNo;
    private DataReference filenameDataReference;
    public boolean hide;
    public boolean isDirectory;

    public ISO9660DirectoryRecord(StreamHandler streamHandler, ISO9660File file, LayoutHelper helper) throws HandlerException {
        this.init(streamHandler, helper);
        this.filenameDataReference = helper.getFilenameDataReference(file);
        this.isDirectory = false;
    }

    public ISO9660DirectoryRecord(StreamHandler streamHandler, ISO9660Directory dir, LayoutHelper helper) throws HandlerException {
        this.init(streamHandler, helper);
        this.filenameDataReference = helper.getFilenameDataReference(dir);
    }

    public ISO9660DirectoryRecord(StreamHandler streamHandler, Object object, ISO9660Directory dir, LayoutHelper helper) throws HandlerException {
        this.init(streamHandler, helper);
        if (object == ISO9660Constants.FI_ROOT) {
            this.filenameDataReference = new ByteDataReference(0L);
        } else if (object == ISO9660Constants.FI_DOT) {
            this.filenameDataReference = new ByteDataReference(0L);
        } else if (object == ISO9660Constants.FI_DOTDOT) {
            this.filenameDataReference = new ByteDataReference(1L);
        } else {
            throw new HandlerException("Unknown special directory type, neither ROOT nor DOT nor DOTDOT: " + object);
        }
    }

    private void init(StreamHandler streamHandler, LayoutHelper helper) {
        this.streamHandler = streamHandler;
        this.volSeqNo = 1;
        this.hide = false;
        this.isDirectory = true;
    }

    public void setVolSeqNo(int value) {
        this.volSeqNo = value;
    }

    public void hide() {
        this.hide = true;
    }

    public HashMap doDR() throws HandlerException {
        HashMap<String, Object> memory = new HashMap<String, Object>();
        int length = 0;
        Fixup drLength = this.streamHandler.fixup((DataReference)new ByteDataReference(0L));
        memory.put("drLengthFixup", drLength);
        ++length;
        Fixup extAttrRecordLengthFixup = this.streamHandler.fixup((DataReference)new ByteDataReference(0L));
        memory.put("drExtAttrRecordLengthFixup", extAttrRecordLengthFixup);
        ++length;
        Fixup locationFixup = this.streamHandler.fixup((DataReference)new BothWordDataReference(0L));
        memory.put("drLocationFixup", locationFixup);
        length += 8;
        Fixup dataLengthFixup = this.streamHandler.fixup((DataReference)new BothWordDataReference(0L));
        memory.put("drDataLengthFixup", dataLengthFixup);
        length += 8;
        Date now = new Date();
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(now);
        this.streamHandler.data((DataReference)date);
        length = (int)((long)length + date.getLength());
        byte fileFlags = this.getFileFlags();
        this.streamHandler.data((DataReference)new ByteDataReference((long)fileFlags));
        ++length;
        this.streamHandler.data((DataReference)new ByteDataReference(0L));
        ++length;
        this.streamHandler.data((DataReference)new ByteDataReference(0L));
        ++length;
        this.streamHandler.data((DataReference)new BothShortDataReference(this.volSeqNo));
        length += 4;
        this.streamHandler.data((DataReference)new ByteDataReference(this.filenameDataReference.getLength()));
        ++length;
        this.streamHandler.data(this.filenameDataReference);
        length = (int)((long)length + this.filenameDataReference.getLength());
        if (this.filenameDataReference.getLength() % 2L == 0L) {
            this.streamHandler.data((DataReference)new ByteDataReference(0L));
            ++length;
        }
        memory.put("drLength", new Integer(length));
        return memory;
    }

    private byte getFileFlags() {
        byte flags = 0;
        if (this.hide) {
            flags = (byte)(flags | 1);
        }
        if (this.isDirectory) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }
}

