/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.iso9660;

import com.github.stephenc.javaisotools.iso9660.FilenameDataReference;
import com.github.stephenc.javaisotools.iso9660.ISO9660Directory;
import com.github.stephenc.javaisotools.iso9660.ISO9660File;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.NamingConventions;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;

public abstract class LayoutHelper {
    private StreamHandler streamHandler;
    private ISO9660RootDirectory root;
    private NamingConventions namingConventions;

    public LayoutHelper(StreamHandler streamHandler, ISO9660RootDirectory root, NamingConventions namingConventions) {
        this.streamHandler = streamHandler;
        this.root = root;
        this.namingConventions = namingConventions;
    }

    public ISO9660RootDirectory getRoot() {
        return this.root;
    }

    public int getCurrentLocation() throws HandlerException {
        long position = this.streamHandler.mark();
        int location = (int)(position / 2048L);
        return location;
    }

    public int getDifferenceTo(long position) throws HandlerException {
        return (int)(this.streamHandler.mark() - position);
    }

    public NamingConventions getNamingConventions() {
        return this.namingConventions;
    }

    public abstract FilenameDataReference getFilenameDataReference(ISO9660Directory var1) throws HandlerException;

    public abstract FilenameDataReference getFilenameDataReference(ISO9660File var1) throws HandlerException;

    public abstract byte[] pad(String var1, int var2) throws HandlerException;
}

