/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.maven;

import com.github.stephenc.javaisotools.eltorito.impl.ElToritoConfig;
import com.github.stephenc.javaisotools.iso9660.ConfigException;
import com.github.stephenc.javaisotools.iso9660.ISO9660RootDirectory;
import com.github.stephenc.javaisotools.iso9660.StandardConfig;
import com.github.stephenc.javaisotools.iso9660.impl.CreateISO;
import com.github.stephenc.javaisotools.iso9660.impl.ISO9660Config;
import com.github.stephenc.javaisotools.iso9660.impl.ISOImageFileHandler;
import com.github.stephenc.javaisotools.joliet.impl.JolietConfig;
import com.github.stephenc.javaisotools.rockridge.impl.RockRidgeConfig;
import com.github.stephenc.javaisotools.sabre.HandlerException;
import com.github.stephenc.javaisotools.sabre.StreamHandler;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class PackageMojo
extends AbstractMojo {
    private File outputDirectory;
    private File inputDirectory;
    private String finalName;
    private String systemId;
    private String volumeId;
    private String volumeSetId;
    private String publisher;
    private String preparer;
    private String application;
    private String movedDirectoriesStoreName;
    private Integer volumeSequenceNumber;
    private Integer volumeSetSize;
    private MavenProject project;
    private Boolean enableRockRidge;
    private Boolean enableJoliet;
    private Boolean allowASCII;
    private Integer interchangeLevel;
    private Boolean padEnd;
    private Boolean restrictDirDepthTo8;
    private Boolean forceDotDelimiter;
    private Boolean mkisofsCompatibility;
    private Boolean hideMovedDirectoriesStore;
    private Boolean forcePortableFilenameCharacterSet;
    private String bootImagePlatformID;
    private String bootImageEmulation;
    private File bootImage;
    private String bootImageID;
    private Integer bootImageSectorCount;
    private Integer bootImageLoadSegment;
    private boolean genBootInfoTable;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputDirectory.isFile()) {
            throw new MojoExecutionException("Output directory: " + this.outputDirectory + " is a file");
        }
        this.outputDirectory.mkdirs();
        if (!this.outputDirectory.isDirectory()) {
            throw new MojoExecutionException("Could not create output directory: " + this.outputDirectory);
        }
        ISO9660RootDirectory.MOVED_DIRECTORIES_STORE_NAME = this.movedDirectoriesStoreName;
        ISO9660RootDirectory root = new ISO9660RootDirectory();
        File isoFile = new File(this.outputDirectory, this.finalName);
        try {
            if (this.inputDirectory.isDirectory()) {
                root.addContentsRecursively(this.inputDirectory);
            }
            ISOImageFileHandler streamHandler = new ISOImageFileHandler(isoFile);
            CreateISO iso = new CreateISO((StreamHandler)streamHandler, root);
            ISO9660Config iso9660Config = new ISO9660Config();
            iso9660Config.allowASCII(this.allowASCII.booleanValue());
            iso9660Config.setInterchangeLevel(this.interchangeLevel.intValue());
            iso9660Config.restrictDirDepthTo8(this.restrictDirDepthTo8.booleanValue());
            iso9660Config.forceDotDelimiter(this.forceDotDelimiter.booleanValue());
            iso9660Config.setInterchangeLevel(this.interchangeLevel.intValue());
            iso9660Config.setPadEnd(this.padEnd.booleanValue());
            this.applyConfig((StandardConfig)iso9660Config);
            RockRidgeConfig rrConfig = null;
            if (this.enableRockRidge.booleanValue()) {
                rrConfig = new RockRidgeConfig();
                rrConfig.setMkisofsCompatibility(this.mkisofsCompatibility.booleanValue());
                rrConfig.hideMovedDirectoriesStore(this.hideMovedDirectoriesStore.booleanValue());
                rrConfig.forcePortableFilenameCharacterSet(this.forcePortableFilenameCharacterSet.booleanValue());
            }
            JolietConfig jolietConfig = null;
            if (this.enableJoliet.booleanValue()) {
                jolietConfig = new JolietConfig();
                jolietConfig.forceDotDelimiter(this.forceDotDelimiter.booleanValue());
                this.applyConfig((StandardConfig)jolietConfig);
            }
            ElToritoConfig elToritoConfig = null;
            if (this.bootImage != null) {
                this.getLog().info((CharSequence)"El Torito support enabled.");
                elToritoConfig = new ElToritoConfig(this.bootImage, this.getBootEmulation(), this.getBootPlatformID(), this.bootImageID, this.bootImageSectorCount.intValue(), this.bootImageLoadSegment.intValue());
                elToritoConfig.setGenBootInfoTable(this.genBootInfoTable);
            }
            iso.process(iso9660Config, rrConfig, jolietConfig, elToritoConfig);
        }
        catch (HandlerException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ConfigException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.project.getArtifact().setFile(isoFile);
    }

    private void applyConfig(StandardConfig config) throws ConfigException {
        if (StringUtils.isNotEmpty((String)this.systemId)) {
            config.setSystemID(this.systemId);
        }
        if (StringUtils.isNotEmpty((String)this.volumeId)) {
            config.setVolumeID(this.volumeId);
        }
        if (StringUtils.isNotEmpty((String)this.volumeSetId)) {
            config.setVolumeSetID(this.volumeSetId);
        }
        if (StringUtils.isNotEmpty((String)this.publisher)) {
            config.setPublisher(this.publisher);
        }
        if (StringUtils.isNotEmpty((String)this.preparer)) {
            config.setDataPreparer(this.preparer);
        }
        if (StringUtils.isNotEmpty((String)this.application)) {
            config.setApp(this.application);
        }
    }

    private int getBootEmulation() {
        if (this.bootImageEmulation.matches(".*1.*2.*")) {
            return ElToritoConfig.BOOT_MEDIA_TYPE_1_2MEG_DISKETTE;
        }
        if (this.bootImageEmulation.matches(".*44.*")) {
            return ElToritoConfig.BOOT_MEDIA_TYPE_1_44MEG_DISKETTE;
        }
        if (this.bootImageEmulation.matches(".*88.*")) {
            return ElToritoConfig.BOOT_MEDIA_TYPE_2_88MEG_DISKETTE;
        }
        if (this.bootImageEmulation.matches(".*(hd|hard).*")) {
            return ElToritoConfig.BOOT_MEDIA_TYPE_HD;
        }
        return ElToritoConfig.BOOT_MEDIA_TYPE_NO_EMU;
    }

    private int getBootPlatformID() {
        if (this.bootImagePlatformID.equalsIgnoreCase("mac") || this.bootImagePlatformID.equalsIgnoreCase("macintosh") || this.bootImagePlatformID.equalsIgnoreCase("apple")) {
            return ElToritoConfig.PLATFORM_ID_MAC;
        }
        if (this.bootImagePlatformID.equalsIgnoreCase("ppc") || this.bootImagePlatformID.equalsIgnoreCase("powerpc")) {
            return ElToritoConfig.PLATFORM_ID_PPC;
        }
        if (this.bootImagePlatformID.equalsIgnoreCase("efi")) {
            return ElToritoConfig.PLATFORM_ID_EFI;
        }
        return ElToritoConfig.PLATFORM_ID_X86;
    }
}

