/**
 * 
 */
package com.eaio.servlet;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

/**
 * Sets <code>Cache-Control</code> to <code>private, no-store</code>.
 * 
 * @author <a href="mailto:jb&#64;eaio.com">Johann Burkard</a>
 * @version $Id: PrivateNoStoreFilter.java 5084 2012-08-09 19:11:04Z johann $
 */
public class PrivateNoStoreFilter implements Filter {

    /**
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy() {
    // Empty.
    }

    /**
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse,
     * javax.servlet.FilterChain)
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException,
            ServletException {
        ((HttpServletResponse) res).setHeader("Cache-Control", "private, no-store");
        chain.doFilter(req, res);
    }

    /**
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    public void init(FilterConfig config) {
    // Empty.
    }

}
