/*
 * Decompiled with CFR 0.152.
 */
package toothpick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Provider;
import toothpick.Factory;
import toothpick.InternalProvider;
import toothpick.InternalScopedProvider;
import toothpick.Lazy;
import toothpick.Scope;
import toothpick.ScopeNode;
import toothpick.ThreadSafeProviderImpl;
import toothpick.Toothpick;
import toothpick.config.Binding;
import toothpick.config.Module;
import toothpick.configuration.ConfigurationHolder;
import toothpick.configuration.IllegalBindingException;
import toothpick.locators.FactoryLocator;

public class ScopeImpl
extends ScopeNode {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final IdentityHashMap<Class, InternalProvider> mapClassesToUnNamedUnScopedProviders = new IdentityHashMap();
    final IdentityHashMap<Class, Map<String, InternalScopedProvider>> mapClassesToNamedScopedProviders = new IdentityHashMap();
    final IdentityHashMap<Class, InternalScopedProvider> mapClassesToUnNamedScopedProviders = new IdentityHashMap();
    private boolean hasTestModules;

    public ScopeImpl(Object name) {
        super(name);
        this.installBindingForScopeClass();
    }

    public <T> T getInstance(Class<T> clazz) {
        return this.getInstance(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInstance(Class<T> clazz, String name) {
        T t;
        this.crashIfClosed();
        ConfigurationHolder.configuration.checkCyclesStart(clazz, name);
        try {
            t = this.lookupProvider(clazz, name).get(this);
        }
        finally {
            ConfigurationHolder.configuration.checkCyclesEnd(clazz, name);
        }
        return t;
    }

    public <T> Provider<T> getProvider(Class<T> clazz) {
        return this.getProvider(clazz, null);
    }

    public <T> Provider<T> getProvider(Class<T> clazz, String name) {
        this.crashIfClosed();
        return new ThreadSafeProviderImpl<T>(this, clazz, name, false);
    }

    public <T> Lazy<T> getLazy(Class<T> clazz) {
        return this.getLazy(clazz, null);
    }

    public <T> Lazy<T> getLazy(Class<T> clazz, String name) {
        this.crashIfClosed();
        return new ThreadSafeProviderImpl<T>(this, clazz, name, true);
    }

    public synchronized Scope installTestModules(Module ... modules) {
        if (this.hasTestModules) {
            throw new IllegalStateException("TestModules can only be installed once per scope.");
        }
        this.installModules(true, modules);
        this.hasTestModules = true;
        return this;
    }

    public Scope installModules(Module ... modules) {
        this.installModules(false, modules);
        return this;
    }

    public void inject(Object obj) {
        Toothpick.inject(obj, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList<Class> sortedScopedProviderClassesList;
        String branch = "---";
        int lastNode = 92;
        int node = 43;
        String indent = "    ";
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append(':');
        builder.append(System.identityHashCode(this));
        builder.append(LINE_SEPARATOR);
        builder.append("Providers: [");
        Object object = this.mapClassesToNamedScopedProviders;
        synchronized (object) {
            sortedScopedProviderClassesList = new ArrayList<Class>(this.mapClassesToNamedScopedProviders.keySet());
        }
        object = this.mapClassesToUnNamedScopedProviders;
        synchronized (object) {
            sortedScopedProviderClassesList.addAll(this.mapClassesToUnNamedScopedProviders.keySet());
        }
        Collections.sort(sortedScopedProviderClassesList, new ClassNameComparator());
        for (Class aClass : sortedScopedProviderClassesList) {
            builder.append(aClass.getName());
            builder.append(',');
        }
        if (!sortedScopedProviderClassesList.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(']');
        builder.append(LINE_SEPARATOR);
        Iterator iterator = this.childrenScopes.values().iterator();
        while (iterator.hasNext()) {
            Scope scope = (Scope)iterator.next();
            boolean isLast = !iterator.hasNext();
            builder.append(isLast ? (char)'\\' : '+');
            builder.append("---");
            String childString = scope.toString();
            String[] split = childString.split(LINE_SEPARATOR);
            for (int i = 0; i < split.length; ++i) {
                String childLine = split[i];
                if (i != 0) {
                    builder.append("    ");
                }
                builder.append(childLine);
                builder.append(LINE_SEPARATOR);
            }
        }
        if (this.getRootScope() == this) {
            ArrayList<Class> sortedUnScopedProviderClassesList;
            builder.append("UnScoped providers: [");
            IdentityHashMap<Class, InternalProvider> identityHashMap = mapClassesToUnNamedUnScopedProviders;
            synchronized (identityHashMap) {
                sortedUnScopedProviderClassesList = new ArrayList<Class>(mapClassesToUnNamedUnScopedProviders.keySet());
            }
            Collections.sort(sortedUnScopedProviderClassesList, new ClassNameComparator());
            for (Class aClass : sortedUnScopedProviderClassesList) {
                builder.append(aClass.getName());
                builder.append(',');
            }
            if (!sortedUnScopedProviderClassesList.isEmpty()) {
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append(']');
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    private void installModules(boolean isTestModule, Module ... modules) {
        for (Module module : modules) {
            try {
                this.installModule(isTestModule, module);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Module %s couldn't be installed", module.getClass().getName()), e);
            }
        }
    }

    private void installModule(boolean isTestModule, Module module) {
        for (Binding binding : module.getBindingSet()) {
            if (binding == null) {
                throw new IllegalStateException("A module can't have a null binding : " + module);
            }
            Class clazz = binding.getKey();
            String bindingName = binding.getName();
            try {
                if (!isTestModule && this.getScopedProvider(clazz, bindingName) != null) continue;
                InternalProvider provider = this.toProvider(binding);
                this.installScopedProvider(clazz, bindingName, provider, isTestModule);
            }
            catch (Exception e) {
                throw new IllegalBindingException(String.format("Binding %s couldn't be installed", bindingName), e);
            }
        }
    }

    <T> InternalProvider<T> toProvider(Binding<T> binding) {
        if (binding == null) {
            throw new IllegalStateException("null binding are not allowed. Should not happen unless getBindingSet is overridden.");
        }
        ConfigurationHolder.configuration.checkIllegalBinding(binding, this);
        switch (binding.getMode()) {
            case SIMPLE: {
                return new InternalScopedProvider((Scope)this, binding.getKey(), binding.isCreatingSingleton(), binding.isCreatingReleasable());
            }
            case CLASS: {
                return new InternalScopedProvider((Scope)this, binding.getImplementationClass(), binding.isCreatingSingleton(), binding.isCreatingReleasable());
            }
            case INSTANCE: {
                return new InternalScopedProvider<Object>((Scope)this, binding.getInstance());
            }
            case PROVIDER_INSTANCE: {
                return new InternalScopedProvider((Scope)this, binding.getProviderInstance(), binding.isProvidingSingleton(), binding.isProvidingReleasable());
            }
            case PROVIDER_CLASS: {
                return new InternalScopedProvider(this, binding.getProviderClass(), binding.isCreatingSingleton(), binding.isCreatingReleasable(), binding.isProvidingSingleton(), binding.isProvidingReleasable());
            }
        }
        throw new IllegalStateException(String.format("mode is not handled: %s. This should not happen.", binding.getMode()));
    }

    <T> InternalProvider<? extends T> lookupProvider(Class<T> clazz, String bindingName) {
        if (clazz == null) {
            throw new IllegalArgumentException("TP can't get an instance of a null class.");
        }
        InternalProvider<T> scopedProvider = this.getScopedProvider(clazz, bindingName);
        if (scopedProvider != null) {
            return scopedProvider;
        }
        for (Scope parentScope : this.parentScopes) {
            ScopeImpl parentScopeImpl = (ScopeImpl)parentScope;
            InternalProvider<T> parentScopedProvider = parentScopeImpl.getScopedProvider(clazz, bindingName);
            if (parentScopedProvider == null) continue;
            return parentScopedProvider;
        }
        if (bindingName != null) {
            throw new RuntimeException(String.format("No binding was defined for class %s and name %s in scope %s and its parents %s", clazz.getName(), bindingName, this.getName(), this.getParentScopesNames()));
        }
        InternalProvider<T> unScopedProviderInPool = this.getUnUnScopedProvider(clazz, null);
        if (unScopedProviderInPool != null) {
            return unScopedProviderInPool;
        }
        Factory<T> factory = FactoryLocator.getFactory(clazz);
        if (factory.hasScopeAnnotation()) {
            Scope targetScope = factory.getTargetScope((Scope)this);
            InternalScopedProvider<Factory<T>> newProvider = new InternalScopedProvider<Factory<T>>(targetScope, factory);
            ScopeImpl targetScopeImpl = (ScopeImpl)targetScope;
            return targetScopeImpl.installScopedProvider(clazz, null, newProvider, false);
        }
        InternalProvider<T> newProvider = new InternalProvider<T>(factory);
        return this.installUnScopedProvider(clazz, null, newProvider);
    }

    private <T> InternalProvider<? extends T> getScopedProvider(Class<T> clazz, String bindingName) {
        return this.getInternalProvider(clazz, bindingName, true);
    }

    private <T> InternalProvider<? extends T> getUnUnScopedProvider(Class<T> clazz, String bindingName) {
        return this.getInternalProvider(clazz, bindingName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> InternalProvider<? extends T> getInternalProvider(Class<T> clazz, String bindingName, boolean isScoped) {
        if (bindingName == null) {
            if (isScoped) {
                IdentityHashMap<Class, InternalScopedProvider> identityHashMap = this.mapClassesToUnNamedScopedProviders;
                synchronized (identityHashMap) {
                    return this.mapClassesToUnNamedScopedProviders.get(clazz);
                }
            }
            IdentityHashMap<Class, InternalProvider> identityHashMap = mapClassesToUnNamedUnScopedProviders;
            synchronized (identityHashMap) {
                return mapClassesToUnNamedUnScopedProviders.get(clazz);
            }
        }
        IdentityHashMap<Class, Map<String, InternalScopedProvider>> identityHashMap = this.mapClassesToNamedScopedProviders;
        synchronized (identityHashMap) {
            Map<String, InternalScopedProvider> mapNameToProvider = this.mapClassesToNamedScopedProviders.get(clazz);
            if (mapNameToProvider == null) {
                return null;
            }
            return mapNameToProvider.get(bindingName);
        }
    }

    private <T> InternalProvider<? extends T> installScopedProvider(Class<T> clazz, String bindingName, InternalProvider<? extends T> internalProvider, boolean isTestProvider) {
        return this.installInternalProvider(clazz, bindingName, internalProvider, true, isTestProvider);
    }

    private <T> InternalProvider<? extends T> installUnScopedProvider(Class<T> clazz, String bindingName, InternalProvider<? extends T> internalProvider) {
        return this.installInternalProvider(clazz, bindingName, internalProvider, false, false);
    }

    private <T> InternalProvider<? extends T> installInternalProvider(Class<T> clazz, String bindingName, InternalProvider<? extends T> internalProvider, boolean isScoped, boolean isTestProvider) {
        if (bindingName == null) {
            if (isScoped) {
                return this.installUnNamedScopedProvider(clazz, (InternalScopedProvider)internalProvider, isTestProvider);
            }
            return this.installUnScopedProvider(clazz, internalProvider, isTestProvider);
        }
        return this.installNamedScopedProvider(clazz, bindingName, (InternalScopedProvider)internalProvider, isTestProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> InternalProvider<? extends T> installNamedScopedProvider(Class<T> clazz, String bindingName, InternalScopedProvider<? extends T> internalProvider, boolean isTestProvider) {
        IdentityHashMap<Class, Map<String, InternalScopedProvider>> identityHashMap = this.mapClassesToNamedScopedProviders;
        synchronized (identityHashMap) {
            Map<String, InternalScopedProvider> mapNameToProvider = this.mapClassesToNamedScopedProviders.get(clazz);
            if (mapNameToProvider == null) {
                mapNameToProvider = new HashMap<String, InternalScopedProvider>(1);
                this.mapClassesToNamedScopedProviders.put(clazz, mapNameToProvider);
                mapNameToProvider.put(bindingName, internalProvider);
                return internalProvider;
            }
            InternalProvider previous = mapNameToProvider.get(bindingName);
            if (previous == null || isTestProvider) {
                mapNameToProvider.put(bindingName, internalProvider);
                return internalProvider;
            }
            return previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> InternalProvider<? extends T> installUnNamedScopedProvider(Class<T> clazz, InternalScopedProvider<? extends T> internalProvider, boolean isTestProvider) {
        IdentityHashMap<Class, InternalScopedProvider> identityHashMap = this.mapClassesToUnNamedScopedProviders;
        synchronized (identityHashMap) {
            InternalScopedProvider previous = this.mapClassesToUnNamedScopedProviders.get(clazz);
            if (previous == null || isTestProvider) {
                this.mapClassesToUnNamedScopedProviders.put(clazz, internalProvider);
                return internalProvider;
            }
            return previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> InternalProvider<? extends T> installUnScopedProvider(Class<T> clazz, InternalProvider<? extends T> internalProvider, boolean isTestProvider) {
        IdentityHashMap<Class, InternalProvider> identityHashMap = mapClassesToUnNamedUnScopedProviders;
        synchronized (identityHashMap) {
            InternalProvider previous = mapClassesToUnNamedUnScopedProviders.get(clazz);
            if (previous == null || isTestProvider) {
                mapClassesToUnNamedUnScopedProviders.put(clazz, internalProvider);
                return internalProvider;
            }
            return previous;
        }
    }

    private void crashIfClosed() {
        if (!this.isOpen) {
            throw new IllegalStateException(String.format("The scope with name %s has been already closed. It can't be used to create new instances.", this.name));
        }
    }

    static void resetUnScopedProviders() {
        mapClassesToUnNamedUnScopedProviders.clear();
    }

    @Override
    protected void reset() {
        super.reset();
        this.mapClassesToNamedScopedProviders.clear();
        this.mapClassesToUnNamedScopedProviders.clear();
        this.hasTestModules = false;
        this.installBindingForScopeClass();
    }

    public Scope openSubScope(Object subScopeName) {
        return Toothpick.openScopes(this.getName(), subScopeName);
    }

    public Scope openSubScope(Object subScopeName, Scope.ScopeConfig scopeConfig) {
        boolean wasOpen = Toothpick.isScopeOpen(subScopeName);
        Scope scope = Toothpick.openScopes(this.getName(), subScopeName);
        if (!wasOpen) {
            scopeConfig.configure(scope);
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        for (ScopeNode childScope : this.childrenScopes.values()) {
            childScope.release();
        }
        IdentityHashMap<Class, Map<String, InternalScopedProvider>> identityHashMap = this.mapClassesToUnNamedScopedProviders;
        synchronized (identityHashMap) {
            for (InternalProvider internalProvider : this.mapClassesToUnNamedScopedProviders.values()) {
                if (!internalProvider.isReleasable()) continue;
                internalProvider.release();
            }
        }
        identityHashMap = this.mapClassesToNamedScopedProviders;
        synchronized (identityHashMap) {
            for (Map map : this.mapClassesToNamedScopedProviders.values()) {
                for (InternalProvider internalProvider : map.values()) {
                    if (!internalProvider.isReleasable()) continue;
                    internalProvider.release();
                }
            }
        }
    }

    private void installBindingForScopeClass() {
        this.installScopedProvider(Scope.class, null, new InternalScopedProvider<ScopeImpl>((Scope)this, this), false);
    }

    private static class ClassNameComparator
    implements Comparator<Class> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(Class o1, Class o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

