/*
 * Decompiled with CFR 0.152.
 */
package toothpick.compiler.memberinjector.generators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import toothpick.MemberInjector;
import toothpick.Scope;
import toothpick.compiler.common.generators.CodeGenerator;
import toothpick.compiler.common.generators.targets.ParamInjectionTarget;
import toothpick.compiler.memberinjector.targets.FieldInjectionTarget;
import toothpick.compiler.memberinjector.targets.MethodInjectionTarget;

public class MemberInjectorGenerator
extends CodeGenerator {
    private static final String MEMBER_INJECTOR_SUFFIX = "__MemberInjector";
    private TypeElement targetClass;
    private TypeElement superClassThatNeedsInjection;
    private List<FieldInjectionTarget> fieldInjectionTargetList;
    private List<MethodInjectionTarget> methodInjectionTargetList;

    public MemberInjectorGenerator(TypeElement targetClass, TypeElement superClassThatNeedsInjection, List<FieldInjectionTarget> fieldInjectionTargetList, List<MethodInjectionTarget> methodInjectionTargetList, Types types) {
        super(types);
        this.targetClass = targetClass;
        this.superClassThatNeedsInjection = superClassThatNeedsInjection;
        this.fieldInjectionTargetList = fieldInjectionTargetList;
        this.methodInjectionTargetList = methodInjectionTargetList;
        if (fieldInjectionTargetList == null && methodInjectionTargetList == null) {
            throw new IllegalArgumentException("At least one memberInjectorInjectionTarget is needed.");
        }
    }

    @Override
    public String brewJava() {
        ClassName className = ClassName.get((TypeElement)this.targetClass);
        ParameterizedTypeName memberInjectorInterfaceParameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(MemberInjector.class), (TypeName[])new TypeName[]{className});
        TypeSpec.Builder scopeMemberTypeSpec = TypeSpec.classBuilder((String)(MemberInjectorGenerator.getGeneratedSimpleClassName(this.targetClass) + MEMBER_INJECTOR_SUFFIX)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)memberInjectorInterfaceParameterizedTypeName);
        this.emitSuperMemberInjectorFieldIfNeeded(scopeMemberTypeSpec);
        this.emitInjectMethod(scopeMemberTypeSpec, this.fieldInjectionTargetList, this.methodInjectionTargetList);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)scopeMemberTypeSpec.build()).build();
        return javaFile.toString();
    }

    private void emitSuperMemberInjectorFieldIfNeeded(TypeSpec.Builder scopeMemberTypeSpec) {
        if (this.superClassThatNeedsInjection != null) {
            FieldSpec.Builder superMemberInjectorField = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(MemberInjector.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.typeUtil.erasure(this.superClassThatNeedsInjection.asType()))}), (String)"superMemberInjector", (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $L__MemberInjector()", new Object[]{MemberInjectorGenerator.getGeneratedFQNClassName(this.superClassThatNeedsInjection)});
            scopeMemberTypeSpec.addField(superMemberInjectorField.build());
        }
    }

    private void emitInjectMethod(TypeSpec.Builder scopeMemberTypeSpec, List<FieldInjectionTarget> fieldInjectionTargetList, List<MethodInjectionTarget> methodInjectionTargetList) {
        MethodSpec.Builder injectMethodBuilder = MethodSpec.methodBuilder((String)"inject").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((TypeElement)this.targetClass), "target", new Modifier[0]).addParameter((TypeName)ClassName.get(Scope.class), "scope", new Modifier[0]);
        if (this.superClassThatNeedsInjection != null) {
            injectMethodBuilder.addStatement("superMemberInjector.inject(target, scope)", new Object[0]);
        }
        this.emitInjectFields(fieldInjectionTargetList, injectMethodBuilder);
        this.emitInjectMethods(methodInjectionTargetList, injectMethodBuilder);
        scopeMemberTypeSpec.addMethod(injectMethodBuilder.build());
    }

    private void emitInjectMethods(List<MethodInjectionTarget> methodInjectionTargetList, MethodSpec.Builder injectMethodBuilder) {
        if (methodInjectionTargetList == null) {
            return;
        }
        int counter = 1;
        for (MethodInjectionTarget methodInjectionTarget : methodInjectionTargetList) {
            boolean isMethodThrowingExceptions;
            if (methodInjectionTarget.isOverride) continue;
            StringBuilder injectedMethodCallStatement = new StringBuilder();
            injectedMethodCallStatement.append("target.");
            injectedMethodCallStatement.append(methodInjectionTarget.methodName);
            injectedMethodCallStatement.append("(");
            String prefix = "";
            for (ParamInjectionTarget paramInjectionTarget : methodInjectionTarget.parameters) {
                CodeBlock invokeScopeGetMethodWithNameCodeBlock = this.getInvokeScopeGetMethodWithNameCodeBlock(paramInjectionTarget);
                String paramName = "param" + counter++;
                injectMethodBuilder.addCode("$T $L = scope.", new Object[]{this.getParamType(paramInjectionTarget), paramName});
                injectMethodBuilder.addCode(invokeScopeGetMethodWithNameCodeBlock);
                injectMethodBuilder.addCode(";", new Object[0]);
                injectMethodBuilder.addCode(LINE_SEPARATOR, new Object[0]);
                injectedMethodCallStatement.append(prefix);
                injectedMethodCallStatement.append(paramName);
                prefix = ", ";
            }
            injectedMethodCallStatement.append(")");
            boolean bl = isMethodThrowingExceptions = !methodInjectionTarget.exceptionTypes.isEmpty();
            if (isMethodThrowingExceptions) {
                injectMethodBuilder.beginControlFlow("try", new Object[0]);
            }
            injectMethodBuilder.addStatement(injectedMethodCallStatement.toString(), new Object[0]);
            if (!isMethodThrowingExceptions) continue;
            int exceptionCounter = 1;
            for (TypeElement exceptionType : methodInjectionTarget.exceptionTypes) {
                injectMethodBuilder.nextControlFlow("catch ($T e$L)", new Object[]{exceptionType, exceptionCounter});
                injectMethodBuilder.addStatement("throw new $T(e$L)", new Object[]{RuntimeException.class, exceptionCounter});
                ++exceptionCounter;
            }
            injectMethodBuilder.endControlFlow();
        }
    }

    private void emitInjectFields(List<FieldInjectionTarget> fieldInjectionTargetList, MethodSpec.Builder injectBuilder) {
        if (fieldInjectionTargetList == null) {
            return;
        }
        for (FieldInjectionTarget memberInjectionTarget : fieldInjectionTargetList) {
            CodeBlock invokeScopeGetMethodWithNameCodeBlock = this.getInvokeScopeGetMethodWithNameCodeBlock(memberInjectionTarget);
            injectBuilder.addCode("target.$L = scope.", new Object[]{memberInjectionTarget.memberName});
            injectBuilder.addCode(invokeScopeGetMethodWithNameCodeBlock);
            injectBuilder.addCode(";", new Object[0]);
            injectBuilder.addCode(LINE_SEPARATOR, new Object[0]);
        }
    }

    @Override
    public String getFqcn() {
        return MemberInjectorGenerator.getGeneratedFQNClassName(this.targetClass) + MEMBER_INJECTOR_SUFFIX;
    }
}

