/*
 * Decompiled with CFR 0.152.
 */
package toothpick.compiler.memberinjector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import toothpick.compiler.common.ToothpickProcessor;
import toothpick.compiler.memberinjector.generators.MemberInjectorGenerator;
import toothpick.compiler.memberinjector.targets.FieldInjectionTarget;
import toothpick.compiler.memberinjector.targets.MethodInjectionTarget;

@SupportedAnnotationTypes(value={"javax.inject.Inject"})
@SupportedOptions(value={"toothpick_excludes", "toothpick_crash_when_injected_method_is_not_package"})
public class MemberInjectorProcessor
extends ToothpickProcessor {
    private Map<TypeElement, List<FieldInjectionTarget>> mapTypeElementToFieldInjectorTargetList;
    private Map<TypeElement, List<MethodInjectionTarget>> mapTypeElementToMethodInjectorTargetList;
    private Map<TypeElement, TypeElement> mapTypeElementToSuperTypeElementThatNeedsInjection;
    private Map<String, TypeElement> allRoundsGeneratedToTypeElement = new HashMap<String, TypeElement>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.readCommonProcessorOptions();
        this.readOptionCrashWhenMethodIsNotPackageProtected();
        this.mapTypeElementToFieldInjectorTargetList = new LinkedHashMap<TypeElement, List<FieldInjectionTarget>>();
        this.mapTypeElementToMethodInjectorTargetList = new LinkedHashMap<TypeElement, List<MethodInjectionTarget>>();
        this.mapTypeElementToSuperTypeElementThatNeedsInjection = new LinkedHashMap<TypeElement, TypeElement>();
        this.findAndParseTargets(roundEnv);
        HashSet<TypeElement> elementWithInjectionSet = new HashSet<TypeElement>();
        elementWithInjectionSet.addAll(this.mapTypeElementToFieldInjectorTargetList.keySet());
        elementWithInjectionSet.addAll(this.mapTypeElementToMethodInjectorTargetList.keySet());
        for (TypeElement typeElement : elementWithInjectionSet) {
            List<FieldInjectionTarget> fieldInjectionTargetList = this.mapTypeElementToFieldInjectorTargetList.get(typeElement);
            List<MethodInjectionTarget> methodInjectionTargetList = this.mapTypeElementToMethodInjectorTargetList.get(typeElement);
            TypeElement superClassThatNeedsInjection = this.mapTypeElementToSuperTypeElementThatNeedsInjection.get(typeElement);
            MemberInjectorGenerator memberInjectorGenerator = new MemberInjectorGenerator(typeElement, superClassThatNeedsInjection, fieldInjectionTargetList, methodInjectionTargetList, this.typeUtils);
            String fileDescription = String.format("MemberInjector for type %s", typeElement);
            this.writeToFile(memberInjectorGenerator, fileDescription, typeElement);
            this.allRoundsGeneratedToTypeElement.put(memberInjectorGenerator.getFqcn(), typeElement);
        }
        return false;
    }

    private void readOptionCrashWhenMethodIsNotPackageProtected() {
        Map<String, String> options = this.processingEnv.getOptions();
        if (this.toothpickCrashWhenMethodIsNotPackageVisible == null) {
            this.toothpickCrashWhenMethodIsNotPackageVisible = Boolean.parseBoolean(options.get("toothpick_crash_when_injected_method_is_not_package"));
        }
    }

    private void findAndParseTargets(RoundEnvironment roundEnv) {
        this.processInjectAnnotatedFields(roundEnv);
        this.processInjectAnnotatedMethods(roundEnv);
    }

    protected void processInjectAnnotatedFields(RoundEnvironment roundEnv) {
        for (VariableElement element : ElementFilter.fieldsIn(roundEnv.getElementsAnnotatedWith(Inject.class))) {
            if (this.isExcludedByFilters((TypeElement)element.getEnclosingElement())) continue;
            this.processInjectAnnotatedField(element, this.mapTypeElementToFieldInjectorTargetList);
        }
    }

    protected void processInjectAnnotatedMethods(RoundEnvironment roundEnv) {
        for (ExecutableElement element : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(Inject.class))) {
            if (this.isExcludedByFilters((TypeElement)element.getEnclosingElement())) continue;
            this.processInjectAnnotatedMethod(element, this.mapTypeElementToMethodInjectorTargetList);
        }
    }

    private void processInjectAnnotatedField(VariableElement fieldElement, Map<TypeElement, List<FieldInjectionTarget>> mapTypeElementToMemberInjectorTargetList) {
        TypeElement enclosingElement = (TypeElement)fieldElement.getEnclosingElement();
        if (!this.isValidInjectAnnotatedFieldOrParameter(fieldElement)) {
            return;
        }
        List<FieldInjectionTarget> fieldInjectionTargetList = mapTypeElementToMemberInjectorTargetList.get(enclosingElement);
        if (fieldInjectionTargetList == null) {
            fieldInjectionTargetList = new ArrayList<FieldInjectionTarget>();
            mapTypeElementToMemberInjectorTargetList.put(enclosingElement, fieldInjectionTargetList);
        }
        this.mapTypeToMostDirectSuperTypeThatNeedsInjection(enclosingElement);
        fieldInjectionTargetList.add(this.createFieldOrParamInjectionTarget(fieldElement));
    }

    private void processInjectAnnotatedMethod(ExecutableElement methodElement, Map<TypeElement, List<MethodInjectionTarget>> mapTypeElementToMemberInjectorTargetList) {
        TypeElement enclosingElement = (TypeElement)methodElement.getEnclosingElement();
        if (!this.isValidInjectAnnotatedMethod(methodElement)) {
            return;
        }
        List<MethodInjectionTarget> methodInjectionTargetList = mapTypeElementToMemberInjectorTargetList.get(enclosingElement);
        if (methodInjectionTargetList == null) {
            methodInjectionTargetList = new ArrayList<MethodInjectionTarget>();
            mapTypeElementToMemberInjectorTargetList.put(enclosingElement, methodInjectionTargetList);
        }
        this.mapTypeToMostDirectSuperTypeThatNeedsInjection(enclosingElement);
        methodInjectionTargetList.add(this.createMethodInjectionTarget(methodElement));
    }

    private void mapTypeToMostDirectSuperTypeThatNeedsInjection(TypeElement typeElement) {
        TypeElement superClassWithInjectedMembers = this.getMostDirectSuperClassWithInjectedMembers(typeElement, true);
        this.mapTypeElementToSuperTypeElementThatNeedsInjection.put(typeElement, superClassWithInjectedMembers);
    }

    private MethodInjectionTarget createMethodInjectionTarget(ExecutableElement methodElement) {
        TypeElement enclosingElement = (TypeElement)methodElement.getEnclosingElement();
        String methodName = methodElement.getSimpleName().toString();
        boolean isOverride = this.isOverride(enclosingElement, methodElement);
        MethodInjectionTarget methodInjectionTarget = new MethodInjectionTarget(enclosingElement, methodName, isOverride);
        methodInjectionTarget.parameters.addAll(this.getParamInjectionTargetList(methodElement));
        methodInjectionTarget.exceptionTypes.addAll(this.getExceptionTypes(methodElement));
        return methodInjectionTarget;
    }

    void setToothpickExcludeFilters(String toothpickExcludeFilters) {
        this.toothpickExcludeFilters = toothpickExcludeFilters;
    }

    void setCrashOrWarnWhenMethodIsNotPackageVisible(boolean crashOrWarnWhenMethodIsNotPackageVisible) {
        this.toothpickCrashWhenMethodIsNotPackageVisible = crashOrWarnWhenMethodIsNotPackageVisible;
    }

    TypeElement getOriginatingElement(String generatedQualifiedName) {
        return this.allRoundsGeneratedToTypeElement.get(generatedQualifiedName);
    }
}

