/*
 * Decompiled with CFR 0.152.
 */
package toothpick.compiler.common;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import toothpick.compiler.common.generators.CodeGenerator;
import toothpick.compiler.common.generators.targets.ParamInjectionTarget;
import toothpick.compiler.memberinjector.targets.FieldInjectionTarget;

public abstract class ToothpickProcessor
extends AbstractProcessor {
    public static final String INJECT_ANNOTATION_CLASS_NAME = "javax.inject.Inject";
    public static final String SINGLETON_ANNOTATION_CLASS_NAME = "javax.inject.Singleton";
    public static final String PRODUCES_SINGLETON_ANNOTATION_CLASS_NAME = "toothpick.ProvidesSingleton";
    public static final String INJECT_CONSTRUCTOR_ANNOTATION_CLASS_NAME = "toothpick.InjectConstructor";
    public static final String PARAMETER_EXCLUDES = "toothpick_excludes";
    public static final String PARAMETER_ANNOTATION_TYPES = "toothpick_annotations";
    public static final String PARAMETER_CRASH_WHEN_NO_FACTORY_CAN_BE_CREATED = "toothpick_crash_when_no_factory_can_be_created";
    public static final String PARAMETER_CRASH_WHEN_INJECTED_METHOD_IS_NOT_PACKAGE = "toothpick_crash_when_injected_method_is_not_package";
    private static final String SUPPRESS_WARNING_ANNOTATION_VISIBLE_VALUE = "visible";
    protected Elements elementUtils;
    protected Types typeUtils;
    protected Filer filer;
    protected String toothpickExcludeFilters = "java.*,android.*";
    protected Boolean toothpickCrashWhenMethodIsNotPackageVisible;
    protected Set<String> supportedAnnotationTypes = new HashSet<String>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public void addSupportedAnnotationType(String typeFQN) {
        this.supportedAnnotationTypes.add(typeFQN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean writeToFile(CodeGenerator codeGenerator, String fileDescription, Element originatingElement) {
        Writer writer = null;
        boolean success = true;
        JavaFileObject jfo = this.filer.createSourceFile(codeGenerator.getFqcn(), originatingElement);
        writer = jfo.openWriter();
        writer.write(codeGenerator.brewJava());
        if (writer == null) return success;
        try {
            writer.close();
            return success;
        }
        catch (IOException e) {
            this.error("Error closing %s file: %s", fileDescription, e.getMessage());
            return false;
        }
        catch (IOException e) {
            try {
                this.error("Error writing %s file: %s", fileDescription, e.getMessage());
                success = false;
                if (writer == null) return success;
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    this.error("Error closing %s file: %s", fileDescription, e2.getMessage());
                    success = false;
                }
                throw throwable;
            }
            try {
                writer.close();
                return success;
            }
            catch (IOException e3) {
                this.error("Error closing %s file: %s", fileDescription, e3.getMessage());
                return false;
            }
        }
    }

    protected void readCommonProcessorOptions() {
        this.readOptionExcludes();
    }

    private void readOptionExcludes() {
        Map<String, String> options = this.processingEnv.getOptions();
        if (options.containsKey(PARAMETER_EXCLUDES)) {
            this.toothpickExcludeFilters = options.get(PARAMETER_EXCLUDES);
        }
    }

    protected void readOptionAnnotationTypes() {
        Map<String, String> options = this.processingEnv.getOptions();
        if (options.containsKey(PARAMETER_ANNOTATION_TYPES)) {
            String additionalAnnotationTypes = options.get(PARAMETER_ANNOTATION_TYPES);
            for (String additionalAnnotationType : additionalAnnotationTypes.split(",")) {
                this.supportedAnnotationTypes.add(additionalAnnotationType.trim());
            }
        }
    }

    protected void error(String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args));
    }

    protected void error(Element element, String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
    }

    protected void warning(Element element, String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format(message, args), element);
    }

    protected void warning(String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format(message, args));
    }

    private void crashOrWarnWhenMethodIsNotPackageVisible(Element element, String message) {
        if (this.toothpickCrashWhenMethodIsNotPackageVisible != null && this.toothpickCrashWhenMethodIsNotPackageVisible.booleanValue()) {
            this.error(element, message, new Object[0]);
        } else {
            this.warning(element, message, new Object[0]);
        }
    }

    protected boolean isValidInjectAnnotatedFieldOrParameter(VariableElement variableElement) {
        TypeElement enclosingElement = (TypeElement)variableElement.getEnclosingElement();
        Set<Modifier> modifiers = variableElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            this.error(variableElement, "@Inject annotated fields must be non private : %s#%s", enclosingElement.getQualifiedName(), variableElement.getSimpleName());
            return false;
        }
        Set<Modifier> parentModifiers = enclosingElement.getModifiers();
        if (parentModifiers.contains((Object)Modifier.PRIVATE)) {
            this.error(variableElement, "@Injected fields in class %s. The class must be non private.", enclosingElement.getSimpleName());
            return false;
        }
        return this.isValidInjectedType(variableElement);
    }

    protected boolean isValidInjectAnnotatedMethod(ExecutableElement methodElement) {
        TypeElement enclosingElement = (TypeElement)methodElement.getEnclosingElement();
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            this.error(methodElement, "@Inject annotated methods must not be private : %s#%s", enclosingElement.getQualifiedName(), methodElement.getSimpleName());
            return false;
        }
        Set<Modifier> parentModifiers = enclosingElement.getModifiers();
        if (parentModifiers.contains((Object)Modifier.PRIVATE)) {
            this.error(methodElement, "@Injected fields in class %s. The class must be non private.", enclosingElement.getSimpleName());
            return false;
        }
        for (VariableElement variableElement : methodElement.getParameters()) {
            if (this.isValidInjectedType(variableElement)) continue;
            return false;
        }
        if ((modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED)) && !this.hasWarningSuppressed(methodElement, SUPPRESS_WARNING_ANNOTATION_VISIBLE_VALUE)) {
            this.crashOrWarnWhenMethodIsNotPackageVisible(methodElement, String.format("@Inject annotated methods should have package visibility: %s#%s", enclosingElement.getQualifiedName(), methodElement.getSimpleName()));
        }
        return true;
    }

    protected boolean isValidInjectedType(VariableElement injectedTypeElement) {
        if (!this.isValidInjectedElementKind(injectedTypeElement)) {
            return false;
        }
        return !this.isProviderOrLazy(injectedTypeElement) || this.isValidProviderOrLazy(injectedTypeElement);
    }

    private boolean isValidInjectedElementKind(VariableElement injectedTypeElement) {
        Element typeElement = this.typeUtils.asElement(injectedTypeElement.asType());
        if (typeElement == null || typeElement.getKind() != ElementKind.CLASS && typeElement.getKind() != ElementKind.INTERFACE && typeElement.getKind() != ElementKind.ENUM) {
            Element enclosingElement = injectedTypeElement.getEnclosingElement();
            String typeName = typeElement != null ? typeElement.toString() : injectedTypeElement.asType().toString();
            if (enclosingElement instanceof TypeElement) {
                this.error(injectedTypeElement, "Field %s#%s is of type %s which is not supported by Toothpick.", ((TypeElement)enclosingElement).getQualifiedName(), injectedTypeElement.getSimpleName(), typeName);
            } else {
                Element methodOrConstructorElement = enclosingElement;
                enclosingElement = enclosingElement.getEnclosingElement();
                this.error(injectedTypeElement, "Parameter %s in method/constructor %s#%s is of type %s which is not supported by Toothpick.", injectedTypeElement.getSimpleName(), ((TypeElement)enclosingElement).getQualifiedName(), methodOrConstructorElement.getSimpleName(), typeName);
            }
            return false;
        }
        return true;
    }

    private boolean isValidProviderOrLazy(Element element) {
        int size;
        DeclaredType declaredType = (DeclaredType)element.asType();
        if (declaredType.getTypeArguments().isEmpty()) {
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement instanceof TypeElement) {
                this.error(element, "Field %s#%s is not a valid %s.", ((TypeElement)enclosingElement).getQualifiedName(), element.getSimpleName(), declaredType);
            } else {
                this.error(element, "Parameter %s in method/constructor %s#%s is not a valid %s.", element.getSimpleName(), ((TypeElement)enclosingElement.getEnclosingElement()).getQualifiedName(), enclosingElement.getSimpleName(), declaredType);
            }
            return false;
        }
        TypeMirror firstParameterTypeMirror = declaredType.getTypeArguments().get(0);
        if (firstParameterTypeMirror.getKind() == TypeKind.DECLARED && (size = ((DeclaredType)firstParameterTypeMirror).getTypeArguments().size()) != 0) {
            Element enclosingElement = element.getEnclosingElement();
            this.error(element, "Lazy/Provider %s is not a valid in %s. Lazy/Provider cannot be used on generic types.", element.getSimpleName(), enclosingElement.getSimpleName());
            return false;
        }
        return true;
    }

    protected List<ParamInjectionTarget> getParamInjectionTargetList(ExecutableElement executableElement) {
        ArrayList<ParamInjectionTarget> paramInjectionTargetList = new ArrayList<ParamInjectionTarget>();
        for (VariableElement variableElement : executableElement.getParameters()) {
            paramInjectionTargetList.add(this.createFieldOrParamInjectionTarget(variableElement));
        }
        return paramInjectionTargetList;
    }

    protected List<TypeElement> getExceptionTypes(ExecutableElement methodElement) {
        ArrayList<TypeElement> exceptionClassNames = new ArrayList<TypeElement>();
        for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
            DeclaredType thrownDeclaredType = (DeclaredType)typeMirror;
            TypeElement thrownType = (TypeElement)thrownDeclaredType.asElement();
            exceptionClassNames.add(thrownType);
        }
        return exceptionClassNames;
    }

    protected FieldInjectionTarget createFieldOrParamInjectionTarget(VariableElement variableElement) {
        TypeElement memberTypeElement = (TypeElement)this.typeUtils.asElement(variableElement.asType());
        String memberName = variableElement.getSimpleName().toString();
        ParamInjectionTarget.Kind kind = this.getParamInjectionTargetKind(variableElement);
        TypeElement kindParameterTypeElement = this.getInjectedType(variableElement);
        String name = this.findQualifierName(variableElement);
        return new FieldInjectionTarget(memberTypeElement, memberName, kind, kindParameterTypeElement, name);
    }

    protected TypeElement getInjectedType(VariableElement variableElement) {
        TypeElement fieldType = this.getParamInjectionTargetKind(variableElement) == ParamInjectionTarget.Kind.INSTANCE ? (TypeElement)this.typeUtils.asElement(this.typeUtils.erasure(variableElement.asType())) : this.getKindParameter(variableElement);
        return fieldType;
    }

    protected boolean isExcludedByFilters(TypeElement typeElement) {
        String typeElementName = typeElement.getQualifiedName().toString();
        for (String exclude : this.toothpickExcludeFilters.split(",")) {
            String regEx = exclude.trim();
            if (!typeElementName.matches(regEx)) continue;
            this.warning(typeElement, "The class %s was excluded by filters set at the annotation processor level. No factory will be generated by toothpick.", typeElement.getQualifiedName());
            return true;
        }
        return false;
    }

    protected boolean isOverride(TypeElement typeElement, ExecutableElement methodElement) {
        TypeElement currentTypeElement = typeElement;
        do {
            TypeMirror superclass;
            if (currentTypeElement != typeElement) {
                List<? extends Element> enclosedElements = currentTypeElement.getEnclosedElements();
                for (Element element : enclosedElements) {
                    if (!element.getSimpleName().equals(methodElement.getSimpleName()) || element.getAnnotation(Inject.class) == null || element.getKind() != ElementKind.METHOD) continue;
                    return true;
                }
            }
            if ((superclass = currentTypeElement.getSuperclass()).getKind() == TypeKind.DECLARED) {
                DeclaredType superType = (DeclaredType)superclass;
                currentTypeElement = (TypeElement)superType.asElement();
                continue;
            }
            currentTypeElement = null;
        } while (currentTypeElement != null);
        return false;
    }

    protected TypeElement getMostDirectSuperClassWithInjectedMembers(TypeElement typeElement, boolean onlyParents) {
        TypeElement currentTypeElement = typeElement;
        do {
            TypeMirror superclass;
            if (currentTypeElement != typeElement || !onlyParents) {
                List<? extends Element> enclosedElements = currentTypeElement.getEnclosedElements();
                for (Element element : enclosedElements) {
                    if ((element.getAnnotation(Inject.class) == null || element.getKind() != ElementKind.FIELD) && (element.getAnnotation(Inject.class) == null || element.getKind() != ElementKind.METHOD)) continue;
                    return currentTypeElement;
                }
            }
            if ((superclass = currentTypeElement.getSuperclass()).getKind() == TypeKind.DECLARED) {
                DeclaredType superType = (DeclaredType)superclass;
                currentTypeElement = (TypeElement)superType.asElement();
                continue;
            }
            currentTypeElement = null;
        } while (currentTypeElement != null);
        return null;
    }

    protected boolean isNonStaticInnerClass(TypeElement typeElement) {
        Element outerClassOrPackage = typeElement.getEnclosingElement();
        if (outerClassOrPackage.getKind() != ElementKind.PACKAGE && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.error(typeElement, "Class %s is a non static inner class. @Inject constructors are not allowed in non static inner classes.", typeElement.getQualifiedName());
            return true;
        }
        return false;
    }

    protected boolean hasWarningSuppressed(Element element, String warningSuppressString) {
        SuppressWarnings suppressWarnings = element.getAnnotation(SuppressWarnings.class);
        if (suppressWarnings != null) {
            for (String value : suppressWarnings.value()) {
                if (!value.equalsIgnoreCase(warningSuppressString)) continue;
                return true;
            }
        }
        return false;
    }

    private String findQualifierName(VariableElement element) {
        String name = null;
        if (element.getAnnotationMirrors().isEmpty()) {
            return name;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (this.isSameType(annotationTypeElement, "javax.inject.Named")) {
                this.checkIfAlreadyHasName(element, name);
                name = this.getValueOfAnnotation(annotationMirror);
                continue;
            }
            if (annotationTypeElement.getAnnotation(Qualifier.class) == null) continue;
            this.checkIfAlreadyHasName(element, name);
            name = annotationTypeElement.getQualifiedName().toString();
        }
        return name;
    }

    private boolean isSameType(TypeElement typeElement, String typeName) {
        return this.isSameType(typeElement.asType(), typeName);
    }

    private boolean isSameType(TypeMirror typeMirror, String typeName) {
        return this.typeUtils.isSameType(this.typeUtils.erasure(typeMirror), this.typeUtils.erasure(this.elementUtils.getTypeElement(typeName).asType()));
    }

    private void checkIfAlreadyHasName(VariableElement element, Object name) {
        if (name != null) {
            this.error(element, "Only one javax.inject.Qualifier annotation is allowed to name injections.", new Object[0]);
        }
    }

    private String getValueOfAnnotation(AnnotationMirror annotationMirror) {
        String result = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> annotationParamEntry : annotationMirror.getElementValues().entrySet()) {
            if (!annotationParamEntry.getKey().getSimpleName().contentEquals("value")) continue;
            result = annotationParamEntry.getValue().toString().replaceAll("\"", "");
        }
        return result;
    }

    private boolean isProviderOrLazy(Element element) {
        ParamInjectionTarget.Kind kind = this.getParamInjectionTargetKind(element);
        return kind == ParamInjectionTarget.Kind.PROVIDER || kind == ParamInjectionTarget.Kind.LAZY;
    }

    private ParamInjectionTarget.Kind getParamInjectionTargetKind(Element variableElement) {
        TypeMirror elementTypeMirror = variableElement.asType();
        if (this.isSameType(elementTypeMirror, "javax.inject.Provider")) {
            return ParamInjectionTarget.Kind.PROVIDER;
        }
        if (this.isSameType(elementTypeMirror, "toothpick.Lazy")) {
            return ParamInjectionTarget.Kind.LAZY;
        }
        Element typeElement = this.typeUtils.asElement(variableElement.asType());
        if (typeElement.getKind() != ElementKind.CLASS && typeElement.getKind() != ElementKind.INTERFACE && typeElement.getKind() != ElementKind.ENUM) {
            Element enclosingElement = variableElement.getEnclosingElement();
            while (!(enclosingElement instanceof TypeElement)) {
                enclosingElement = enclosingElement.getEnclosingElement();
            }
            this.error(variableElement, "Field %s#%s is of type %s which is not supported by Toothpick.", ((TypeElement)enclosingElement).getQualifiedName(), variableElement.getSimpleName(), typeElement);
            return null;
        }
        return ParamInjectionTarget.Kind.INSTANCE;
    }

    private TypeElement getKindParameter(Element element) {
        TypeMirror elementTypeMirror = element.asType();
        TypeMirror firstParameterTypeMirror = ((DeclaredType)elementTypeMirror).getTypeArguments().get(0);
        return (TypeElement)this.typeUtils.asElement(this.typeUtils.erasure(firstParameterTypeMirror));
    }
}

