/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.LedgerUpgrade;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class UpgradeEntryMeta
implements XdrElement {
    private LedgerUpgrade upgrade;
    private LedgerEntryChanges changes;

    public LedgerUpgrade getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(LedgerUpgrade value) {
        this.upgrade = value;
    }

    public LedgerEntryChanges getChanges() {
        return this.changes;
    }

    public void setChanges(LedgerEntryChanges value) {
        this.changes = value;
    }

    public static void encode(XdrDataOutputStream stream, UpgradeEntryMeta encodedUpgradeEntryMeta) throws IOException {
        LedgerUpgrade.encode(stream, encodedUpgradeEntryMeta.upgrade);
        LedgerEntryChanges.encode(stream, encodedUpgradeEntryMeta.changes);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        UpgradeEntryMeta.encode(stream, this);
    }

    public static UpgradeEntryMeta decode(XdrDataInputStream stream) throws IOException {
        UpgradeEntryMeta decodedUpgradeEntryMeta = new UpgradeEntryMeta();
        decodedUpgradeEntryMeta.upgrade = LedgerUpgrade.decode(stream);
        decodedUpgradeEntryMeta.changes = LedgerEntryChanges.decode(stream);
        return decodedUpgradeEntryMeta;
    }

    public int hashCode() {
        return Objects.hashCode(this.upgrade, this.changes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof UpgradeEntryMeta)) {
            return false;
        }
        UpgradeEntryMeta other = (UpgradeEntryMeta)object;
        return Objects.equal(this.upgrade, other.upgrade) && Objects.equal(this.changes, other.changes);
    }

    public static final class Builder {
        private LedgerUpgrade upgrade;
        private LedgerEntryChanges changes;

        public Builder upgrade(LedgerUpgrade upgrade) {
            this.upgrade = upgrade;
            return this;
        }

        public Builder changes(LedgerEntryChanges changes) {
            this.changes = changes;
            return this;
        }

        public UpgradeEntryMeta build() {
            UpgradeEntryMeta val = new UpgradeEntryMeta();
            val.setUpgrade(this.upgrade);
            val.setChanges(this.changes);
            return val;
        }
    }
}

