/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionV1Envelope
implements XdrElement {
    private Transaction tx;
    private DecoratedSignature[] signatures;

    public Transaction getTx() {
        return this.tx;
    }

    public void setTx(Transaction value) {
        this.tx = value;
    }

    public DecoratedSignature[] getSignatures() {
        return this.signatures;
    }

    public void setSignatures(DecoratedSignature[] value) {
        this.signatures = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionV1Envelope encodedTransactionV1Envelope) throws IOException {
        Transaction.encode(stream, encodedTransactionV1Envelope.tx);
        int signaturessize = encodedTransactionV1Envelope.getSignatures().length;
        stream.writeInt(signaturessize);
        for (int i = 0; i < signaturessize; ++i) {
            DecoratedSignature.encode(stream, encodedTransactionV1Envelope.signatures[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionV1Envelope.encode(stream, this);
    }

    public static TransactionV1Envelope decode(XdrDataInputStream stream) throws IOException {
        TransactionV1Envelope decodedTransactionV1Envelope = new TransactionV1Envelope();
        decodedTransactionV1Envelope.tx = Transaction.decode(stream);
        int signaturessize = stream.readInt();
        decodedTransactionV1Envelope.signatures = new DecoratedSignature[signaturessize];
        for (int i = 0; i < signaturessize; ++i) {
            decodedTransactionV1Envelope.signatures[i] = DecoratedSignature.decode(stream);
        }
        return decodedTransactionV1Envelope;
    }

    public int hashCode() {
        return Objects.hashCode(this.tx, Arrays.hashCode(this.signatures));
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionV1Envelope)) {
            return false;
        }
        TransactionV1Envelope other = (TransactionV1Envelope)object;
        return Objects.equal(this.tx, other.tx) && Arrays.equals(this.signatures, other.signatures);
    }

    public static final class Builder {
        private Transaction tx;
        private DecoratedSignature[] signatures;

        public Builder tx(Transaction tx) {
            this.tx = tx;
            return this;
        }

        public Builder signatures(DecoratedSignature[] signatures) {
            this.signatures = signatures;
            return this;
        }

        public TransactionV1Envelope build() {
            TransactionV1Envelope val = new TransactionV1Envelope();
            val.setTx(this.tx);
            val.setSignatures(this.signatures);
            return val;
        }
    }
}

