/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.TransactionResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionResultPair
implements XdrElement {
    private Hash transactionHash;
    private TransactionResult result;

    public Hash getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(Hash value) {
        this.transactionHash = value;
    }

    public TransactionResult getResult() {
        return this.result;
    }

    public void setResult(TransactionResult value) {
        this.result = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionResultPair encodedTransactionResultPair) throws IOException {
        Hash.encode(stream, encodedTransactionResultPair.transactionHash);
        TransactionResult.encode(stream, encodedTransactionResultPair.result);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionResultPair.encode(stream, this);
    }

    public static TransactionResultPair decode(XdrDataInputStream stream) throws IOException {
        TransactionResultPair decodedTransactionResultPair = new TransactionResultPair();
        decodedTransactionResultPair.transactionHash = Hash.decode(stream);
        decodedTransactionResultPair.result = TransactionResult.decode(stream);
        return decodedTransactionResultPair;
    }

    public int hashCode() {
        return Objects.hashCode(this.transactionHash, this.result);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionResultPair)) {
            return false;
        }
        TransactionResultPair other = (TransactionResultPair)object;
        return Objects.equal(this.transactionHash, other.transactionHash) && Objects.equal(this.result, other.result);
    }

    public static final class Builder {
        private Hash transactionHash;
        private TransactionResult result;

        public Builder transactionHash(Hash transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public Builder result(TransactionResult result) {
            this.result = result;
            return this;
        }

        public TransactionResultPair build() {
            TransactionResultPair val = new TransactionResultPair();
            val.setTransactionHash(this.transactionHash);
            val.setResult(this.result);
            return val;
        }
    }
}

