/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum TransactionResultCode implements XdrElement
{
    txFEE_BUMP_INNER_SUCCESS(1),
    txSUCCESS(0),
    txFAILED(-1),
    txTOO_EARLY(-2),
    txTOO_LATE(-3),
    txMISSING_OPERATION(-4),
    txBAD_SEQ(-5),
    txBAD_AUTH(-6),
    txINSUFFICIENT_BALANCE(-7),
    txNO_ACCOUNT(-8),
    txINSUFFICIENT_FEE(-9),
    txBAD_AUTH_EXTRA(-10),
    txINTERNAL_ERROR(-11),
    txNOT_SUPPORTED(-12),
    txFEE_BUMP_INNER_FAILED(-13),
    txBAD_SPONSORSHIP(-14);

    private int mValue;

    private TransactionResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static TransactionResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return txFEE_BUMP_INNER_SUCCESS;
            }
            case 0: {
                return txSUCCESS;
            }
            case -1: {
                return txFAILED;
            }
            case -2: {
                return txTOO_EARLY;
            }
            case -3: {
                return txTOO_LATE;
            }
            case -4: {
                return txMISSING_OPERATION;
            }
            case -5: {
                return txBAD_SEQ;
            }
            case -6: {
                return txBAD_AUTH;
            }
            case -7: {
                return txINSUFFICIENT_BALANCE;
            }
            case -8: {
                return txNO_ACCOUNT;
            }
            case -9: {
                return txINSUFFICIENT_FEE;
            }
            case -10: {
                return txBAD_AUTH_EXTRA;
            }
            case -11: {
                return txINTERNAL_ERROR;
            }
            case -12: {
                return txNOT_SUPPORTED;
            }
            case -13: {
                return txFEE_BUMP_INNER_FAILED;
            }
            case -14: {
                return txBAD_SPONSORSHIP;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, TransactionResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionResultCode.encode(stream, this);
    }
}

