/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionMetaV1
implements XdrElement {
    private LedgerEntryChanges txChanges;
    private OperationMeta[] operations;

    public LedgerEntryChanges getTxChanges() {
        return this.txChanges;
    }

    public void setTxChanges(LedgerEntryChanges value) {
        this.txChanges = value;
    }

    public OperationMeta[] getOperations() {
        return this.operations;
    }

    public void setOperations(OperationMeta[] value) {
        this.operations = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionMetaV1 encodedTransactionMetaV1) throws IOException {
        LedgerEntryChanges.encode(stream, encodedTransactionMetaV1.txChanges);
        int operationssize = encodedTransactionMetaV1.getOperations().length;
        stream.writeInt(operationssize);
        for (int i = 0; i < operationssize; ++i) {
            OperationMeta.encode(stream, encodedTransactionMetaV1.operations[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionMetaV1.encode(stream, this);
    }

    public static TransactionMetaV1 decode(XdrDataInputStream stream) throws IOException {
        TransactionMetaV1 decodedTransactionMetaV1 = new TransactionMetaV1();
        decodedTransactionMetaV1.txChanges = LedgerEntryChanges.decode(stream);
        int operationssize = stream.readInt();
        decodedTransactionMetaV1.operations = new OperationMeta[operationssize];
        for (int i = 0; i < operationssize; ++i) {
            decodedTransactionMetaV1.operations[i] = OperationMeta.decode(stream);
        }
        return decodedTransactionMetaV1;
    }

    public int hashCode() {
        return Objects.hashCode(this.txChanges, Arrays.hashCode(this.operations));
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionMetaV1)) {
            return false;
        }
        TransactionMetaV1 other = (TransactionMetaV1)object;
        return Objects.equal(this.txChanges, other.txChanges) && Arrays.equals(this.operations, other.operations);
    }

    public static final class Builder {
        private LedgerEntryChanges txChanges;
        private OperationMeta[] operations;

        public Builder txChanges(LedgerEntryChanges txChanges) {
            this.txChanges = txChanges;
            return this;
        }

        public Builder operations(OperationMeta[] operations) {
            this.operations = operations;
            return this;
        }

        public TransactionMetaV1 build() {
            TransactionMetaV1 val = new TransactionMetaV1();
            val.setTxChanges(this.txChanges);
            val.setOperations(this.operations);
            return val;
        }
    }
}

