/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Memo;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.TimeBounds;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class Transaction
implements XdrElement {
    private MuxedAccount sourceAccount;
    private Uint32 fee;
    private SequenceNumber seqNum;
    private TimeBounds timeBounds;
    private Memo memo;
    private Operation[] operations;
    private TransactionExt ext;

    public MuxedAccount getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(MuxedAccount value) {
        this.sourceAccount = value;
    }

    public Uint32 getFee() {
        return this.fee;
    }

    public void setFee(Uint32 value) {
        this.fee = value;
    }

    public SequenceNumber getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(SequenceNumber value) {
        this.seqNum = value;
    }

    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    public void setTimeBounds(TimeBounds value) {
        this.timeBounds = value;
    }

    public Memo getMemo() {
        return this.memo;
    }

    public void setMemo(Memo value) {
        this.memo = value;
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public void setOperations(Operation[] value) {
        this.operations = value;
    }

    public TransactionExt getExt() {
        return this.ext;
    }

    public void setExt(TransactionExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, Transaction encodedTransaction) throws IOException {
        MuxedAccount.encode(stream, encodedTransaction.sourceAccount);
        Uint32.encode(stream, encodedTransaction.fee);
        SequenceNumber.encode(stream, encodedTransaction.seqNum);
        if (encodedTransaction.timeBounds != null) {
            stream.writeInt(1);
            TimeBounds.encode(stream, encodedTransaction.timeBounds);
        } else {
            stream.writeInt(0);
        }
        Memo.encode(stream, encodedTransaction.memo);
        int operationssize = encodedTransaction.getOperations().length;
        stream.writeInt(operationssize);
        for (int i = 0; i < operationssize; ++i) {
            Operation.encode(stream, encodedTransaction.operations[i]);
        }
        TransactionExt.encode(stream, encodedTransaction.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Transaction.encode(stream, this);
    }

    public static Transaction decode(XdrDataInputStream stream) throws IOException {
        Transaction decodedTransaction = new Transaction();
        decodedTransaction.sourceAccount = MuxedAccount.decode(stream);
        decodedTransaction.fee = Uint32.decode(stream);
        decodedTransaction.seqNum = SequenceNumber.decode(stream);
        int timeBoundsPresent = stream.readInt();
        if (timeBoundsPresent != 0) {
            decodedTransaction.timeBounds = TimeBounds.decode(stream);
        }
        decodedTransaction.memo = Memo.decode(stream);
        int operationssize = stream.readInt();
        decodedTransaction.operations = new Operation[operationssize];
        for (int i = 0; i < operationssize; ++i) {
            decodedTransaction.operations[i] = Operation.decode(stream);
        }
        decodedTransaction.ext = TransactionExt.decode(stream);
        return decodedTransaction;
    }

    public int hashCode() {
        return Objects.hashCode(this.sourceAccount, this.fee, this.seqNum, this.timeBounds, this.memo, Arrays.hashCode(this.operations), this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)object;
        return Objects.equal(this.sourceAccount, other.sourceAccount) && Objects.equal(this.fee, other.fee) && Objects.equal(this.seqNum, other.seqNum) && Objects.equal(this.timeBounds, other.timeBounds) && Objects.equal(this.memo, other.memo) && Arrays.equals(this.operations, other.operations) && Objects.equal(this.ext, other.ext);
    }

    public static class TransactionExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, TransactionExt encodedTransactionExt) throws IOException {
            stream.writeInt(encodedTransactionExt.getDiscriminant());
            switch (encodedTransactionExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            TransactionExt.encode(stream, this);
        }

        public static TransactionExt decode(XdrDataInputStream stream) throws IOException {
            TransactionExt decodedTransactionExt = new TransactionExt();
            Integer discriminant = stream.readInt();
            decodedTransactionExt.setDiscriminant(discriminant);
            switch (decodedTransactionExt.getDiscriminant()) {
                default: 
            }
            return decodedTransactionExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof TransactionExt)) {
                return false;
            }
            TransactionExt other = (TransactionExt)object;
            return Objects.equal(this.v, other.v);
        }

        public static final class Builder {
            private Integer discriminant;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public TransactionExt build() {
                TransactionExt val = new TransactionExt();
                val.setDiscriminant(this.discriminant);
                return val;
            }
        }
    }

    public static final class Builder {
        private MuxedAccount sourceAccount;
        private Uint32 fee;
        private SequenceNumber seqNum;
        private TimeBounds timeBounds;
        private Memo memo;
        private Operation[] operations;
        private TransactionExt ext;

        public Builder sourceAccount(MuxedAccount sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public Builder fee(Uint32 fee) {
            this.fee = fee;
            return this;
        }

        public Builder seqNum(SequenceNumber seqNum) {
            this.seqNum = seqNum;
            return this;
        }

        public Builder timeBounds(TimeBounds timeBounds) {
            this.timeBounds = timeBounds;
            return this;
        }

        public Builder memo(Memo memo) {
            this.memo = memo;
            return this;
        }

        public Builder operations(Operation[] operations) {
            this.operations = operations;
            return this;
        }

        public Builder ext(TransactionExt ext) {
            this.ext = ext;
            return this;
        }

        public Transaction build() {
            Transaction val = new Transaction();
            val.setSourceAccount(this.sourceAccount);
            val.setFee(this.fee);
            val.setSeqNum(this.seqNum);
            val.setTimeBounds(this.timeBounds);
            val.setMemo(this.memo);
            val.setOperations(this.operations);
            val.setExt(this.ext);
            return val;
        }
    }
}

