/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;

public enum ThresholdIndices {
    THRESHOLD_MASTER_WEIGHT(0),
    THRESHOLD_LOW(1),
    THRESHOLD_MED(2),
    THRESHOLD_HIGH(3);

    private int mValue;

    private ThresholdIndices(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    static ThresholdIndices decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return THRESHOLD_MASTER_WEIGHT;
            }
            case 1: {
                return THRESHOLD_LOW;
            }
            case 2: {
                return THRESHOLD_MED;
            }
            case 3: {
                return THRESHOLD_HIGH;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    static void encode(XdrDataOutputStream stream, ThresholdIndices value) throws IOException {
        stream.writeInt(value.getValue());
    }
}

