/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum StellarValueType implements XdrElement
{
    STELLAR_VALUE_BASIC(0),
    STELLAR_VALUE_SIGNED(1);

    private int mValue;

    private StellarValueType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static StellarValueType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return STELLAR_VALUE_BASIC;
            }
            case 1: {
                return STELLAR_VALUE_SIGNED;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, StellarValueType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        StellarValueType.encode(stream, this);
    }
}

